/***************************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]                   *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                              *
 * dario.bini@unipi.it, beatrice.meini@unipi.it, steffe@cs.dm.unipi.it     *
 * Dipartimento di Matematica - Universita' di Pisa                        *
 * Largo Pontecorvo 5                                                      *
 * 56127 Pisa                                                              *
 * Italy                                                                   *
 * Version 2.2 - March 2024                                             *
***************************************************************************

 *
 *  view_pi.h - view pi vector  - both callbacks and interfaces
 *
 */

/*prototypes view_pi.h */
void create_view_pi_window(void);
void on_view_pi_menu_quit_activate   (GtkMenuItem  *, gpointer );
void on_view_pi_destroy_activate   (GtkWidget  *, gpointer );
gboolean on_view_pi_delete_activate   (GtkWidget  *, GdkEvent  * ,gpointer );
gboolean on_view_pi_state_print (GtkWidget  *, GdkEvent  * ,gpointer );
void on_view_pi_menu_rescale_activate   (GtkMenuItem  *, gpointer );
void on_view_pi_menu_log_activate   (GtkMenuItem  *, gpointer );

void draw_view_pi_area(GtkWidget *, GdkEventExpose *, gpointer);
void pi_image_compute(struct viewpi_str *);
GtkWidget* create_dialog_nogo1(GtkWidget* );
GtkWidget* create_dialog_nogo2(GtkWidget* );

/* prototipes ponte.f90 */
void read_matpi0_(int *, double *);
void read_matpi_(int *, int *,double *);

/* prototypes rw.c */

/* globals view_pi.c */
int HPL, VPL; /* drawing area dimensions */

/* globals main.c */
extern int is_debug;

/* globals interface.c */
extern struct running_problem_str  completed; /* we save data here after successfully allocate the matrices with the data in committed */

/* globals main.c */
extern GtkWidget *window_main;       /* main window */
extern int is_smallscr;

/*********************************************/
