##########################################################################
#  Structured Markov Chains Solver       [  SMCSolver  ]                 #
#  Dario Bini, Beatrice Meini, Sergio Steffe'                            #
#  dario.bini@unipi.it, beatrice.meini@unipi.it, steffe@cs.dm.unipi.it   #
#  Dipartimento di Matematica  - Universita' di Pisa                     # 
#  Largo Pontecorvo 5                                                    #  
#  56127 Pisa                                                            # 
#  Italy                                                                 # 
#  Version 2.2 - March 2024                                              #
##########################################################################
# 
#     make.inc
# 
##############################################################
#
#   C Compiler is gcc : uncomment the correct line for your system 
#CC=gcc-12
CC=gcc
#
CFLAGS=-Wall -Wno-deprecated-declarations
#
#   distributions tar name needs this string
#
DATESTRING=`date +"%Y.%m.%d-%H"`
#
#   Archiver for libxxx.a and ranlib, use echo if not present
#
ARCH     = ar
ARCHFLAGS= cr
#RANLIB   = echo
RANLIB = ranlib
#
#
# to use the included minimum set of blas and lapack and lapack95 routines
# use the followind path for libraries and for modules directory:
#
BLAS_LAPACK_LIB_DIR=min_blas_lapack
BLAS_LAPACK_MOD_DIR=min_blas_lapack
#
# otherwise let it point to your directory, and comment out the make of
# the libraries in Makefile
#
BLASLIB = $(BLAS_LAPACK_LIB_DIR)/libblas.a
LAPACKLIB =$(BLAS_LAPACK_LIB_DIR)/liblapack.a
LAPACK95LIB = $(BLAS_LAPACK_LIB_DIR)/liblapack95.a
LAPACKMOD = $(BLAS_LAPACK_MOD_DIR)/f77_lapack.mod  $(BLAS_LAPACK_MOD_DIR)/f95_lapack.mod \
	 $(BLAS_LAPACK_MOD_DIR)/la_auxmod.mod   $(BLAS_LAPACK_MOD_DIR)/la_precision.mod
#
#
##
#   gfortran GNU Fortran Compiler (64 bits CPU) gfortran-10 or newer
#
FF= gfortran
#   leave blank this
LAHEY=
#   choose optimization level
#FFOPT=
FFOPT=-O2
#   -fzero to set up to 0 new variables
#FFLAGSM= -Wall -fzero $(FFOPT)
FFLAGSM= -Wall  $(FFOPT)
#FFLAGSG= -Wall -fzero $(FFOPT)
FFLAGSG= -Wall  $(FFOPT)
#   to let Fortran and C routines interact the external names
#   must agree, and in some routine the second underscore must
#   not be added by g95 compiler
#NOSECOND=-fno-second-underscore
#   blas, lapack, lapack95, and its Fortran 95 modules 
#   must be compiled with the same Fortran Compiler g95.
#
FFLIBS= -I$(BLAS_LAPACK_MOD_DIR)  -L$(BLAS_LAPACK_LIB_DIR) -llapack95 -llapack -lblas
#
#

