/***************************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]                   *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                              *
 * dario.bini@unipi.it, beatrice.meini@unipi.it, steffe@cs.dm.unipi.it     *
 * Dipartimento di Matematica - Universita' di Pisa                        *
 * Largo Pontecorvo 5                                                      *
 * 56127 Pisa                                                              *
 * Italy                                                                   *
 * Version 2.2 - March  2024                                             *
***************************************************************************

 *
 *  interfaces.h  - most graphical interfaces, except help
 *
 */

/* prototypes interfaces.c */
GtkWidget* create_window_main (void);
GtkWidget* create_window_examples (int);
GtkWidget* create_window_parameters(int);
GtkWidget * create_window_pi_parameters(void);


/* prototypes callback.c  */
void on_main_menu_reada_activate (GtkMenuItem *, gpointer );
void on_main_menu_readb_activate (GtkMenuItem *, gpointer );
void on_main_menu_savea_activate (GtkMenuItem *, gpointer );
void on_main_menu_saveb_activate (GtkMenuItem *, gpointer );
void on_main_menu_saveg_activate (GtkMenuItem *, gpointer );
void on_main_menu_saver_activate (GtkMenuItem *, gpointer );
void on_main_menu_saveu_activate (GtkMenuItem *, gpointer );
void on_main_menu_savegru_activate (GtkMenuItem *, gpointer );
void on_main_menu_savepi_activate (GtkMenuItem *, gpointer );
void on_main_menu_savepad_activate (GtkMenuItem *, gpointer );
void on_main_menu_clearpad_activate(GtkMenuItem *, gpointer );
void on_main_menu_quit_activate    (GtkMenuItem *, gpointer );
void on_main_menu_destroy_activate   (GtkWidget  * , gpointer );
void on_main_menu_run_activate     (GtkMenuItem *, gpointer );
void on_main_menu_stop_activate    (GtkMenuItem *, gpointer );
void on_main_menu_edit_a_activate (GtkMenuItem *, gpointer);
void on_main_menu_edit_b_activate    (GtkMenuItem *, gpointer );
void on_main_menu_view_matrix_activate(GtkMenuItem *, gpointer);
void on_main_menu_view_pi_activate(GtkMenuItem *, gpointer);
/* void on_main_menu_pause_activate (GtkMenuItem *, gpointer );*/
void on_main_menu_about_activate   (GtkMenuItem *, gpointer );
void on_main_menu_help_activate    (GtkMenuItem *, gpointer );
void on_main_menu_quit_enter       (GtkMenuItem *, gpointer );
void on_main_menu_quit_leave       (GtkMenuItem *, gpointer );
void on_main_menu_problem_gm1      (GtkMenuItem *, gpointer );
void on_main_menu_problem_mg1      (GtkMenuItem *, gpointer );
void on_main_menu_problem_qbd      (GtkMenuItem *, gpointer );
void on_main_menu_problem_example_n    (GtkMenuItem *, gpointer );
void on_main_menu_preproc_noshift     (GtkMenuItem *, gpointer );
void on_main_menu_preproc_shift     (GtkMenuItem *, gpointer );
void on_main_menu_preproc_taushift     (GtkMenuItem *, gpointer );
void on_main_menu_preproc_dbshift     (GtkMenuItem *, gpointer );
void on_main_menu_preproc_autodual     (GtkMenuItem *, gpointer );
void on_main_menu_preproc_ramadual     (GtkMenuItem *, gpointer );
void on_main_menu_preproc_brigthdual     (GtkMenuItem *, gpointer );
void on_main_menu_preproc_nodual     (GtkMenuItem *, gpointer );
void on_main_menu_preproc_doubledual     (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_cyclicr_basic (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_cyclicr_diag (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_logarithmicr_basic (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_logarithmicr_gth (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_natural (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_traditional (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_Ubased (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_invarsubsp_basic (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_invarsubsp_balzer (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_invarsubsp_schur (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_newton (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funz_0 (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funz_1 (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funz_u (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funz_readX(GtkMenuItem *, gpointer );
void on_main_menu_goals_qbd_g (GtkMenuItem *, gpointer );
void on_main_menu_goals_qbd_gr (GtkMenuItem *, gpointer );
void on_main_menu_goals_qbd_gru (GtkMenuItem *, gpointer );
void on_main_menu_goals_qbd_grupi (GtkMenuItem *, gpointer );
void on_main_menu_goals_mg1_g (GtkMenuItem *, gpointer );
void on_main_menu_goals_mg1_gpi  (GtkMenuItem *, gpointer );
void on_main_menu_goals_gim1_r (GtkMenuItem *, gpointer );
void on_main_menu_goals_gim1_rpi (GtkMenuItem *, gpointer );
void on_main_menu_goals_pi_param (GtkMenuItem *, gpointer );
void on_main_menu_options_verbose (GtkMenuItem *, gpointer );
void on_main_menu_options_debug (GtkMenuItem *, gpointer );
void on_main_menu_options_timings (GtkMenuItem *, gpointer );
void on_main_menu_options_small (GtkMenuItem *, gpointer );
void on_main_menu_options_situation (GtkMenuItem *, gpointer );
void on_main_menu_options_eigth_d (GtkMenuItem *, gpointer );
void on_main_menu_options_fifteen_d (GtkMenuItem *, gpointer );
void on_main_menu_options_sixteen_d (GtkMenuItem *, gpointer );
void on_main_menu_options_seventeen_d (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_cr (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_lr (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_fi (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_is (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_nt (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_reset (GtkMenuItem *, gpointer );

void on_examples_quit_activate    (GtkButton *, gpointer  );
void on_examples_ok_activate      (GtkButton *, gpointer  );

void on_dimension_m_entry_changed  (GtkEntry *, gpointer );
void on_dimension_n_entry_changed  (GtkEntry *, gpointer );
void on_array_n_entry_changed  (GtkEntry *, gpointer );
void on_blocks_n_entry_changed  (GtkEntry *, gpointer);
void on_parameters_quit_activate (GtkButton *, gpointer);
void on_parameters_destroy_activate (GtkWidget  *ww, gpointer data);
void on_examples_destroy_activate (GtkWidget  *ww, gpointer data);
void on_examples_alpha_activate(GtkEntry *, gpointer );
void on_examples_alpha_change(GtkEntry *, gpointer );
void on_examples_alpha_e_change(GtkEntry *, gpointer );
void on_examples_beta_activate(GtkEntry *, gpointer );
void on_examples_beta_change(GtkEntry *, gpointer );
void on_examples_beta_e_change(GtkEntry *, gpointer );
void on_parameters_ok_activate (GtkButton *, gpointer);
void on_parameters_reset_activate (GtkButton *, gpointer);
void on_parameters_entry_itermax_changed (GtkEntry *, gpointer );
void on_parameters_entry_interpmax_changed (GtkEntry *, gpointer );
void on_parameters_entry_errmax_changed (GtkEntry *, gpointer );
void on_pi_parameters_quit_activate (GtkButton *, gpointer);
void on_pi_parameters_destroy_activate (GtkWidget  *ww, gpointer data);
void on_pi_parameters_ok_activate (GtkButton *, gpointer);
void on_pi_parameters_reset_activate (GtkButton *, gpointer);
void on_parameters_entry_epspi_changed(GtkButton *, gpointer);
void on_parameters_entry_maxnc_changed(GtkButton *, gpointer);

void update_completed(void);
void invalidate_completed(void);
gboolean on_delete_event_do   (GtkWidget *, GdkEvent *, gpointer);

/* prototypes padwrite.c */
void selection_uptodate(void);
void selection_uptodaten(void);

/* prototypes rw.c   */
void on_ok_button_fsg_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fsg_clicked      (GtkButton   *, gpointer  );
GtkWidget* create_fileselection_g(void);
GtkWidget* create_fileselection_gru(void);
GtkWidget* create_fileselection1 (void);
GtkWidget* create_dialog_nowritable(void);

/* prototypes futils.f90 */
void read_mata_(int *,int *,int *, double *);
void ssdebug_(int *);

/* globals interfaces.c */
GtkWidget *menuitem_mg1; 
GtkWidget *menuitem_gim1; 
GtkWidget *menuitem_qbd; 

extern GtkWidget *noshift_m;
extern GtkWidget *simpleshift_m;
extern GtkWidget *taushift_m;
extern GtkWidget *doubleshift_m;
extern GtkWidget *autodual_m;
extern GtkWidget *brigthdual_m;
extern GtkWidget *ramadual_m;
extern GtkWidget *bothdual_m;
extern GtkWidget *nodual_m;

extern GtkWidget *cyclicr_basic_m;
extern GtkWidget *cyclicr_diagadj_m;
extern GtkWidget *logarithmicr_basic_m;
extern GtkWidget *logarithmicr_gth_m;
extern GtkWidget *funciter_natural_m;
extern GtkWidget *funciter_traditional_m;
extern GtkWidget *funciter_Ubased_m;
extern GtkWidget *invarsubsp_basic_m;
extern GtkWidget *invarsubsp_balzer_m;
extern GtkWidget *invarsubsp_schur_m;
extern GtkWidget *menuitem_newton;

extern GtkWidget *funz_starting_m;

extern GtkWidget *textview;
extern GtkWidget *statusb;
extern GtkWidget *window_examples;
extern GtkWidget *dimension_m_entry;
extern GtkWidget *dimension_n_entry;
extern GtkWidget *alpha_entry;
extern GtkWidget *beta_entry;
extern GtkWidget *howmany_a_entry;
extern GtkWidget *statusb_examples;
extern GtkWidget *handlebox_s; /* to show the situation of all choice made */
extern GtkWidget *label_s1, *label_s2, *label_s3, *label_s4, *label_s5, *label_s6; /* to keep situation up to date */
extern GtkWidget * window_parameters; 
extern GtkWidget  *parameters_entry_itermax,*parameters_entry_interpmax,*parameters_entry_errmax; /* parameters window entry */
extern GtkWidget * window_pi_parameters;
extern GtkWidget  *parameters_entry_maxnc,*parameters_entry_epspi; 
extern int is_saveg_open;      /* 0 = not open 1 = open */
extern int is_about_open;   /* 0 = not open 1 = open */
extern int is_help_open;    /* 0 = not open 1 = open */
extern int is_savepad_open; /* 0 = not open 1 = open */
extern int is_edit_a_open;  /* 0=not open  1=open */
extern int is_edit_b_open;  /* 0=not open  1=open */
extern int is_view_matrix_open; /* 0=not open  1=open */
extern int is_view_pi_open; /* 0=not open  1=open */
extern int is_pi_parameters_open; /* 0=not open  1=open */
extern int is_readX_open; /* 0=not open  1=open */
extern int is_running;      /* 0 = not running 1 = running */
extern int is_completed;      /* 1 if computation did complete 0 if it is not completed yet */
extern int is_situation;    /* 0 = not show 1= show situation bar */
extern int is_verbose;  /* 1= verbose, 0= not verbose */
extern int is_debug;    /* 1= debugging output active on console 0=normal */
extern int is_timings;  /* 1= internal timing of fortran routines 0=normal */
extern int fifosi, fifoin, fifoout, fifomax;                 /* using FIFO to write Notepad in Main Window asyncronously */
extern char fifostr[64000][120];                                 /* using FIFO to write Notepad in Main Window asyncronously */

extern pthread_t my_thread_main;

extern int is_examples_open; /* 0 = not open 1 = open */
extern int dimension_m;  /* used bye examples window */
extern int dimension_n;  /* used bye examples window */
extern int matrix_a_num; /* used bye examples window */
extern int matrix_b_num; /* used bye examples window */

/* double alpha_in_mant;     used bye examples window */
/* double alpha_in_exp;      used bye examples window */
extern double alpha_in;         /*  used bye examples window */
/* double beta_in_mant;      used bye examples window */
/* double beta_in_exp;       used bye examples window */
extern double beta_in;          /* used bye examples window */

extern struct algorithms_str algorithms_choice;
extern struct goals_str goals_choice;
extern struct running_problem_str committed, selected, completed; /* we save data here after successfully allocate the matrices with the data in committed */
extern struct edita_str pea,peb;   /* preferences edit_a window */
extern struct edita_str pview; /* preferences view windows */
extern char digits_to_save[64]; /* string corresponding to the number format chosen to write in files */

/* globals rw.c */
extern GtkWidget *saveg_fs;          /* File Selection Dialog for saving G */
extern GtkWidget *appendsave;        /* File Selection Dialog for saving Notepad  Main Window */

extern int is_saveg_open;      /* 0 = not open 1 = open */
extern int is_saver_open;      /* 0 = not open 1 = open */
extern int is_saveu_open;      /* 0 = not open 1 = open */
extern int is_savegru_open;      /* 0 = not open 1 = open */

/* globals main.c */
extern GtkWidget *window_main;
extern int is_smallscr;

/* globals callback.c */
extern struct parameters_str max[6],min[6],deflt[6],choice[6]; /* default parametres for each algorithm  */
extern char param_interp_str[9][256], param_err_str[12][256]; /* actual strings used in combo */
extern struct pi_parameters_str pi_max,pi_min,pi_deflt,pi_choice; /* default parametres for pi parameters setup */

/*globals view_mat.c */
extern int fake_dim; /* 4 */
extern double fake_matrix[26]; /* fake matrix to load in event of missing data  fortran style indexes 4 x 4 */

