/***************************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]                   *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                              *
 * dario.bini@unipi.it, beatrice.meini@unipi.it, steffe@cs.dm.unipi.it     *
 * Dipartimento di Matematica - Universita' di Pisa                        *
 * Largo Pontecorvo 5                                                      *
 * 56127 Pisa                                                              *
 * Italy                                                                   *
 * Version 2.2 - March  2024                                             *
***************************************************************************

 *
 *  edit-a.h - view and edit A  - both callbacks and interfaces
 *
 */


/* prototypes edit_a.c  */
void create_edit_a_window(void);
void on_edit_a_menu_quit_activate   (GtkMenuItem  *, gpointer );
void on_edit_a_menu_destroy_activate   (GtkWidget  *, gpointer );
gboolean draw_matarea_callback (GtkWidget *, GdkEventExpose *, gpointer );
gboolean xy_matarea (GtkWidget *, GdkEventExpose *, gpointer );
gboolean button_press_matarea (GtkWidget *, GdkEventExpose *, gpointer );
void on_edit_a_button_up_activate (GtkButton   *, gpointer  );
void on_edit_a_button_down_activate (GtkButton   *, gpointer  );
void on_edit_a_block_entry_changed  (GtkEntry *, gpointer );
void on_edit_a_block_entry_activated  (GtkEntry *, gpointer );
void on_edit_a_pos_neg_activate(GtkButton *, gpointer );
void on_edit_a_color_activate(GtkButton *, gpointer);
void on_edit_a_enhance_activate(GtkButton *, gpointer);
void on_edit_a_contrast_changed(GtkEntry *, gpointer );
void on_edit_a_user_activate(GtkButton *, gpointer);
void on_edit_a_range_normal_activate(GtkButton *, gpointer);
void on_edit_a_range_block_activate(GtkButton *, gpointer);
void on_edit_a_range_adaptive_activate(GtkButton *, gpointer);
void on_edit_a_transpose_activate(GtkButton *, gpointer);
void on_edit_a_normalize_activate(GtkButton *, gpointer);
void on_edit_a_truncate_activate(GtkButton *, gpointer);
void on_edit_a_exchange_activate(GtkButton *, gpointer);
void on_edit_a_float_entry_activate(GtkEntry *, gpointer);
void image_compute(int );
void draw_matarea(void);

int a_labels_update(void);
int a_edit_status_update(void);
double st_def(void);
double abmax(int);
double abmin(int);
double abqmin(int);
double aamax(void);
double aamin(void);
void abtrunc(int );
void aatrunc(void);
void max_min_ab_compute(void);

void gray_levels_setup(double); /* setup of  gray_levels */
int get_gray_level(double); 
void recompute_levels(double); /*adaptive case levels recompute (with contrast) */

double st_def_b(int ); /* B stocasticity */
double bbbmin(void);  /* B0, BN1, B minimun */

/* prototypes callback.c */
gboolean on_delete_event_do   (GtkWidget *, GdkEvent *, gpointer);

/* prototipes ponte.f90 */
void read_mata_(int *,int *,int *, double *);
void write_mata_(int *,int *,int *, double *);
void transpose_mata_(void);
void normalize_mata_(void);
void read_matb_(int *,int *,int *, double *);
void write_matb_(int *,int *,int *, double *);
void read_matb0_(int *,int *, double *);
void write_matb0_(int *,int *, double *);
void read_matbn1_(int *,int *, double *);
void write_matbn1_(int *,int *, double *);


/* prototypes rw.c */
int watch_for_number(int , int , char *);

/* globals  edit_a.c  */
GtkWidget * window_edit_a;
GtkWidget  *matarea;
GtkWidget *statusb_edita; 
GtkWidget   *entry_ij; 
GtkWidget   *entry_aij;
GtkWidget *entry_block;
GtkWidget *label_space;
GtkWidget *edit_label_user;
GtkWidget *label_222, *label_231, *label_232;
GtkWidget *button_range_normal;
GtkWidget *button_range_block;
GtkWidget *edit_vbox12,*edit_vbox13;
double gray_levels[256]; /* non equispaced levels method */
int numlev[256]; /* number of points in levels */
char SBUF[256]; /* statusbar buffer used by a_edit_status_update() */
int a_selected_block,a_computed_block,a_displayed_block,no_block_selected;
unsigned char *matvalue; /* allocated in create_edit_a_window, used by drawing routines */
guchar *rgb_matvalue; /* allocated in create_edit_a_window, used by drawing routines */
double *as, asmax,asmin;       /* allocated in create_edit_a_window, sum of rows of block and maximum value of bock */
double matabmax, matabmin,matabqmin; /*   maximum , minimum and non zero minimum value in the bock */
int is_freeze_aij;       /* 0=not freeze, 1= freeze entry i,j A and permit editing A value */
int is_frozen_i,is_frozen_j; /* values when frozen */
double is_frozen_a;	     

/* globals interface.c */
extern int is_edit_a_open;  /* 0=not open  1=open */
extern int is_debug;    /* 1= debugging output active on console 0=normal */
extern struct running_problem_str committed;
extern struct edita_str pea; /* preferences edit a */

/* globals main.c */
extern int is_smallscr;
