/***************************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]                   *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                              *
 * dario.bini@unipi.it, beatrice.meini@unipi.it, steffe@cs.dm.unipi.it     *
 * Dipartimento di Matematica - Universita' di Pisa                        *
 * Largo Pontecorvo 5                                                      *
 * 56127 Pisa                                                              *
 * Italy                                                                   *
 * Version 2.2 - March  2024                                             *
***************************************************************************

 *
 *  doc.h
 *
 */

/* globals for help.c */
const gchar docu10[] = {"\n\n\t\t\tSTRUCTURED MARKOV CHAINS SOLVER\n\n\t\tDario Bini, Beatrice Meini, Sergio Steffe\'\n\t\tdario.bini@unipi.it, beatrice.meini@unipi.it, steffe@cs.dm.unipi.it"};
const gchar docu11[] = {"\n\t\tDipartimento di Matematica \n\t\tUniversita\' di Pisa, Pisa,\tItaly\n\t\tVersion 2.2     March 2024"};
const gchar docu12[] = {"\n\n\t\t\tThis software is part of a joint research collaboration with \n\n\t\tBenny Van Houdt\n\t\tDepartment of Mathematics and Computer Science\n\t\tUniversity of Antwerp\n\t\tAntwerpen, Belgium"};
const gchar docu13[] = {"\n\n\t\t\tVersion 1.1 has been presented at the workshop:\n\n\t\tSMCTOOLS:\tTools for solving Structured Markov Chains\n\t\t\torganized within the VALUETOOLS 2006 Conference,\n"};
const gchar docu14[] = {"\t\t\t\tPisa, Italy -  October 10, 2006"};
const gchar docu15[] = {"\n\n\t\t\tVersion 2.1 has been presented at the workshop:\n\n\t\tSMCTOOLS:\tTools for solving Structured Markov Chains\n\t\t\torganized within the VALUETOOLS 2009 Conference,\n"};
const gchar docu16[] = {"\t\t\t\tPisa, Italy -  October 19, 2009"};
const gchar docu17[] = {"\n\n\t\t\tVersion 2.2 has only minor changes to cope with 2024 compilers"};
const gchar docu18[] = {""};
const gchar docu19[] = {""};

const gchar docu20[] = {"\n\n\t\t\tSMCSolver (STRUCTURED MARKOV CHAINS SOLVER)\n\n\t\t SMCSolver is a software tool for solving some classes of Markov Chains frequently encountered in queuing models."};
const gchar docu21[] = {"\n\n\t\tIt includes several algorithms to solve  (following the Kendall classification) M/G/1 and GI/M/1-type Markov chains, and quasi-birth-death (QBD) processes."};
const gchar docu22[] = {"\n\n\t\tThis software is part of a joint work, which includes a Matlab Toolbox written by Benny Van Houdt, available at http://www.win.ua.ac.be/~vanhoudt/ and a Fortran 90 version."};
const gchar docu23[] = {"\n\n\t\tThe Fortran 90 version is provided with a  graphical interface which allows a user friendly access to the Fortran Routines. This interface is written in C and relies on the GTK+ library."};
const gchar docu24[] = {"\n\t\tThe current version runs on Linux Workstations only."};
const gchar docu25[] = {"\n\n\t\tA more detailed description on the Problems, the Algorithms and the Software can be found in the papers [2], [3] and [4] (see the Bibliography) of the proceedings of the SMCTools workshops 2006 and 2009."};
const gchar docu26[] = {""};
const gchar docu27[] = {"\n\n\t\t"};
const gchar docu28[] = {""};
const gchar docu29[] = {""};

const gchar docu30[] = {"\n\n\t\t\tM/G/1-type Problems: "};
const gchar docu31[] = {"\n\n\t\tA sequence of nonnegative square matrices, [AN1], [A0], [A1], [A2], ...\n\n\t\tis given such that ( [AN1] + [A0] + [A1] + [A2] +  ... ) is irreducible and row stochastic."};
const gchar docu32[] = {"\n\n\t\tIn order to compute the minimal nonnegative solution G of the matrix equation:"};
const gchar docu33[] = {"\n\n\t\t\t\t\t[G] = [AN1] + [A0][G] + [A1][G]^2 + [A2][G]^3 + ..."};
const gchar docu34[] = {"\n\n\t\tThe following algorithms are used:"};
const gchar docu35[] = {"\n\t\t\tCyclic Reduction:   optional shift accelerations. "};
const gchar docu36[] = {"\n\t\t\tFunctional Iteration:    natural, traditional or U-based; \n\t\t\t\t\t\tzero or unit starting point;  optional shift acceleration\n\t\t\tInvariant Subspace:    optional Balzer acceleration, optional Schur decomposition\n\t\t\tNewton Iteration:"};
const gchar docu37[] = {"\n\n\t\tThe computation of the steady state vector pi is performed by means of the Ramaswami formula and requires additional matrices"};
const gchar docu38[] = {"\n\t\t\t[B0], [BN1], [B1], [B2], ...\n\n\n\t\tThe following transforms are available: None or Both Ramaswami and Bright duals; Auto Dual will perform the best choice.\n\n"};
const gchar docu39[] = {""};

const gchar docu40[] = {"\n\n\t\t\tGI/M/1-type Problems: "};
const gchar docu41[] = {"\n\n\t\tA sequence of nonnegative square matrices, [A1], [A0], [AN1], [AN2], ...\n\n\t is given where ( [A1] + [A0] + [AN1] + [AN2] +  ... ) is irreducible and row stochastic."};
const gchar docu42[] = {"\n\n\t\tIn order to compute the minimal nonnegative solution R of the following matrix equation:"};
const gchar docu43[] = {"\n\n\t\t\t\t\t[R] = [A1] + [R][A0] + [R]^2 [AN1] + [R]^3[AN2] + ..."};
const gchar docu44[] = {"\n\n\t\tThe following algorithms are used:"};
const gchar docu45[] = {"\n\t\t\tCyclic Reduction:   optional shift accelerations. "};
const gchar docu46[] = {"\n\t\t\tFunctional Iteration:    natural, traditional or U-based; \n\t\t\t\t\t\tzero or unit starting point or optional shift acceleration\n\t\t\tInvariant Subspace:    optional Balzer acceleration, optional Schur decomposition\n\t\t\tNewton Iteration:\n\n"};
const gchar docu47[] = {"\n\n\t\tThe computation of the steady state vector pi is performed by means of the Ramaswami formula and requires additional matrices"};
const gchar docu48[] = {"\n\t\t\t[B0], [BN1], [B1], [B2], ...\n\n\n\t\tThe following transforms are available:  Ramaswami dual or Bright dual; Auto Dual will perform the best choice.\n\n"};
const gchar docu49[] = {""};

const gchar docu50[] = {"\n\n\t\t\tQBD (Quasi-Birth-Death Markov Chains) Problems: "}; 
const gchar docu51[] = {"\n\n\t\tThree square nonnegative matrices, [AN1], [A0] and [A1] are given\n\t\t such that ( [AN1] + [A0] + [A1] ) is irreducible and row stochastic."};
const gchar docu52[] = {"\n\n\t\tIn order to compute the nonnegative minimal solutions [G], [R], [U] of the matrix equations:\n"};
const gchar docu53[] = {"\n\n\t\t\t\t\t[G] = [AN1] + [A0] [G] + [A1] [G]^2"};
const gchar docu54[] = {"\n\n\t\t\t\t\t[R] = [A1] + [R] [A0] + [R]^2 [AN1]"};
const gchar docu55[] = {"\n\n\t\t\t\t\t[U] = [A0] + [A1] (I-[U])^(-1) [AN1]"};
const  gchar docu56[] = {"\n"};
//const gchar docu56[] = {"\n\n\t\tWe are looking for either [G] (solving the first equation), or [G] and [R] (solving the first and second equation), or [G]  [R] and [U] (solving all three equations)."};
const gchar docu57[] = {"\n\n\t\tThe following algorithms are used:"};
const gchar docu58[] = {"\n\t\t\tCyclic Reduction:   optional shift accelerations, diagonal adjustment. \n\t\t\tLogarithmic Reduction:  optional shift accelerations, diagonal adjustment. "};
const gchar docu59[] = {"\n\t\t\tFunctional Iteration:    natural, traditional or U-based; \n\t\t\t\t\t\tzero or unit starting point; optional shift acceleration\n\t\t\tInvariant Subspace:    optional Balzer acceleration, optional Schur decomposition\n\t\t\tNewton Iteration:\n\n\n\n\t\tComputing the steady state probability vector pi, requires additional matrices:\n\t\t\t[B0], [BN1], [B1]"};

const gchar docu60[] = {"\n\n\t\t\tFirst Step: Choose and Load the Problem\n\n\t\tThe data can be read from the menu \'File\' by choosing one of the three options\n\t\t\tRead Input A (QBD Problem)\n\t\t\tRead Input A (M/G/1 Problem)\n\t\t\tRead Input A (GI/M/1 Problem)\n\tand by typing the file name where the entries of the blocks of kind A are stored."};
const gchar docu61[] = {"\n\tThe values of the blocks of kind B are read separately by choosing \'Read Input B\' from the menu \'File\'\n\tMessages concerning the read operations are printed in the bottom bar of the window. The central bar provides information about the problem, the data, the algorithm and the goals of the computation.\n\t Some examples can be loaded directly by the menu \'Examples\' where also a short description is provided."};
const gchar docu62[] = {"\n\n\t\t\tSecond Step: Choose Algorithm, Preprocessing options and Goals\n\n\tFrom the menu \'Algorithms\' it is possible to select the algorithm and modify the values of the parameters, like the maximum number of iterations, the error bound etc. The menu \'Preprocessing\' allows to choose shift acceleration, and to perform dual transforms of the problem. From the menu \'Goals\' it is possible to chose the goal of the computation separately for QBD, M/G/1 and GI/M/1 problems, together with the number of block components of the vector pi which have to be computed."};
const gchar docu63[] = {"\n\n\t\t\tThird Step: Choose running options and Run\n\n\tOptions \'Verbose\' and \'Timings\' are obvious (note that on older systems cpu time is erroneously set equal to the elapsed time); the output of debugging is displayed in the terminal (or virtual terminal) from which the program SMCSolver has been run. Debugging is useful just for detecting software errors; it is of no interest for the user.\n\tThe algorithm is executed by clicking on the \'Run\' button or by selecting \'Run\' from the menu \'Execute\'.\n\tOnce the program is run, a new thread is created and the  Fortran Routines start computing G/R/U/Pi as required.\n\tThe graphical front-end remains active in its thread, and some commands from the menu can be executed like the command Stop, or opening and browsing the on-line Help.\n\tOn the scrollable view-port of the main window, i.e., the Notepad, some information concerning the execution of the program are displayed."};
const gchar docu64[] = {"\n\n\t\tAdditional Features\n\n\t\t\tNotepad\n\n\tThe Notepad can be cleaned and saved. When saving the notepad, the program does not overwrite an existing file, it just appends the notepad content to the file. The notepad content is not directly editable, but short parts can be selected and copied to other editors via the usual cut & paste of X11."};
const gchar docu65[] = {"\n\n\t\t\tView and Edit A, B - View G/R/U - View Pi\n\n\tInput and output can be viewed and compared in a graphical way. Matrices are displayed as tables of grey or colored small squares representing the matrix entries.  The default gray/color scale is adaptive, however, the linear scale can be chosen as well. In the adaptive way there is a parameter, called contrast, that changes the exponent of the nonlinear scale.\n\tThe cursor is changed into a cross when the mouse is moved inside the matrix display area. At the same time, the numerical value of the corresponding entry is displayed in a box. Clicking the left button when the cursor is pointing to a matrix entry allows one to store and to edit (only for the View/Edit mode) the numerical value. Special buttons allow to modify the selected block: transposition, normalization, chopping the values to [0,1] and interchanging the order of the blocks are the allowed operations.\n\tIn the View G/R/U mode, a special button allows to read a second matrix from a file and to compare the two matrices, showing the Frobenius norm of their difference.\n\tIn this version the Display Matrix Area of View and Edit and View and Compare have a fixed size. This, by the way, limits the dimensions of the viewable matrices to less than 250."};
const gchar docu66[] = {"\n\n\t\t\tSaving Matrices\n\n\t  All the matrices can be saved in ASCII files. The standard graphical interface of gtk+-2 for reading/writing files offers several 'OK' buttons, each corresponding to a different file format, best suited to be read by Matlab or other Fortran Routines. See the section I/O formats for more detail on the formats.\n\tIn the Option Menu, the number of decimal digits of floating point numbers can be chosen."};
const gchar docu67[] = {"\n\n\t\tNote:\n\n\tSome Languages write numbers with strange conventions: remember to set the LANG environment variable to en_US or en_US.UTF-8 before running SMCSolver, otherwise reading or writing numbers could be incorrect."}; 
const gchar docu68[] = {"\n\t\t"};
const gchar docu69[] = {"\n\t\t"};

const gchar docu70[] = {"\n\n\t\t\tExamples shipped with SMCSolver:"};
const gchar docu71[] = {"\n\n\tSome examples are available in the directory Examples: they can be loaded simply as New QBD Problem or New M/G/1 Problem or New GI/M/1 Problem. Please read the documentation in the same directory."};
const gchar docu72[] = {"\n\n\tSome other Examples are available directly from the menu 'Examples' of the Main Window. Choosing an example of this list opens a new window with a brief description and with the possibility of modifying size and parameters which define the problem."};
const gchar docu73[] = {"\n\n\tEach example can be saved as ASCII file in the standard way."};

const gchar docu80[] = {"\n\n\t\t\tSave G or R or U formats:\n\n\tMatlab ASCII Format:   the floats of a matrix row are written in one line, Matlab counts the number of lines and the number of floats in each line for detecting the number of rows and colums of the matrix.\n\n\tFortran ASCII Format:   the two dimensions (integers) on a line, followed by a line with all the floats, column by column, with a space between floats and at the beginning of each line.\n\n\tFortran ASCII Format (1dim):   only one dimension before the floats, the rest as before; for square matrices there is no ambiguity."};
const gchar docu81[] = {"\n\n\t\t\tSave G,R,U formats:\n\n\tMatlab ASCII Format (new dir):   a new directory is created and the 3 files G R U are saved inside it.\n\n\tFortran ASCII Format:   for each matrix G, R, U we write in sequence in the same file the two dimensions (integers) on a line, followed by all the floats on the following line, column by column, with a space between floats and at the beginning of each line.\n\n\tFortran ASCII Format (1dim):   only one dimension before all the floats of the 3 matrices, with one space between floats "};
const gchar docu82[] = {"\n\n\t\t\tSave Pi formats:\n\n\tMatlab ASCII Format:   the floats of the vector are written in one line.\n\n\tFortran ASCII Format: the dimension of the vector is followed in next line by all the floats,with one space between floats "};
const gchar docu83[] = {"\n\n\t\t\tSave A formats:\n\n\tMatlab ASCII Format (new dir):   a new directory is created and the blocks are saved as files in it with names A00001, A00002, .... etc etc..\n\n\tMatlab ASCII Format (single file):   a single file in Matlab can contain a single matrix: the blocks are set in a row, side by side,, obtainig a single matrix with the same number of colums as a single block, and each row long as a single block row times the number of blocks; in this way matlab can read all the blocks from one file.\n\n\tFortran ASCII Format (#blocks, repeated(2dims+data)):   we write in the first line just the number of blocks (integer) and for each block:  the two dimensions (integers) on a line, followed by a line with all the floats, column by column, with a space between floats and at the beginning of each line.\n\n\tFortran ASCII Format (#blocks, dim + all data):   we write in the first line the number of blocks (integer) and the dimension  (integer) of the blocks, followed by a line with all the floats, block by block, column by column.\n\n\tSparse Matrix ASCII Format: first line #blocks, dims each block (3 integers), following lines #block, row, column, value (3 integers + 1 float), last line 0,0,0,0.0"};
const gchar docu84[] = {"\n\n\t\t\tSave B formats:\n\n\tDepending on the Problem, the B blocks are grouped in a square matrix B0, a rectangular matrix BN1 and a matrix B including several rectangular blocks.\n\tFor each of them there is a choice between a Matlab ASCII Format and a Fortran ASCII Format, similar to these used for saving G or A matrices; in this version we do not include provision for a Sparse Matrix format for B blocks."};
const gchar docu85[] = {"\n\n\t\t\tRead A formats:\n\n\tThe reading program makes a first pass scanning the file for comment lines, text, integers, floats, and attempts to recognize some structure in the file: \n\t\tIf the file contains only floats and each line has the same number of floats, and this number divedes the square of the number of columns, it is considered a Matlab ASCII matrix contining square blocks side by side.\n\t\tIf the file contains sequences of 3 integers and one float and no other floats, it is considered a sparse matrix description: first line (optional) contains 3 integers: #blocks #columns # rows of the blocks; following lines contains  k i j A(i,j,k) with k block index i column j row index; last closing line (optional) 0 0 0 0.0 is ignored.\n\t\tIf the file contains some integers and several floats, the first integer is assumed to be the #blocks, the second the #columns of the (square) blocks, and therefore the program expects that the number of floats is #blocks*#columns*#columns; if this is the case, the program reads all the blocks, in Fortran style, block1, column1, column2...block2,column1, column2....\n\t\tComments line (beginning with # or ! or % or @) are discarted, text is ignored. There will be problems reading correctly very long integers (> 9 digits) or very long float (mantissa > 17 digits or exponent > 3 digits). The presence of ASCII chars > 127 invalidates the file. Comments, text, integers are not allowed in Matlab ASCII matrix files. "};
const gchar docu86[] = {"\n\n\t\t\tRead B formats:\n\n\tQuite similar to the reading of A, but Sparse Matrix ASCII Format is not supported.\n\tB0 must be read first so that the correct dimensioning of BN1 and B blocks can be checked by the program."};
const gchar docu87[] = {"\n\n\t\t\tRead G/R/U formats:\n\n\tAs for matrix A, the reading program makes a first pass scanning the file, discarding comment lines and counting the integers, the floats and the lines. A ASCII Matlab format is assumed if there are n lines with exacly n floats in each line, and nothing else. A Fortran Style ASCII format is assumed if there are exactly n*n floats but not in exactly n lines; comments and some header with some integers (usually the dimension) are allowed.\n\t\tNote that Matlab writes the matrix rows after row, Fortran writes the matrix columns after colums, so a confusion between Matlab and Fortran will result in a trasposed matrix.\n\t\tNote that sparse matrix format is not supported in this case."};
const gchar docu88[] = {""};
const gchar docu89[] = {""};

const gchar docu90[] = {""};
const gchar docu91[] = {"\n\n\tAny bug should be reported by e-mail to the authors."};
const gchar docu92[] = {"\n"};
const gchar docu93[] = {""};
const gchar docu94[] = {""};
const gchar docu95[] = {"\n\t\tIn reporting a bug, please specify if possible:\n\t\t\t--Hardware (CPU, clock, RAM).\n\t\t\t--Software (Linux distribution and version)\n\t\t\t--Compilers (gcc version and Fortran Compiler name and version)\n\t\t\t--gtk+-2 version (pkg-config --modversion  gtk+-2.0)\n\t\t\t--SMCSolver version and source\n\t\t\t--the problem you were testing\n\t\t\t--description as detailed as you can of the bug or strange behaviour or numerical error"};
const gchar docu96[] = {"\n\n\tSuggestion for improvements or simply comments are welcome too !"};
const gchar docu97[] = {"\n\n\n\n\tE-MAILS:  dario.bini@unipi.it, beatrice.meini@unipi.it, steffe@cs.dm.unipi.it\n\n"};

const gchar docu100[] = {"\n\n\t\t\tCompiling SMCSolver_2.2"};
const gchar docu101[] = {"\n\n\tYou will need:\n\n\t\t--A Linux Workstation, complete with usual development programs like\n\t\t\t--GNU gcc, clang, make, and \n\t\t\t--libraries and header files of  gtk+-2, gthread-2.0 ncurses and librt.\n\t\t--A Fortran 95 Compiler like Lahey/Fujitsu (R) lf95, of Intel (R) Fortran Compiler ifort or ifx or GNU gfortran.\n\t\t--the SMCSolver_2.2 sources (get the tgz from http://bezout.dm.unipi.it/SMCSolver/ or from one of the authors by e-mail)"};
const gchar docu102[] = {"\n\n\tUntar the sources, and change the make.inc and the Makefile for your Fortran Compiler.\n\tThe variable FFLIBS must point to your optimized BLAS, LAPACK, LAPACK95 libraries and modules, or to the minimum BLAS+LAPACK+LAPACK95 included in the distribution.\n\tRemember that usually the linker requires that a library has a name beginning with lib (like libblas.a or liblapack.a ) and refers to it with the flags -I (capital i - for modules directory), -L (for library directory), -l (lowercase l - for libraries, like -lblas -llapack)"};
const gchar docu103[] = {"\n\n\t make \n\t\twill compile the program SMCSolver;\n\t make clean  \n\t\twill delete modules, objects and the executable.\n\tSeveral warnings from the compilers are normal.\n\t\t"};
const gchar docu104[] = {"\n\n\tErrors in compilation can arise from several situations:\n\t\t--first (if libraries are missing) fortran compiles blas,lapack,lapack95 files and creates the libraries \n\t\t--then  gcc or clang will compile the 11 C files, without linking. An error at this stage may point to missing headers or non standard gcc or clang on your Linux installation, or corrupt source files.\n\t\t--then the Fortran Compiler will compile the 18 Fortran90 files. It may fail if the Fortran Compiler lines in the Makefile are not correct for your compiler.\n\t\t--last step, the Fortran Compiler has to link all the objects with both static and run time libraries, and this may fail if some library is not available, or if some option in Makefile is not correct for your Fortran Compiler."};
const gchar docu105[] = {"\n\n\tThe compiled program SMCSolver will need several shared run time libraries to execute and will not start if some of these are missing. Moreover several icons and graphical details of the windows are loaded dinamically from files of the running host by gtk+-2.\n\n"};

const gchar docu110[] = {"\n\n\t\t\tShort List of References (*)"};
const gchar docu111[] = {"\n\n\t[1] D.A. Bini, G. Latouche, B. Meini,  Numerical Solution of Structured Markov Chains,  Oxford University Press,  Oxford 2005."};
const gchar docu112[] = {"\n\n\t[2] D.A. Bini, B. Meini, S. Steffe', B. Van Houdt,  Structured Markov chains Solver: the algorithms. (SMCTools 2006)"};
const gchar docu113[] = {"\n\n\t[3] D.A. Bini, B. Meini, S. Steffe', B. Van Houdt,  Structured Markov chains Solver: software tools. (SMCTools 2006)"};
const gchar docu114[] = {"\n\n\t[4] D.A. Bini, B. Meini, S. Steffe', B. Van Houdt,  Structured Markov chains Solver: tool extension. ((SMCTools 2009)"};
const gchar docu115[] = {"\n\n\t[5] M. F. Neuts. Structured stochastic matrices of M/G/1 type and their applications. Marcel Dekker, New York, NY, 1989"};
const gchar docu116[] = {"\n\n\t[6] D. Kendall. Some problems in the theory of queues. Journal of the Royal Statistical Society, 13:151--153, 1951."};
const gchar docu117[] = {"\n\n\t[7] G. Latouche and V. Ramaswami  Introduction to matrix analytic methods in stochastic modeling, ASA-SIAM Series on Statistics and Applied Probability, Philadelphia, (SIAM) 1999"};
const gchar docu118[] = {"\n\n\t[8] S. J. Chapman  Fortran 90/95  McGraw-Hill Libri Italia, Milano 2000."};
const gchar docu119[] = {"\n\n\t[9] B. W. Kernighan D. M. Richtie  Linguaggio C.  Gruppo Editoriale Jackson, Milano, 1985."};
const gchar docu120[] = {"\n\n\n\t(*) For more complete Bibliography see [2],[3] and [4]."};

const gchar docu121[] = {"\n\nThis work is supported by:\n\tMinistero dell'Istruzione, dell'Universita\' e della Ricerca MIUR"};
const gchar docu122[] = {"\n\t\t\tProject Name = Structured matrix analysis: numerical methods and applications\n\t\t\tGrant number = 2004015437\n "};
const gchar docu123[] = {"\nSoftware development for version 1.1, 1.2, 1.3 has been made on a:\n\tSUSE(R) Linux 9.1 Workstation with a Intel(R) Pentium(R) 4 CPU using:"};
const gchar docu124[] = {"\n\t\tgcc-3.3.3-41"};
const gchar docu125[] = {"\n\t\tgtk2-2.2.4-125.4"};
const gchar docu126[] = {"\n\t\tLahey/Fujitsu (R) Fortran 95 Compiler Release L6.20c"};
const gchar docu127[] = {"\n\t\tLAPACK (Linear Algebra PACKage), LAPACK95 and BLAS (Basic Linear Algebra Subprograms)"};
const gchar docu128[] = {"\n\nFurther testing has been made with\n\t\tNAG(R) f95 Fortran Compiler Version 4.2\n\t\tIntel(R) Fortran Compiler Version 8.1 (noncommercial licence) for Linux\n\t\t\t and \n\t\tGNU Fortran Compiler G95 (GCC 4.0.1 (g95!) Mar 11 2006)\n\t\t\t on a variety of CPUs (AMD and Intel ) and Linux distributions."};
const gchar docu129[] = {"\n\nVersion 2.1 development has beeen done on a:\n\tSUSE(R) Linux 9.3 Workstation with a Intel(R) 8500 Core 2 Duo using:"};
const gchar docu130[] = {"\n\t\tgcc (GCC) 4.2.1 (SUSE Linux)\n\t\tgtk2-2.12.0-5.8\n\t\tG95 (GCC 4.0.3 (g95 0.92!) Apr 28 2008) *32bit integers version*\n\t\tLAPACK (Linear Algebra PACKage), LAPACK95 and BLAS (Basic Linear Algebra Subprograms)"};

const gchar docu131[] = {"\n\n\t\t\tThanks:"};
const gchar docu132[] = {"\n\n\tOne of the Authors thanks Prof. Andrea Milani and Prof. Giovanni Gronchi (Gruppo Meccanica Spaziale, Dipartimento di Matematica, Universita' di Pisa) for useful discussions on several idiosyncrasies of Fortran Compilers on Linux Systems."};

/*********************************************/
