/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 1.3 - March 2007                                   *
 **************************************************************
 *
 *  view_mat.c - view and compare G,R  - both callbacks and interfaces
 *
 */

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <pthread.h>
#include <libgen.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <ctype.h> /* character functions */
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "structures.h"
#include "view_mat.h"

#define  VPIX 500   /* drawing area side */
#define  VPIXS 50   /* drawing area space */
#define  VPIXV 50   /* drawing area row sums part */

/* View  Window  **** Interface */
void
create_view_window()
{
/* GtkWidget *window_view; global */
GtkWidget *vboxm_view;
GtkWidget *hbox1,*hbox2;
GtkWidget *vbox1,*vbox2;
GtkWidget *vbox11,*vbox14;
/* GtkWidget *vbox12,*vbox13; globals */
GtkWidget *hsep11,*hsep12,*hsep13; /* separators */
GtkWidget *label_v11,*label_v12,*label_v13; /* titles for button groups */
GtkWidget *button_pos_neg;
GtkWidget *button_color;
GtkWidget *button_user;
GtkWidget *hbox_contrast;
GtkWidget *label_contrast;
GtkWidget *button_contrast;
GtkWidget *button_range_normal; 
GtkWidget *button_range_adaptive;
GtkWidget *button_range_block;  
GSList *range_list = NULL;
GSList *matrix_list = NULL;
GtkWidget *button_matrix_compare;
/* GtkWidget *button_matrix_g;   global to deselect when cancel */
/* GtkWidget *button_matrix_r;   global to deselect when cancel */
/* GtkWidget *button_matrix_u;    global to deselect when cancel */
/* GtkWidget *button_matrix_file; global to deselect when cancel */
/* GtkWidget *button_matrix_test; globale to select when cancel */
GtkWidget *hsep1,*hsep2,*vsep0,*vsep1,*vsep2; /* separators */
GtkWidget *vbox21,*vbox22, *vbox23;
GtkWidget *label_211; /* labels with matrix results */
GtkWidget *label_221; /* labels with matrix results */
/* GtkWidget *label_v222, label_v212,*label_v231, *label_v232; globals */
/* GtkWidget  *view_area; global */
GtkWidget *hbox_matlabels;
GtkWidget *label_mat,*label_vet;
GtkWidget *toolbar_view;
GtkWidget *tmp_toolbar_icon;
GtkWidget *button_quit_view;
GtkWidget *hbox_block;
GtkWidget *hbox_aij;
GtkWidget *label_aij;
/* GtkWidget *view_label_space; global */
/* GtkWidget   *view_entry_ij; global */
/* GtkWidget   *view_entry_aij; global */
GtkWidget *label_space2;
/* GtkWidget   *view_entry2_ij; global */
/* GtkWidget   *view_entry2_aij; global */
/* GtkWidget *statusb_view; global */
/* unsigned char *viewvalue; globals */
char buf[256];
/* double *vs, vsmax;  globals   allocated in create_view_window, sum of rows of matrix and maximum value of matrix */
/* char view_file_name[256]; globals */
/* int  view_file_dimension; globals */
/* int view_is_file; globals  0=no 1=yes */
/* int fake_dim;  4 globals */
/* double fake_matrix[26];  globals fake matrix to load in event of missing data  fortran style indexes 4 x 4 */

if(is_debug==1) printf("create_view_window: entering with completed.g=%d, completed.r=%d, completed.u=%d, pview.is_gru=%d\n",completed.g,completed.r,completed.u,pview.is_gru);
/* window_view */
window_view=gtk_window_new (GTK_WINDOW_TOPLEVEL);
gtk_window_set_title (GTK_WINDOW (window_view), "View and Compare");
gtk_window_set_default_size (GTK_WINDOW (window_view), 720, 700);
gdk_rgb_init();

/* vboxm_view - main vertical box*/
vboxm_view = gtk_vbox_new (FALSE, 5);
gtk_widget_show (vboxm_view);
gtk_container_add (GTK_CONTAINER (window_view), vboxm_view);
/* divided in four hbox */
hbox1=gtk_hbox_new(FALSE,5);
gtk_widget_show(hbox1);
gtk_box_pack_start (GTK_BOX (vboxm_view), hbox1, FALSE, FALSE, 5);
/* first hbox divided in 2 vbox */
/* first vbox in first hbox  for buttons and hboxes */
vbox1=gtk_vbox_new(FALSE,5);
gtk_box_pack_start (GTK_BOX (hbox1), vbox1, FALSE, FALSE, 5);
gtk_widget_show(vbox1);
/* first vbox on the left contains buttons and hboxes in 3 vboxes */
vbox11 = gtk_vbox_new(FALSE,5);
gtk_box_pack_start (GTK_BOX (vbox1), vbox11, FALSE, FALSE, 0);
gtk_widget_show(vbox11);
label_v11 = gtk_label_new("DISPLAY CONTROL\n     change to: ");
gtk_widget_show(label_v11);
gtk_box_pack_start (GTK_BOX (vbox11), label_v11, TRUE, FALSE, 0);
/* button positive / negative s_positive=0 default is positive i.e. black is 1 white is 0*/
button_pos_neg = gtk_button_new();
if (pview.is_positive==1)  gtk_button_set_label (GTK_BUTTON(button_pos_neg)," Positive ");
          else           gtk_button_set_label (GTK_BUTTON(button_pos_neg)," Negative ");
gtk_widget_show (button_pos_neg);
gtk_box_pack_start (GTK_BOX (vbox11), button_pos_neg, TRUE, FALSE, 0);
/* button b/n - color default is_color=0 is black&white */ 
button_color = gtk_button_new();
if (pview.is_color==1)  gtk_button_set_label (GTK_BUTTON(button_color),"  B & W  ");
          else        gtk_button_set_label (GTK_BUTTON(button_color),"  Color  ");
gtk_widget_show (button_color);
gtk_box_pack_start (GTK_BOX (vbox11), button_color, TRUE, FALSE, 0);
/* button enhance = no enhance*/
button_user = gtk_button_new();
/* set labels depending on previous setup choices */
if (pview.is_user==1)  gtk_button_set_label (GTK_BUTTON(button_user),"  STANDARD   ");
          else       gtk_button_set_label (GTK_BUTTON(button_user),"    USER     ");
gtk_widget_show (button_user);
gtk_box_pack_start (GTK_BOX (vbox11), button_user, TRUE, FALSE, 0);

/* horizontal separator */
hsep11 = gtk_hseparator_new();
gtk_widget_show(hsep11);
gtk_box_pack_start (GTK_BOX (vbox1), hsep11, FALSE, FALSE, 0);
view_vbox12 = gtk_vbox_new(TRUE,5);
gtk_box_pack_start (GTK_BOX (vbox1), view_vbox12, FALSE, FALSE, 0);
gtk_widget_show(view_vbox12);
label_v12 = gtk_label_new("USER CONTRAST");
gtk_widget_show(label_v12);
gtk_box_pack_start (GTK_BOX (view_vbox12), label_v12, TRUE, FALSE, 0);
/* contrast spin button */
hbox_contrast = gtk_hbox_new(FALSE,0);
gtk_widget_show (hbox_contrast);
gtk_box_pack_start (GTK_BOX (view_vbox12), hbox_contrast, TRUE, FALSE, 0);
label_contrast = gtk_label_new(" contrast");
gtk_widget_show (label_contrast);
gtk_box_pack_start (GTK_BOX (hbox_contrast),label_contrast, TRUE, FALSE, 0);
button_contrast = gtk_spin_button_new_with_range(-20,20,1);
gtk_widget_show (button_contrast);
gtk_box_pack_start (GTK_BOX (hbox_contrast), button_contrast, TRUE, FALSE, 0);
gtk_spin_button_set_digits (GTK_SPIN_BUTTON(button_contrast),0);
gtk_spin_button_set_value (GTK_SPIN_BUTTON(button_contrast),pview.contrast_value);
gtk_entry_set_editable(GTK_ENTRY(button_contrast),FALSE);
/* horizontal separator */
hsep12 = gtk_hseparator_new();
gtk_widget_show(hsep12);
gtk_box_pack_start (GTK_BOX (vbox1), hsep12, FALSE, FALSE, 0);
view_vbox13 = gtk_vbox_new(TRUE,5);
gtk_box_pack_start (GTK_BOX (vbox1), view_vbox13, FALSE, FALSE, 0);
gtk_widget_show(view_vbox13);
label_v13 = gtk_label_new("USER    RANGE");
gtk_widget_show(label_v13);
gtk_box_pack_start (GTK_BOX (view_vbox13), label_v13, TRUE, FALSE, 0);
/* button normal range*/
button_range_normal = gtk_radio_button_new_with_label(NULL,"  [0,1]  ");
range_list = gtk_radio_button_get_group (GTK_RADIO_BUTTON(button_range_normal));
gtk_widget_show (button_range_normal);
gtk_box_pack_start (GTK_BOX (view_vbox13), button_range_normal, TRUE, FALSE, 0);
/* button range block */
button_range_block = gtk_radio_button_new_with_label(range_list," [min,max] ");
range_list = gtk_radio_button_get_group (GTK_RADIO_BUTTON(button_range_normal));
gtk_widget_show (button_range_block);
gtk_box_pack_start (GTK_BOX (view_vbox13), button_range_block, TRUE, FALSE, 0);
/* button range adaptive */
button_range_adaptive = gtk_radio_button_new_with_label(range_list," adaptive ");
gtk_widget_show (button_range_adaptive);
gtk_box_pack_start (GTK_BOX (view_vbox13), button_range_adaptive, TRUE, FALSE, 0);
switch (pview.is_range_type) {
        case 0:
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button_range_normal),TRUE);
                break;
        case 1:
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button_range_block),TRUE);
                break;
        case 2:
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_range_adaptive),TRUE);
                break;
        }
/* horizontal separator */
hsep13 = gtk_hseparator_new();
gtk_widget_show(hsep13);
gtk_box_pack_start (GTK_BOX (vbox1), hsep13, FALSE, FALSE, 0);

vbox14 = gtk_vbox_new(FALSE,5);
gtk_box_pack_start (GTK_BOX (vbox1), vbox14, FALSE, FALSE, 0);
gtk_widget_show(vbox14);
label_v13 = gtk_label_new("MATRIX READ");
gtk_widget_show(label_v13);
gtk_box_pack_start (GTK_BOX (vbox14), label_v13, TRUE, FALSE, 0);
/* button g */
button_matrix_g = gtk_radio_button_new_with_label(NULL," G (memory) ");
matrix_list = gtk_radio_button_get_group (GTK_RADIO_BUTTON(button_matrix_g));
gtk_widget_show (button_matrix_g);
gtk_box_pack_start (GTK_BOX (vbox14), button_matrix_g, TRUE, FALSE, 0);
/* button r */
button_matrix_r = gtk_radio_button_new_with_label(matrix_list," R (memory) ");
matrix_list = gtk_radio_button_get_group (GTK_RADIO_BUTTON(button_matrix_r));
gtk_widget_show (button_matrix_r);
gtk_box_pack_start (GTK_BOX (vbox14), button_matrix_r, TRUE, FALSE, 0);
/* button u */
button_matrix_u = gtk_radio_button_new_with_label(matrix_list," U (memory) ");
matrix_list = gtk_radio_button_get_group (GTK_RADIO_BUTTON(button_matrix_u));
gtk_widget_show (button_matrix_u);
gtk_box_pack_start (GTK_BOX (vbox14), button_matrix_u, TRUE, FALSE, 0);
/* Read from File button */
button_matrix_file = gtk_radio_button_new_with_label(matrix_list,"  Read File  ");
matrix_list = gtk_radio_button_get_group (GTK_RADIO_BUTTON(button_matrix_file));
gtk_widget_show (button_matrix_file);
gtk_box_pack_start (GTK_BOX (vbox14), button_matrix_file,TRUE, FALSE, 0);
/* test pattern */
button_matrix_test = gtk_radio_button_new_with_label(matrix_list," Test Pattern ");
matrix_list = gtk_radio_button_get_group (GTK_RADIO_BUTTON(button_matrix_test));
gtk_widget_show (button_matrix_test);
gtk_box_pack_start (GTK_BOX (vbox14), button_matrix_test,TRUE, FALSE, 0);
view_is_fake=0;
switch (pview.is_gru) {
        case 0:/* no computed matrix in memory */
                gtk_widget_set_sensitive(button_matrix_g,FALSE);
                gtk_widget_set_sensitive(button_matrix_r,FALSE);
                gtk_widget_set_sensitive(button_matrix_u,FALSE);
                view_is_fake=1; /* no matrix, use fake data in the vindow */
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_matrix_test),TRUE);
                break;
        case 1:
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button_matrix_g),TRUE);
                break;
        case 2:
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button_matrix_r),TRUE);
                break;
        case 3:
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_matrix_u),TRUE);
                break;
        }
if (completed.g==0)  gtk_widget_set_sensitive(button_matrix_g,FALSE);
if (completed.r==0)  gtk_widget_set_sensitive(button_matrix_r,FALSE);
if (completed.u==0)  gtk_widget_set_sensitive(button_matrix_u,FALSE);
/* Compare with File */
button_matrix_compare = gtk_button_new_with_label("  Compare File  ");
gtk_widget_show (button_matrix_compare);
gtk_box_pack_start (GTK_BOX (vbox14), button_matrix_compare,TRUE, FALSE, 0);

/* vertical separator */
vsep0 = gtk_vseparator_new();
gtk_widget_show(vsep0);
gtk_box_pack_start (GTK_BOX (hbox1), vsep0, FALSE, FALSE, 0);

/* second vbox in first hbox for matrix display */
vbox2=gtk_vbox_new(FALSE,5);
gtk_widget_show(vbox2);
gtk_box_pack_end (GTK_BOX (hbox1), vbox2, FALSE, FALSE, 0);
gtk_container_set_border_width (GTK_CONTAINER (vbox2), 10);
/* matrix drawable area */
gtk_widget_push_visual(gdk_rgb_get_visual());
gtk_widget_push_colormap(gdk_rgb_get_cmap());
view_area =  gtk_drawing_area_new();
gtk_widget_pop_visual();
gtk_widget_pop_colormap();
gtk_widget_show(view_area);
gtk_drawing_area_size  (GTK_DRAWING_AREA(view_area),VPIX+VPIXS+VPIXV,VPIX);
gtk_box_pack_start (GTK_BOX (vbox2), view_area, FALSE, FALSE, 0);
/* add mouse positioning events to view_area */
gtk_widget_add_events (GTK_WIDGET(view_area),GDK_POINTER_MOTION_MASK);
gtk_widget_add_events (GTK_WIDGET(view_area),GDK_BUTTON_PRESS_MASK);
hbox_matlabels = gtk_hbox_new(FALSE,0);
gtk_widget_show(hbox_matlabels);
gtk_box_pack_start (GTK_BOX (vbox2), hbox_matlabels, FALSE, FALSE, 0);
label_mat = gtk_label_new(" Matrix Graphic Display ");
gtk_widget_show(label_mat);
gtk_box_pack_start (GTK_BOX (hbox_matlabels), label_mat, FALSE, FALSE, 0);
view_label_user = gtk_label_new("                             USER LEVELS");
if (pview.is_user==0) gtk_label_set_text(GTK_LABEL(view_label_user),"                          STANDARD LEVELS"); 
else gtk_label_set_text(GTK_LABEL(view_label_user),"                             USER LEVELS");
gtk_widget_show(view_label_user);
gtk_box_pack_start (GTK_BOX (hbox_matlabels), view_label_user, FALSE, FALSE, 0);
label_vet = gtk_label_new("Rows Sums");
gtk_widget_show(label_vet);
gtk_box_pack_end (GTK_BOX (hbox_matlabels), label_vet, FALSE, FALSE, 0);
/* horizontal separator */
hsep1 = gtk_hseparator_new();
gtk_widget_show(hsep1);
gtk_box_pack_start (GTK_BOX (vboxm_view), hsep1, FALSE, FALSE, 0);

/* second hbox contains various data show boxes */
hbox2=gtk_hbox_new(FALSE,5);
gtk_widget_show(hbox2);
gtk_box_pack_start (GTK_BOX (vboxm_view), hbox2, FALSE, FALSE, 0);
/* matrix #blocks and dimensions */
vbox21 = gtk_vbox_new(TRUE,5);
gtk_box_pack_start (GTK_BOX (hbox2), vbox21, TRUE, TRUE, 0);
gtk_widget_show(vbox21);
label_211 = gtk_label_new("   Matrix   ");
gtk_widget_show(label_211);
gtk_box_pack_start (GTK_BOX (vbox21), label_211, TRUE, TRUE, 0);
label_v212 = gtk_label_new(" ");
gtk_widget_show(label_v212);
gtk_box_pack_start (GTK_BOX (vbox21), label_v212, FALSE, FALSE, 0);
/* vertical separator */
vsep1 = gtk_vseparator_new();
gtk_widget_show(vsep1);
gtk_box_pack_start (GTK_BOX (hbox2), vsep1, FALSE, FALSE, 0);
vbox22 = gtk_vbox_new(TRUE,0);
gtk_box_pack_start (GTK_BOX (hbox2), vbox22, TRUE, TRUE, 0);
gtk_widget_show(vbox22);
sprintf(buf,"Comparison");
label_221 = gtk_label_new(buf);
gtk_widget_show(label_221);
gtk_box_pack_start (GTK_BOX (vbox22), label_221, TRUE, TRUE, 0);
sprintf(buf,"    ");
label_v222 = gtk_label_new(buf);
gtk_widget_show(label_v222);
gtk_box_pack_start (GTK_BOX (vbox22), label_v222, TRUE, TRUE, 0);
/* vertical separator */
vsep2 = gtk_vseparator_new();
gtk_widget_show(vsep2);
gtk_box_pack_start (GTK_BOX (hbox2), vsep2, FALSE, FALSE, 0);
vbox23 = gtk_vbox_new(TRUE,0);
gtk_box_pack_start (GTK_BOX (hbox2), vbox23, TRUE, TRUE, 0);
gtk_widget_show(vbox23);
label_v231 = gtk_label_new(buf);
gtk_widget_show(label_v231);
gtk_box_pack_start (GTK_BOX (vbox23), label_v231, TRUE, TRUE, 0);
label_v232 = gtk_label_new(buf);
gtk_widget_show(label_v232);
gtk_box_pack_start (GTK_BOX (vbox23), label_v232, TRUE, TRUE, 0);

/* horizontal separator */
hsep2 = gtk_hseparator_new();
gtk_widget_show(hsep2);
gtk_box_pack_start (GTK_BOX (vboxm_view), hsep2, FALSE, FALSE, 0);

/* third hbox consists in toolbox  */
/* toolbar begins */
toolbar_view = gtk_toolbar_new ();
gtk_widget_show (toolbar_view);
gtk_box_pack_start (GTK_BOX (vboxm_view), toolbar_view, FALSE, FALSE, 0);
gtk_container_set_border_width (GTK_CONTAINER (toolbar_view), 10);
gtk_toolbar_set_style (GTK_TOOLBAR (toolbar_view), GTK_TOOLBAR_BOTH);
/* cancel button  first position */
tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-quit", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar_view)));
button_quit_view = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar_view),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Close",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
gtk_widget_show(button_quit_view);
/* blocks choice hbox */
hbox_block =gtk_hbox_new(TRUE,0);
gtk_box_set_homogeneous (GTK_BOX(hbox_block),FALSE);

/* A(i,j)= x hbox */
hbox_aij = gtk_hbox_new(TRUE,0);
gtk_box_set_homogeneous (GTK_BOX(hbox_aij),FALSE);
label_space2 = gtk_label_new("   Click to Memorize Value : ");
gtk_box_pack_start (GTK_BOX (hbox_aij), label_space2, FALSE, FALSE, 0);
gtk_widget_show (label_space2);
view_entry2_ij = gtk_entry_new_with_max_length (14);
gtk_entry_set_width_chars (GTK_ENTRY(view_entry2_ij),15);
gtk_entry_set_editable (GTK_ENTRY(view_entry2_ij),FALSE);
gtk_widget_show(view_entry2_ij);
gtk_box_pack_start (GTK_BOX (hbox_aij),view_entry2_ij,FALSE, FALSE, 0);
view_entry2_aij = gtk_entry_new_with_max_length (16);
gtk_entry_set_width_chars (GTK_ENTRY(view_entry2_aij),20);
gtk_entry_set_editable(GTK_ENTRY(view_entry2_aij),FALSE);
gtk_widget_show(view_entry2_aij);
gtk_box_pack_start (GTK_BOX (hbox_aij),view_entry2_aij,FALSE, FALSE, 0);

label_aij=gtk_label_new("    Value : ");
gtk_box_pack_start (GTK_BOX (hbox_aij), label_aij, FALSE, FALSE, 0);
gtk_widget_show (label_aij);
view_entry_ij = gtk_entry_new_with_max_length (14);
gtk_entry_set_width_chars (GTK_ENTRY(view_entry_ij),15);
gtk_entry_set_editable (GTK_ENTRY(view_entry_ij),FALSE);
gtk_widget_show(view_entry_ij);
gtk_box_pack_start (GTK_BOX (hbox_aij),view_entry_ij,FALSE, FALSE, 0);
view_entry_aij = gtk_entry_new_with_max_length (16);
gtk_entry_set_width_chars (GTK_ENTRY(view_entry_aij),20);
gtk_entry_set_editable(GTK_ENTRY(view_entry_aij),FALSE);
gtk_widget_show(view_entry_aij);
gtk_box_pack_start (GTK_BOX (hbox_aij),view_entry_aij,FALSE, FALSE, 0);
gtk_widget_show(gtk_toolbar_append_element (GTK_TOOLBAR (toolbar_view),
                                GTK_TOOLBAR_CHILD_WIDGET,
                                hbox_aij,
                                "",
                                NULL, NULL,
                                NULL, NULL, NULL));
/* label space with editing/view only message */
view_label_space = gtk_label_new(" ");
gtk_widget_show (view_label_space);
gtk_widget_show(gtk_toolbar_append_element (GTK_TOOLBAR (toolbar_view),
                                GTK_TOOLBAR_CHILD_WIDGET,
                                view_label_space,
                                "",
                                NULL, NULL,
                                NULL, NULL, NULL));

/* fourth hbox consists in statusbar  */
/**************** statusbar  begins        */
statusb_view = gtk_statusbar_new();
gtk_widget_show (statusb_view);
gtk_box_pack_end (GTK_BOX (vboxm_view), statusb_view, FALSE, FALSE, 0);
/**************** statusbar ends           */

/* initialize */
if (pview.is_user==0) {
         gtk_widget_set_sensitive(view_vbox12,FALSE);
         gtk_widget_set_sensitive(view_vbox13,FALSE);
         }
view_file_activated=0; /*button file is not selected */
view_is_file=0; /* no file is open */
is_view_fs_open=0; /* no read file dialog open */
is_view_comparison=0; /* no comparison required */
view_compare_out=0.0;
/* allocate space for graphic buffers and block computations */
view_matvalue=calloc((VPIX+VPIXS+VPIXV)*VPIX,sizeof(char));
rgb_view_matvalue=calloc(3*(VPIX+VPIXS+VPIXV)*VPIX,sizeof(guchar));
if (view_is_fake==1) view_dimension=fake_dim; else view_dimension=committed.dimension_m;
vrs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
vcs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
max_min_view_compute();
view_gray_levels_setup(pview.contrast_value);
view_image_compute();
g_idle_add((GtkFunction) view_labels_update,NULL);

/**************** connect signals  begin   */
g_signal_connect ((gpointer) window_view, "destroy", G_CALLBACK (on_view_destroy_activate),NULL);
g_signal_connect ((gpointer) button_quit_view, "clicked", G_CALLBACK(on_view_menu_quit_activate),NULL);
g_signal_connect (G_OBJECT (view_area), "expose_event",  G_CALLBACK (draw_view_area_callback), NULL);
g_signal_connect (G_OBJECT (view_area), "motion_notify_event",  G_CALLBACK (xy_view_area), NULL);
gtk_signal_connect (GTK_OBJECT (view_area), "button_press_event", (GtkSignalFunc) button_press_view_area, NULL);
g_signal_connect ((gpointer) button_pos_neg, "clicked", G_CALLBACK(on_view_pos_neg_activate),NULL);
g_signal_connect ((gpointer) button_color, "clicked", G_CALLBACK(on_view_color_activate),NULL);
g_signal_connect ((gpointer) button_contrast, "changed", G_CALLBACK (on_view_contrast_changed), NULL);
g_signal_connect ((gpointer) button_user, "clicked", G_CALLBACK(on_view_user_activate),NULL);
g_signal_connect ((gpointer) button_range_normal, "toggled", G_CALLBACK(on_view_range_normal_activate),NULL);
g_signal_connect ((gpointer) button_range_block, "toggled", G_CALLBACK(on_view_range_matrix_activate),NULL);
g_signal_connect ((gpointer) button_range_adaptive, "toggled", G_CALLBACK(on_view_range_adaptive_activate),NULL);
g_signal_connect ((gpointer) button_matrix_g, "toggled", G_CALLBACK(on_view_g_activate),NULL);
g_signal_connect ((gpointer) button_matrix_r, "toggled", G_CALLBACK(on_view_r_activate),NULL);
g_signal_connect ((gpointer) button_matrix_u, "toggled", G_CALLBACK(on_view_u_activate),NULL);
g_signal_connect ((gpointer) button_matrix_file,"toggled", G_CALLBACK(on_view_file_activate),NULL);
g_signal_connect ((gpointer) button_matrix_test,"toggled", G_CALLBACK(on_view_test_activate),NULL);
g_signal_connect ((gpointer) button_matrix_compare,"clicked", G_CALLBACK(on_view_compare_activate),NULL);
/**************** connect signals  end     */

gtk_widget_show_all(window_view);
}
/*********************************/

/******************* Callbacks:  Buttons and  widgets on the toolbar ***********************/

/* View  Window: Quit  **** Callback */
void
on_view_menu_quit_activate   (GtkMenuItem  *menuitem, gpointer  user_data)
{
if(is_debug==1) printf("on_view_menu_quit_activate: quit\n");
gtk_widget_destroy(GTK_WIDGET(window_view));
if(is_debug==1) printf("on_view_menu_quit_activate: exiting from View Matrix Window\n");   
}
/*********************************/

/* View  Window: destroy activate **** Callback */
void on_view_destroy_activate (GtkWidget  *ww, gpointer user_data )
{
if(is_debug==1) printf("on_view_menu_destroy_activate: about to free graphic buffers\n");
/* free space of the graphic buffers */
free(view_matvalue);
free(rgb_view_matvalue);
free(vrs);
free(vcs);
is_view_matrix_open=0;  /* 0=not open  1=open */
if(is_debug==1) printf("on_view_menu_destroy_activate: done\n");
}
/*********************************/

/* print x y position on view_area ***** Callback  from mouse moving in view_area "motion_notify" event */
gboolean
xy_view_area (GtkWidget *widget, GdkEventExpose *event, gpointer data)
{
int x,y,i,j,m;
GdkModifierType state;
double r;
char buf[256];
m=view_dimension; 
gdk_window_get_pointer(widget->window,&x,&y,&state);
i=x*m/VPIX+1;
j=y*m/VPIX+1;
if (i <= m) {
        if(pview.is_gru==1) {r=view_get_data(j,i); sprintf(buf,"G(%02d,%02d)=",j,i);}
        if(pview.is_gru==2) {r=view_get_data(j,i) ;sprintf(buf,"R(%02d,%02d)=",j,i);}
        if(pview.is_gru==3) {r=view_get_data(j,i) ;sprintf(buf,"U(%02d,%02d)=",j,i);}
        if((pview.is_gru==0)&&(view_is_file==1)) {r=view_get_data(j,i); sprintf(buf,"M(%02d,%02d)=",j,i);}
        if(view_is_fake==1) {r=view_get_data(j,i); sprintf(buf,"F(%02d,%02d)=",j,i);}
        gtk_entry_set_text(GTK_ENTRY(view_entry_ij), buf);
        sprintf(buf,"%.8E",r);
        gtk_entry_set_text(GTK_ENTRY(view_entry_aij), buf);
        } else if (x<VPIX+VPIXS){
                buf[0]=0;
                gtk_entry_set_text(GTK_ENTRY(view_entry_ij), buf);
                gtk_entry_set_text(GTK_ENTRY(view_entry_aij), buf);
        } else {
        sprintf(buf,"+Row %02d ",j);
        gtk_entry_set_text(GTK_ENTRY(view_entry_ij), buf);
        sprintf(buf,"%.8E",vrs[j]);
        gtk_entry_set_text(GTK_ENTRY(view_entry_aij), buf);
      }
return TRUE;
}
/*********************************/

/* copy entryes in secondary entry area */
gboolean 
button_press_view_area (GtkWidget *widget, GdkEventExpose *event, gpointer data)
{
int x,y,i,j,m;
GdkModifierType state;
double r;
char buf[256];
m=view_dimension;
gdk_window_get_pointer(widget->window,&x,&y,&state);
i=x*m/VPIX+1;
j=y*m/VPIX+1;
if (i <= m) {
        if(pview.is_gru==1) {r=view_get_data(j,i); sprintf(buf,"G(%02d,%02d)=",j,i);}
        if(pview.is_gru==2) {r=view_get_data(j,i) ;sprintf(buf,"R(%02d,%02d)=",j,i);}
        if(pview.is_gru==3) {r=view_get_data(j,i) ;sprintf(buf,"U(%02d,%02d)=",j,i);}
        if((pview.is_gru==0)&&(view_is_file==1)) {r=view_get_data(j,i); sprintf(buf,"M(%02d,%02d)=",j,i);}
        if(view_is_fake==1) {r=view_get_data(j,i); sprintf(buf,"F(%02d,%02d)=",j,i);}
        gtk_entry_set_text(GTK_ENTRY(view_entry2_ij), buf);
        sprintf(buf,"%.8E",r);
        gtk_entry_set_text(GTK_ENTRY(view_entry2_aij), buf);
        } else if (x<VPIX+VPIXS){
                buf[0]=0;
                gtk_entry_set_text(GTK_ENTRY(view_entry2_ij), buf);
                gtk_entry_set_text(GTK_ENTRY(view_entry2_aij), buf);
        } else {
        sprintf(buf,"+Row %02d ",j);
        gtk_entry_set_text(GTK_ENTRY(view_entry2_ij), buf);
        sprintf(buf,"%.8E",vrs[j]);
        gtk_entry_set_text(GTK_ENTRY(view_entry2_aij), buf);
      }
return TRUE;
}
/*********************************/

/* update of the labels - to be called after each matrix change and after max_min_view_compute() */
int
view_labels_update()
{
/* double view_mat_max,view_mat_min,view_mat_qmin; globals */
/* double *vrs, vrmax,vrmin;   globals   allocated in create_view_window, sum of rows  and maximum and minimum values  */
/* int  view_file_dimension; global */
/* int view_is_file; global  0=no 1=yes */
/* struct running_problem_str  completed; global */
/* struct edita_str pview;  global    preferences view windows */
/* double view_compare_out; global */
/* GtkWidget *label_v222, *label_v231, *label_v232; GtkWidget *view_label_space; global */
char buf[256];
if(pview.is_gru==1) {sprintf(buf,"G  %d x %d",completed.dimension_m,view_dimension);}
if(pview.is_gru==2) {sprintf(buf,"R  %d x %d",completed.dimension_m,view_dimension);}
if(pview.is_gru==3) {sprintf(buf,"U  %d x %d",completed.dimension_m,view_dimension);}
if((pview.is_gru==0)&&(view_is_file==1)) {sprintf(buf,"%s:  %d x %d",view_file_name,view_dimension,view_dimension);}
if((pview.is_gru==0)&&(view_is_file==0)) {sprintf(buf,"Test Data 4 x 4");}
gtk_label_set_text (GTK_LABEL(label_v212),buf);
sprintf(buf,"max=%g  min=%g qmin=%g",view_mat_max,view_mat_min,view_mat_qmin);
gtk_label_set_text (GTK_LABEL(label_v231),buf);
sprintf(buf,"Sums:  Rows [%g ~ %g]   Col [%g ~ %g] ",vrmin,vrmax,vcmin,vcmax);
gtk_label_set_text (GTK_LABEL(label_v232) ,buf);
sprintf(buf,"Difference Norm=%g",view_compare_out);
gtk_label_set_text (GTK_LABEL(label_v222),buf);
return(0);
}
/*********************************/

/* write to status bar */
int view_status_update(void)
{
gtk_statusbar_push(GTK_STATUSBAR(statusb_view),0,VSBUF);
return(0);
}
/*********************************/

/******************* Callbacks:  Buttons and  widgets on the left side  ***********************/

/* positive / negative choice button  */
void
on_view_pos_neg_activate(GtkButton *button, gpointer my_data)
{
if( is_debug==1) printf("on_view_pos_neg_activate:\n");
if (pview.is_positive==0) {
         pview.is_positive=1;
         gtk_button_set_label (button," Positive ");
         } else {
        pview.is_positive=0;
         gtk_button_set_label (button," Negative ");
        }
view_gray_levels_setup(pview.contrast_value);
view_image_compute();
if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
draw_view_area();
}
/*********************************/

/* color / black % white */
void
on_view_color_activate(GtkButton *button, gpointer my_data)
{
if( is_debug==1) printf("on_view_color_activate:\n");
if (pview.is_color==0) {
         pview.is_color=1;
         gtk_button_set_label (button,"  B & W  ");
         } else {
        pview.is_color=0;
         gtk_button_set_label (button,"  Color  ");
        }
view_gray_levels_setup(pview.contrast_value);
view_image_compute();
if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
draw_view_area();
}
/*********************************/

/* (toggle button) user:  activate user contrast settings  and redraw */
void
on_view_user_activate(GtkButton *button, gpointer my_data)
{
if( is_debug==1) printf("on_view_user_activate:\n");
if (pview.is_user==0) {
         pview.is_user=1;
	 gtk_widget_set_sensitive(view_vbox12,TRUE);
         gtk_widget_set_sensitive(view_vbox13,TRUE);
	 gtk_label_set_text(GTK_LABEL(view_label_user),"                             USER LEVELS");
         gtk_button_set_label (button,"  STANDARD   ");
         } else {
         pview.is_user=0;
	 gtk_widget_set_sensitive(view_vbox12,FALSE);
	 gtk_widget_set_sensitive(view_vbox13,FALSE);
	 gtk_label_set_text(GTK_LABEL(view_label_user),"                          STANDARD LEVELS"); 
         gtk_button_set_label (button,"    USER     ");
        }

if(is_debug==1) printf("on_view_user_activate:  contrast_value=%g \n",pview.contrast_value);
view_gray_levels_setup(pview.contrast_value);
view_image_compute();
if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
draw_view_area();
}
/*********************************/

/* read contrast and redraw */
void
on_view_contrast_changed(GtkEntry *entry, gpointer my_data)
{
if( is_debug==1) printf("on_view_contrast_changed:\n");
pview.contrast_value = gtk_spin_button_get_value (GTK_SPIN_BUTTON(entry));
if(pview.is_user==1) {/* the change is valid but to see result must be user mode */
                view_gray_levels_setup(pview.contrast_value);
                view_image_compute();
                if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
                draw_view_area();
                }
}
/*********************************/

/* range normal and redraw (toggle) */
void
on_view_range_normal_activate(GtkButton *button, gpointer my_data)
{
if( is_debug==1) printf("on_view_range_normal_activate\n");
pview.is_range_type=0;
if(pview.is_user==1) {/* the change is valid but to see result must be user mode */
                view_gray_levels_setup(pview.contrast_value);
                view_image_compute();
                if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
                draw_view_area();
                }
}
/*********************************/

/* range for the matrix  and redraw (toggle) */
void
on_view_range_matrix_activate(GtkButton *button, gpointer my_data)
{
if( is_debug==1) printf("on_view_range_block_activate:\n");
pview.is_range_type=1;
if(pview.is_user==1) {/* the change is valid but to see result must be user mode */
                view_gray_levels_setup(pview.contrast_value);
                view_image_compute();
                draw_view_area();
                }
}
/*********************************/

/* range for the adaptive  and redraw (toggle) */
void
on_view_range_adaptive_activate(GtkButton *button, gpointer my_data)
{
if( is_debug==1) printf("on_view_range_adaptive_activate:\n");
pview.is_range_type=2;
if(pview.is_user==1) {/* the change is valid but to see result must be user mode */
                view_gray_levels_setup(pview.contrast_value);
                view_image_compute();
                if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
                draw_view_area();
                }
}
/*********************************/

/* choose G (if possible) */
void 
on_view_g_activate(GtkButton *button, gpointer user_data)
{
if (pview.is_gru==1) return; /* do nothing when deselected  */
pview.is_gru=1;
view_is_fake=0;
view_is_file=0;
view_file_activated=0;
if (completed.dimension_m != view_dimension) {
	free(vrs);
	free(vcs);
	view_dimension=completed.dimension_m;
	vrs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
	vcs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
	}
max_min_view_compute();
view_gray_levels_setup(pview.contrast_value);
view_image_compute();
if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
draw_view_area();
g_idle_add((GtkFunction) view_labels_update,NULL);
}
/*********************************/

/* choose R (if possible) */
void 
on_view_r_activate(GtkButton *button, gpointer user_data)
{
if (pview.is_gru==2) return; /* do nothing when deselected  */
pview.is_gru=2;
view_is_fake=0;
view_is_file=0;
view_file_activated=0;
if (completed.dimension_m != view_dimension) {
        free(vrs);
        free(vcs);
        view_dimension=completed.dimension_m;
        vrs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
        vcs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
        }
max_min_view_compute();
view_gray_levels_setup(pview.contrast_value);
view_image_compute();
if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
draw_view_area();
g_idle_add((GtkFunction) view_labels_update,NULL);
}
/*********************************/

/* choose U (if possible) */
void 
on_view_u_activate(GtkButton *button, gpointer user_data)
{
if (pview.is_gru==3) return; /* do nothing when deselected  */
pview.is_gru=3;
view_is_fake=0;
view_is_file=0;
view_file_activated=0;
if (completed.dimension_m != view_dimension) {
        free(vrs);
        free(vcs);
        view_dimension=completed.dimension_m;
        vrs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
        vcs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
        }
max_min_view_compute();
view_gray_levels_setup(pview.contrast_value);
view_image_compute();
if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
draw_view_area();
g_idle_add((GtkFunction) view_labels_update,NULL);
}
/*********************************/

/* open the file selection dialog */
void 
on_view_file_activate(GtkButton *button, gpointer user_data)
{
if(is_debug==1) printf("on_view_file_activate: comparison=%d\n",is_view_comparison);
if(view_file_activated==1) return; /* do not open file dialog on deselecting button */
if(is_view_fs_open==1) {
    gtk_statusbar_push(GTK_STATUSBAR(statusb_view),0,"  You are just readin a file ! ");
    return;
    }
view_file_activated=1; /* button is activated - used by fallback routine to deselect button */
is_view_fs_open=1;
is_view_comparison=0; /* plain read of file */
view_file_read=create_fileselection_read_matrix();
gtk_widget_show (view_file_read);
}
/*********************************/

/* choose the test pattern */
void
on_view_test_activate(GtkButton *button, gpointer user_data)
{
if(is_debug==1) printf("on_view_test_activate: \n");
pview.is_gru=0;
view_is_fake=1;
view_is_file=0;
view_file_activated=0;
if (fake_dim != view_dimension) {
        free(vrs);
        free(vcs);
        view_dimension=fake_dim;
        vrs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
        vcs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
        }
max_min_view_compute();
view_gray_levels_setup(pview.contrast_value);
view_image_compute();
if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
draw_view_area();
g_idle_add((GtkFunction) view_labels_update,NULL);
}
/*********************************/

/******************* Callbacks:  view_area  ***********************/

/* Draw Matrix  from buffer view_matvalue   ****** Callback "expose" event */
gboolean
draw_view_area_callback (GtkWidget *widget, GdkEventExpose *event, gpointer data)
{
GdkCursor  *crosshair;
max_min_view_compute();
view_gray_levels_setup(pview.contrast_value);
view_image_compute();
if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
crosshair = gdk_cursor_new(GDK_TCROSS); 
gdk_window_set_cursor(widget->window, crosshair);
gdk_cursor_destroy(crosshair);
draw_view_area();
if (is_debug==1) printf("draw_view_area_callback: exiting \n");
return TRUE;
}
/*********************************/


/* draw view_area uses view_matvalue or rgb_view_matvalue to redraw into view_area drawable  */
void
draw_view_area()
{
if (pview.is_color==0) gdk_draw_gray_image (view_area->window,
                view_area->style->fg_gc[GTK_WIDGET_STATE (view_area)],
                0, 0, VPIX+VPIXS+VPIXV,VPIX,GDK_RGB_DITHER_NORMAL,view_matvalue,VPIX+VPIXS+VPIXV);
                else
                gdk_draw_rgb_image(view_area->window,
                view_area->style->fg_gc[GTK_WIDGET_STATE (view_area)],
                0, 0, VPIX+VPIXS+VPIXV,VPIX,GDK_RGB_DITHER_NORMAL,rgb_view_matvalue,3*(VPIX+VPIXS+VPIXV));
}
/*********************************/


/* calculating image from matrix G/R/U or read from file  */
void
view_image_compute()
{
/* int * view_matvalue, rgb_view_matvalue; global */
int i,j,h,k,m,v;
double r;
if(is_debug==1) printf("view_image_compute: begins pview.is_gru=%d\n",pview.is_gru);
m=view_dimension; 

if (pview.is_range_type==2) for(i=0;i<256;i++) view_numlev[i]=0; /* adaptive range type */
if (pview.is_color==0) {
   /* compute view_matvalue   for gray  */
   for(i=0;i<VPIX;i++) for(j=0;j<VPIX+VPIXS+VPIXV;j++) {
        h=(i*m)/VPIX+1;
        k=(j*m)/VPIX+1;
        if (j<VPIX) { /* block values */
		 r=view_get_data(h,k);
                 v=view_get_gray_level(r);
                 if ((pview.is_range_type==2)&&(pview.is_user==1)) view_numlev[v]++;
                 if (pview.is_positive==1) v=255-v;
                  view_matvalue[i*(VPIX+VPIXS+VPIXV)+j]=  (char)v;
                }
        else if (j<VPIX+2) { /* black line */
                 view_matvalue[i*(VPIX+VPIXS+VPIXV)+j] = 255*pview.is_positive;
                }
        else if (j<VPIX+VPIXS-2) { /* gray space */
                view_matvalue[i*(VPIX+VPIXS+VPIXV)+j] = 225;/* ligth gray */
                }
        else if (j<VPIX+VPIXS) {/* black line */
                view_matvalue[i*(VPIX+VPIXS+VPIXV)+j] = 255*pview.is_positive;
                }
        else  { /* vertical column with sums of rows values */
                v=view_get_gray_level(vrs[h]);
                if ((pview.is_range_type==2)&&(pview.is_user==1)) view_numlev[v]++;
                if (pview.is_positive==1) v=255-v;
                view_matvalue[i*(VPIX+VPIXS+VPIXV)+j] =  (char)v;
                }
        }
   /* view_matvalue computed */
   } else {
   /* compute rgb_view_matvalue for colors */
   for(i=0;i<VPIX;i++) for(j=0;j<VPIX+VPIXS+VPIXV;j++) {
        h=(i*m)/VPIX+1;
        k=(j*m)/VPIX+1;
        if (j<VPIX) { /* block values */
		  r=view_get_data(h,k);
                  v=view_get_gray_level(r);
                  if ((pview.is_range_type==2)&&(pview.is_user==1)) view_numlev[v]++;
                  if (pview.is_positive==1) v=255-v;
                  rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)]=  (char)v;
                  rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)+1]=  (char)(35);
                  rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)+2]= (char)(255-v);
                }
        else if (j<VPIX+2) { /* black line */
                 rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)] =   (char)(255*pview.is_positive);
                 rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)+1] = (char)(255*pview.is_positive);
                 rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)+2] = (char)(255*pview.is_positive);

                }
        else if (j<VPIX+VPIXS-2) { /* gray space */
                rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)] = (char)225;
                rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)+1] = (char)255;
                rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)+2] = (char)225;
                }
        else if (j<VPIX+VPIXS) {/* black line */
                rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)] = (char)(255*pview.is_positive);
                rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)+1] = (char)(255*pview.is_positive);
                rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)+2] = (char)(255*pview.is_positive);
                }
        else  { /* vertical column with sums of rows values */
                v = view_get_gray_level(vrs[h]);
                if ((pview.is_range_type==2)&&(pview.is_user==1)) view_numlev[v]++;
                if (pview.is_positive==1) v=255-v;
                rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)] =  (char)v;
                rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)+1] =  (char)(35);
                rgb_view_matvalue[3*(i*(VPIX+VPIXS+VPIXV)+j)+2] =  (char)(255-v);
                }
        }
   /* rgb_view_matvalue computed */
   }
if(is_debug==1) printf("view_image_compute: ends \n");
}
/*********************************/

/* the levels view_gray_levels[256] are number ordered increasing  */
/* we get the index i such that view_gray_levels[i]<=x<view_gray_levels[i+1] */
/* precisely:
 * 0   x (-inf,L[1])  L[1]=0 typical   L[0] not used !!!
 * 1   x [L[1], L[2])
 * .....
 * 254 x [L[254],L[255]) 
 * 255 x [L255], +inf) L[255]=1 typical
 */
int
view_get_gray_level(double x)
{
int i;
i=0;
if (x > view_gray_levels[128])  i=128;
if (x > view_gray_levels[i+64]) i+=64;
if (x > view_gray_levels[i+32]) i+=32;
if (x > view_gray_levels[i+16]) i+=16;
if (x > view_gray_levels[i+8]) i+=8;
if (x > view_gray_levels[i+4]) i+=4;
if (x > view_gray_levels[i+2]) i+=2;
if (x > view_gray_levels[i+1]) i+=1;
return(i);
}
/*********************************/

/* linear or nonlinear setup of view_gray_levels 
 * parameter a affects the shape of nonlinear curve 
 * in the case of user selected range type 0 1 2 and
 * in such cases tha max and min values computed by 
 * max_min_view_compute() are needed !
 */
void
view_gray_levels_setup(double a)
{
/* double vrmax, vrmin;   globals */
int i;
double min,max;
if (pview.is_user==0) {
        view_gray_levels[0]=0; /* not used ... */
        for (i=1;i<256;i++) view_gray_levels[i]= ((double)1.0 *(i-1))/254.0; /* L[1]=0.0  L[255]=1.0 */
        if(is_debug==1) printf("view_gray_levels_setup: (user=0) a=%g, L[0]=%g,L[1]=%g,L[2]=%g,...L[254]=%g,L[255]=%g\n",a,view_gray_levels[0],view_gray_levels[1],view_gray_levels[2],view_gray_levels[254],view_gray_levels[255]);
        return;
        } else {
        switch(pview.is_range_type) {
           case 2:
                min=view_mat_qmin; /* first non zero minimum if possible */
                max=vrmax;
                break;
           case 1: 
                min=view_mat_qmin;
                max=vrmax;
                break;
           case 0: /* [0,1] full range */
                min=0;
                max=1;
                break;
           default:
                min=0;
                max=1;
           }
       if(min==max) {min=0;max=1;} /* is needed ??? */
       view_gray_levels[0]=0;
       view_gray_levels[1]=0; /* hard minimum is fixed to 0.0 */
       if(a==0) for (i=2;i<256;i++) view_gray_levels[i]= (max-min)*((double)1.0 *(i-1))/254.0 + min;
       if(a>0) for (i=2;i<256;i++) view_gray_levels[i]= (max-min)*pow(((double)1.0 *(i-1))/254.0,a)+min;
       if(a<0) for (i=2;i<256;i++) view_gray_levels[i]= (max-min)*pow(((double)1.0 *(i-1))/254.0,-1/(a-1))+min;
       }
if(is_debug==1) printf("view_gray_levels_setup: (user=1) a=%g, max=%g min=%g L[0]=%g,L[1]=%g,L[2]=%g,...L[254]=%g,L[255]=%g\n",a,max,min,view_gray_levels[0],view_gray_levels[1],view_gray_levels[2],view_gray_levels[254],view_gray_levels[255]);
}
/*********************************/

/* get data  fortran style i, j from 1 to view_dimension */
double view_get_data(int i,int j)
{
/* struct edita_str pview;  global    preferences view windows */
/* int view_is_file; global  0=no 1=yes */
/* int  view_dimension; */
/* int view_is_fake; global */
/* double fake_matrix[26];  fake matrix to load in event of missing data  fortran style indexes 4 x 4 */

double r;
/* check dimensioning just not to read gibberish */
if ((i<1)||(j<1)||(i>view_dimension)||(j>view_dimension)) {
		printf("Tombola ! i=%d j=%d pview.is_gru=%d\n",i,j,pview.is_gru);
		r=0.0;
		return(r);
		}
r=0.0;
if(pview.is_gru==1) read_matg_(&i,&j,&r);
if(pview.is_gru==2) read_matr_(&i,&j,&r);
if(pview.is_gru==3) read_matu_(&i,&j,&r);
if((pview.is_gru==0)&&(view_is_file==1)) r=view_file_data[i+view_dimension*(j-1)];
if(view_is_fake==1) r= fake_matrix[i+view_dimension*(j-1)];
return(r);
}
/*********************************/

/* compute max min every time matrix is changed */
void
max_min_view_compute()
{
int i,j,m;
double r;
/* double view_mat_max,view_mat_min,view_mat_qmin; globals */
/* double *vrs, vrmax,vrmin;   globals   allocated in create_view_window, sum of rows  and maximum and minimum values  */
/* double *vcs, vcmax,vcmin;   globals   allocated in create_view_window, sum of columns  and maximum and minimum values  */
/* int  view_file_dimension; global */
/* int view_is_file; global  0=no 1=yes */
/* struct running_problem_str  completed; global */
/* struct edita_str pview;  global    preferences view windows */
/* double fake_matrix[26];  fake matrix to load in event of missing data  fortran style indexes 4 x 4 */
/* int view_is_fake; global */
/* int  view_dimension; */

m=view_dimension; 
/* sums the rows of the block and compute their maximum */
i=1;
j=1;
r=view_get_data(i,j);
vrmax=r; /*row max min */
vrmin=10E+100;
vcmax=r; /*columns max min */
vcmin=10E+100;
view_mat_max=r;
view_mat_min=r;
view_mat_qmin=r+1;
vrs[0]=0.0;/* not used */
vcs[0]=0.0;
for(i=1;i<=m;i++) {
                vrs[i]=0.0;
                for(j=1;j<=m;j++) {
			r=view_get_data(i,j);
                        if(view_mat_max<r) view_mat_max=r;
			if(view_mat_min>r) view_mat_min=r;
			if((view_mat_qmin>r)&&(r>0)) view_mat_qmin=r;
			vrs[i]=vrs[i]+r;
                        }
                if(vrs[i]>vrmax) vrmax=vrs[i];
                if(vrs[i]<vrmin) vrmin=vrs[i];
                }

for(i=1;i<=m;i++) {
                vcs[i]=0.0;
                for(j=1;j<=m;j++) {
                        r=view_get_data(j,i);
                        vcs[i]=vcs[i]+r;
                        }
                if(vcs[i]>vcmax) vcmax=vcs[i];
                if(vcs[i]<vcmin) vcmin=vcs[i];
                }


if(is_debug==1) printf("max_min_view_compute: dim=%d view_mat_max =%g, view_mat_min =%g, view_mat_qmin =%g vrmax=%g, vrmin=%g, vcmax=%g, vcmin=%g\n",m,view_mat_max,view_mat_min,view_mat_qmin,vrmax,vrmin,vcmax,vcmin);
}
/*********************************/


/* adaptive case: view recompute levels 
 * using old levels and numerosity of levels view_numlev 
 * must be called after computing once gray levels and image
 */
void
view_recompute_levels(double a)
{
/* double gray_levels[256]; global */
double newlev[256];
double max,min,v;
int quota[256], interval[256],interval_num[256];
int i,j,k,h;
int s,usl,unusl,spacers;
int cont;
/* memo:
 * the levels view_gray_levels[256] are number ordered increasing  
 * we get the index i such that view_gray_levels[i]<=x<view_gray_levels[i+1] 
 * precisely:
 * 0   x (-inf,L[1])  L[1]=0 typical   L[0] not used !!! view_numlevel[0] refers to <= L[1]
 * 1   x [L[1], L[2])                                    view_numlevel[1] refers to  <=L[2]
 * .....
 * 254 x [L[254],L[255]) 
 * 255 x [L255], +inf) L[255]=1 typical                  view_numlevel[255] refers to >=L[255] 
 */
/* memo:
 * in the step prior to this, we did call max_min_view_compute and  view_gray_levels_setup with
 * min=; max=vrmax; and the choosen contrast, L[0]=L[1]=0,
 * and L[2]...L[255] were assigned with
 * (max-min)*pow(((double)1.0 *(i-1))/254.0,a)+min or similar, depending on 
 * the contrast a.
 */
/* memo:
 * VPIX*(VPIX+VPIV) is the total number of pixels, the sum of numlev.
 */

/* count unused levels  */
usl=0;
unusl=0;
for(i=0;i<256;i++) if( view_numlev[i] ==0) unusl++; else usl++;
if(is_debug==1) {
                printf("view_recompute_levels:  entering we count on 256 levels %d assigned levels,   %d unassigned levels\n",usl,unusl);
                }
/* clean all */
for(i=0;i<256;i++){
                interval[i]=0;
                interval_num[i]=0;
                newlev[i]=-1.0;
                quota[i]=0;
                }
/* compute interval[i], reporting the number of nonvoid levels starting on i-th level */
for(i=0;i<256;i++){
    if(view_numlev[i]!=0) {
        j=i;
        cont=0;
        while (cont==0){
                j++;
                if((view_numlev[j]==0)||(j==256)) cont=1;
                }
        interval[i]=j-i; /* if j==i 1 */
        i=j;
       }/* else increment i */
    }
/* compute numerosity of intervals */
for (i=0;i<256;i++) if (interval[i]!=0) {
        s=0;
        for (j=i;j<i+interval[i];j++) s=s+view_numlev[j];
        interval_num[i]=s;
        }
if(is_debug==1) for(i=0;i<256;i++) if(interval_num[i]!=0) printf("view_recompute_levels:  pre reassign interval[%d]=%d, interval_num=%d bounds [%g,%g]\n",i,interval[i],interval_num[i],view_gray_levels[i],view_gray_levels[i+interval[i]]);
/* reassign levels */
k=0;
for(i=0;i<256;i++) if (interval[i]!=0) k=k+interval_num[i]; /* well k should be VPIX*(VPIX+VPIXV), but we check for debugging errors ... */
if(is_debug==1) printf("view_recompute_levels:  pre reassign interval numerosity %d - VPIX=%d\n",k,VPIX*(VPIX+VPIXV));
/* we now reassign the free levels giving a quota[i] to each non void interval i */
/* k is the total number of pixels involved in reassign , interval_num[i] in every interval */
for(i=0;i<256;i++) if (interval[i]!=0) { /* these are the intervals to reassign */
        v=interval_num[i] *unusl;
        quota[i]= interval[i]+floor(v/k) ;
    }
/* better count totals ... */
j=0;
for(i=0;i<256;i++) if (interval[i]!=0) j=j+quota[i];
spacers=256-j; /* these levels can be used to separate leves with void levels */
if (is_debug==1)    printf("view_recompute_levels:  now we count on 256 levels %d assigned levels,   %d unassigned levels, reassigning total %d, spacers=%d\n",usl,unusl,j,spacers);
/* now reassign spacers to biggest  quota  */
k=0;
for(i=0;i<256;i++) if(interval[i]!=0) if(quota[i]>k) {h=i; k=quota[i];}
quota[h]=quota[h]+spacers;
/* better recount totals ... */
j=0;
for(i=0;i<256;i++) if (interval[i]!=0) j=j+quota[i];
spacers=256-j; /* these levels can be used to separate leves with void levels */
if (is_debug==1)    printf("view_recompute_levels:  now we recount on 256 levels %d assigned levels,   %d unassigned levels, reassigning total %d, spacers=%d\n",usl,unusl,j,spacers);

newlev[0]=0.0;
j=1;  /*first level to reassign */
for(i=0;i<256;i++) if (interval[i]!=0) {
        min=view_gray_levels[i];
        if(i+1+interval[i] <256) max=view_gray_levels[i+1+interval[i]]; else max=1.1;
        if (is_debug==1) printf("view_recompute_levels: interval %d [%g,%g] : reassigning %d levels (old %d) \n",i, min,max,quota[i],interval[i]);
          if(a==0) for (k=j;k<j+quota[i];k++) newlev[k]= (max-min)*((double)1.0 *(k-j))/quota[i] + min;
          if(a>0)  for (k=j;k<j+quota[i];k++) newlev[k]= (max-min)*pow(((double)1.0 *(k-j))/quota[i],a)+min;
          if(a<0)  for (k=j;k<j+quota[i];k++) newlev[k]= (max-min)*pow(((double)1.0 *(k-j))/quota[i],-1/(a-1))+min;
          j=j+quota[i];
          }

/* at this point there should be no newlev with value -1 ! */
for(i=0;i<256;i++) if (newlev[i]==-1.0) printf("nelwv = -1 !!! %d\n",i);

/* now copy and sort the levels */
view_gray_levels[0]=newlev[0];
for(i=0;i<256;i++) { /* get the minimum for the first gray level */
	if (newlev[i]<view_gray_levels[0]) view_gray_levels[0]=newlev[i];
	}
view_gray_levels[255]=view_gray_levels[0];
for(i=0;i<256;i++) { /* get the maximum for the last gray level */
        if (newlev[i]>view_gray_levels[255]) view_gray_levels[255]=newlev[i];
        }
for(i=1;i<255;i++) { /* for others levels go growing */
     view_gray_levels[i]=view_gray_levels[255];
     for (j=0;j<256;j++) if ((newlev[j]<view_gray_levels[i])&&(newlev[j]>view_gray_levels[i-1])) view_gray_levels[i]=newlev[j];
   }
}
/*********************************/

/* Read  File Selection Dialog Interface  ***** Interface */
GtkWidget*
create_fileselection_read_matrix(void)
{
GtkWidget *fileselection;
GtkWidget *ok_button;
GtkWidget *cancel_button;
if (is_view_comparison==0) fileselection = gtk_file_selection_new("Read Matrix to View");
else  fileselection = gtk_file_selection_new("Read Matrix to Compare");

gtk_container_set_border_width (GTK_CONTAINER (fileselection), 10);
gtk_file_selection_set_filename (GTK_FILE_SELECTION(fileselection),pathgru_fs);
ok_button = GTK_FILE_SELECTION (fileselection)->ok_button;
gtk_widget_show (ok_button);
GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
cancel_button = GTK_FILE_SELECTION (fileselection)->cancel_button;
gtk_widget_show (cancel_button);
GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

/* GTK_RESPONSE_DELETE_EVENT */
g_signal_connect ((gpointer) cancel_button, "clicked", G_CALLBACK (on_cancel_button_fsread_matrix_clicked), NULL);
g_signal_connect ((gpointer) fileselection, "destroy", G_CALLBACK (on_destroy_fsread_matrix),NULL);
g_signal_connect ((gpointer) ok_button,"clicked", G_CALLBACK (on_ok_button_fsread_matrix_clicked), NULL);

return fileselection;
}
/*****************************/

/* Read  File Selection Dialog: cancel ***** Callback */
void
on_cancel_button_fsread_matrix_clicked      (GtkButton   * button, gpointer user_data )
{
if(is_debug==1) printf("Read File Selection Dialog Matrix: quit\n");
gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}
/*********************************/

/* Read  File Selection Dialog: destroy ***** Callback */
void
on_destroy_fsread_matrix      (GtkWidget   * ww, gpointer user_data )
{
if(is_debug==1) printf("Read File Selection Dialog Matrix: destroy\n");
is_view_fs_open=0; /* now file selection is closed */
view_fallback();
}
/*********************************/


/* Read File Selection Dialog: ok ***** Callback    ONE ASCII FILE  */
/* we look for an ASCII file containing a single square matrix, either matlab of fortran style */
/* some integers at the beginning are clues for dimension in fortran style */
/* comments and void lines are ignored */
/* if is_view_comparison==0 the file is read in memory else, if dimensions are compatible, 
   the norm of the difference is computed */ 
void
on_ok_button_fsread_matrix_clicked      (GtkButton   *button, gpointer user_data)
{
/* GtkWidget  *view_file_read; global */

gchar * filename;
char * tmp_name;
FILE * readfile;
int c;                  /* read from file one char by one */
char num_str[1024];     /* a number with more then 1024 digits will crash the program ... to fix later ...*/
long int fl, ln, nonasc;/* file length, number of lines, non ascii chars not in comment line */
int kl;                 /* comment lines */
int totint;             /* total strings corresponding to integers number */
long int totfl,ckfl;    /* total strings corresponding to floating point numbers and number of floats really read from file */
int i,j,ma,err; /* ma,na dimensions  i,j,k indexes, err error flag */
double  r;              /* float value to read */
int int1,int2,int3,ii;  /* first 3 integers present in the file, if any, and how many (0,1,2,3) of them */
char buf[256] ;
int matlab_valid,rows,columns, oldcolumns;   /* matlab_valid=1 if the file is NOT a matlab matrix */
double comp_diff;

/* Extract filename from the file selection dialog */
filename = (char *)gtk_file_selection_get_filename(GTK_FILE_SELECTION(view_file_read));
if(is_debug) printf("on_ok_button_fsread_matrix_clicked:  filename = %s\n",filename);
if ((readfile = fopen(filename,"r+")) == NULL) {  /* "r" should be enougth.. but with "r" dir can be opended too, and a check will be needed */
        /* File not readable popup  */
        gtk_widget_show(create_dialog_noreadable(view_file_read));
	view_fallback();
        return;
        }
/* file is open ok  */
pathstripper(filename,pathgru_fs);   /* save the path the same as for saving g,r,u, */

/* first step: scan the file to get length, check if ascii or not, check line separators, count possible integers and float 
 * read, if present, the first 3 integers, count sparse matrix pattern (I I I F ), check for regular rows of floats for 
 * matlab ASCII matrix format - for valid matlab ascii we require no integers, floats only, same number in each line.
 */
err = 0; /* no error till now */
fl=0; /* file length */
ln=0; /* lines */
nonasc=0; /* ascii >128 */
kl=0; /* comment lines */
totint=0; /* strings corresponding to integers */
totfl=0;  /* strings corresponding to floats */
ii=0;     /* count if preset first 3 integers */
int1=0;
int2=0;
int3=0;
matlab_valid=0; /* if this =1 we are shure that the file is not compatible with pure float ascii matrix matlab style */
rows=0;  /* number of rows of pure float ascii matrix matlab style */
columns=0;  /* number of columns of pure float ascii matrix matlab style (counting variable) */
oldcolumns=0; /* number of columns of pure float ascii matrix matlab style (first line - if any - ) */
if (is_debug==1) printf("on_ok_button_fsread_matrix_clicked:  file scan begins\n");
/* watch_for_number: initialize with watch_for_number(0, 0,num_str); and fill num_str with 0 before using; add watch_for_number('\n', 1,num_str) at last.
 * return value: 0=other ASCII <128   1=considering a number    2=comment line and new line    3=new line    4=new line following a new line
                 5=int   6=int and new line   7=floatFP   8=floatEX   9=floatFP and new line   10 floatEX and new line  11 ASCII > 127 not in comment line */
for(i=0;i<1024;i++)num_str[i]=0; /* clean input string */
watch_for_number(0, 0,num_str);  /* initialization     */
/* main loop for scanning file begins */
while((c = getc(readfile)) != EOF) {
        fl++; /* file length */
        switch(watch_for_number(c, 1,num_str)) {
                case 2:  kl++; matlab_valid=1; break; /* comments lines not allowed in matlab ascii matrix */
                case 3:  ln++;
                        rows++;
                        if(oldcolumns==0) oldcolumns=columns; /* first row only */
                        if (oldcolumns!=columns) matlab_valid=1;
                        columns=0;
                        break;
                case 6:  ln++;
                case 5:  totint++; matlab_valid=1; /* integers not allowed in matlab ascii matrix */
                                switch(ii){
                                case 0: sscanf(num_str,"%d",&int1);ii=1;break;
                                case 1: sscanf(num_str,"%d",&int2);ii=2;break;
                                case 2: sscanf(num_str,"%d",&int3);ii=3;break;
                                }
                                break;
                case 7: totfl++;
                        columns++;
                        break;
                case 8: totfl++;
                        columns++;
                        break;
                case 9: ln++;totfl++;
                        columns++;
                        rows++;
                        if(oldcolumns==0) oldcolumns=columns; /* first row only */
                        if (oldcolumns!=columns) matlab_valid=1;
                        columns=0;
                        break;
                case 10: ln++;totfl++;
                        columns++;
                        rows++;
                        if(oldcolumns==0) oldcolumns=columns; /* first row only */
                        if (oldcolumns!=columns) matlab_valid=1;
                        columns=0;
                        break;
                case 11: nonasc++;matlab_valid=1;break; /* nonascii not allowed in matlab ascii matrix */
                default:break;
                };
        }
/* main loop for scanning file ends */
if (is_debug==1) printf("on_ok_button_fsread_matrix_clicked:  file scan ends\n");
if (is_debug==1) printf("on_ok_button_fsread_matrix_clicked: filelength=%ld, lines=%ld, nonascii chars = %ld, comment lines=%d,\n",fl,ln,nonasc,kl);
if (is_debug==1) printf("on_ok_button_fsread_matrix_clicked: integers=%d, floats=%ld \n",totint,totfl);
if (is_debug==1) if (ii==0) printf("on_ok_button_fsread_matrix_clicked: no integers\n");
if (is_debug==1) if (ii==1) printf("on_ok_button_fsread_matrix_clicked: int1=%d \n",int1);
if (is_debug==1) if (ii==2) printf("on_ok_button_fsread_matrix_clicked: int1=%d int2=%d \n",int1,int2);
if (is_debug==1) if (ii==3) printf("on_ok_button_fsread_matrix_clicked: int1=%d int2=%d int3=%d\n",int1,int2,int3);
if (is_debug==1) printf("on_ok_button_fsread_matrix_clicked: matlab valid=%d, rows=%d columns=%d places =%d\n",matlab_valid,rows,oldcolumns,oldcolumns*rows);
/* second step: if the file structure is compatible with the required problem, dimension the matrices and read the data */
if(nonasc > 10) {
        /* non ascii chars in the file ! reject ! */
           gtk_widget_show(create_dialog_data_noreadable(view_file_read,"\nThe file contains NON ASCII chars !\n"));
           fclose(readfile); 
	   return;
        }
if(totfl < 4) {
        /* too little floats in the file ! reject ! */
           gtk_widget_show(create_dialog_data_noreadable(view_file_read,"\nThe file contains very few Floats !\n"));
	   fclose(readfile);
	   view_fallback();
           return;
        }
/* from here on we reinforce the significance of matlab_valid, to be operative requires correct dimensioning */
if (matlab_valid==0) {
                            if ((oldcolumns!=rows)||(totfl- rows*rows !=0)||(ii!=0) ) matlab_valid=1; else {
			          ma=rows;
                                  if(is_debug==1) printf("on_ok_button_fsread_matrix_clicked: Matlab valid=%d ,ASCII matrix size %d x %d detected\n",matlab_valid,ma,ma);
                      		}
			}
/* from now on if matlab_valid==0 we really have a  ascii matlab matrix  */
j=sqrt((double)totfl);
if (j*j!=totfl) {
         gtk_widget_show(create_dialog_data_noreadable(view_file_read,"\nThe floats number is not a perfect square !\n"));
        fclose(readfile); 
        view_fallback();
	return;
	}
if ((ii==0)&&(matlab_valid==1)) {
		/* ilast chance: maybe it is a fortran style file ?  */
		ma=j;
		if(is_debug==1) printf("on_ok_button_fsread_matrix_clicked: maybe a Fortran style matrix %d x %d\n",ma,ma);
		}
/* now we have j*j floats, and some integers */
if(ii>=1) {
	ma=j;
        /* al least first integer present , may be it is the dimension */
	if (int1==j) { /* yes it is */
		if(is_debug==1) printf("on_ok_button_fsread_matrix_clicked:  Fortran style matrix %d x %d - first integer is dimension\n",ma,ma);
		} else {
		if(is_debug==1) printf("on_ok_button_fsread_matrix_clicked:  Fortran style matrix %d x %d - first integer dubious %d\n",ma,ma,int1);
		}
	  }
/* here ma is the dimension and we have ma*ma floats; fortran or matlab style */
/* for comparison to work we need the same dimension */
if((is_view_comparison==1)&&(ma!=view_dimension)) {
		sprintf(buf,"\nThe dimensions are differents\n (Matrix:%d  File:%d) \n",view_dimension,ma);
		gtk_widget_show(create_dialog_data_noreadable(view_file_read,buf));
         	fclose(readfile);
		return;
		}
/* if we are reading and not comparing, we must allocate the matrix */
if(is_view_comparison==0) {
   view_file_data=(double *) malloc((ma+1)*(ma+1)*sizeof(double));
   if (view_file_data==NULL) {
        sprintf(buf,"\n  Allocation of A did Fail !\n(%ld Floats needed)\n",totfl);
        gtk_widget_show(create_dialog_data_noreadable(view_file_read,buf));
        view_fallback();
        return;
        }
   }
/* rewind the file */
fseek(readfile,(long int) 0,SEEK_SET);

if(is_view_comparison==1) view_compare_out=0.0; /* initialize comparison value */
/* read the data */
for(i=0;i<1024;i++)num_str[i]=0; /* clean input string */
watch_for_number(0, 0,num_str);  /* initialization     */
i=1;
j=1;
ckfl=0; /* will count real really read */
while(((c = getc(readfile)) != EOF)&&(err==0)) {
        switch(watch_for_number(c, 1,num_str)) {
                case 7:
                case 8:
                case 9:
                case 10:
                        if(sscanf(num_str,"%lf",&r)==0) err=1;  /*printf(" %s --> A(%d,%d)=%g\n",num_str,i,j,r);*/
                        ckfl++;
			if (is_view_comparison==1) {
						comp_diff=r-view_get_data(j,i);
						view_compare_out=view_compare_out+comp_diff*comp_diff;
						} else {
                                                view_file_data[(i-1)*ma+j]=r; /* column j row i from 1 to ma fortran style */
						}
                        if(matlab_valid==0) {
                                i++; 
				if (i>ma) {i=1;j++;}
				} else{ 
                                j++; 
				if (j>ma) {j=1;i++;}
                                }
                        break;
                default:break;
                };
        }
 if (err!=0) {
        sprintf(buf,"\n Some Error in reading floats !  " );
        gtk_widget_show(create_dialog_data_noreadable(view_file_read,buf));
	fclose(readfile);
	view_fallback();
        return;
        }
 if (ckfl!=totfl) {
        sprintf(buf,"\n We did skip some float ! " );
        gtk_widget_show(create_dialog_data_noreadable(view_file_read,buf));
	fclose(readfile);
	view_fallback();
        return;
        }
/* now it should be ok */

/* if it is a comparison we are finished */
if (is_view_comparison==1) {
        view_compare_out=sqrt(view_compare_out);
        g_idle_add((GtkFunction) view_labels_update,NULL);
        gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button))); /* close file selection dialog  */
        is_view_fs_open=0; /* now file selection is closed */
        return;
	}
/* else finish setup of file data */
tmp_name = basename(filename);
strcpy(view_file_name,tmp_name);
view_dimension=ma;
view_is_file=1; /* 0=no 1=yes */
view_is_fake=0;
pview.is_gru=0;
view_file_activated=1;
free(vrs);
free(vcs);
vrs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
vcs=malloc((view_dimension+1)*sizeof(double)); /* remember that index goes from 1 to dimension .. Fortran style */
max_min_view_compute();
view_gray_levels_setup(pview.contrast_value);
view_image_compute();
if((pview.is_range_type==2)&&(pview.is_user==1)) {view_recompute_levels(pview.contrast_value);view_image_compute();}
draw_view_area();
g_idle_add((GtkFunction) view_labels_update,NULL);
gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button))); /* close file selection dialog  */
is_view_fs_open=0; /* now file selection is closed */
if(is_debug==1)printf("dim=%d name=%s view_is_file=%d\n",view_dimension,view_file_name,view_is_file);
}
/*********************************/

/* */
void 
on_view_compare_activate(GtkButton *button, gpointer my_data)
{
if(is_view_fs_open==1) {
    gtk_statusbar_push(GTK_STATUSBAR(statusb_view),0,"  You are just readin a file ! ");
    return;
    }
is_view_fs_open=1;
is_view_comparison=1; /* comparison required */
view_file_read=create_fileselection_read_matrix();
gtk_widget_show (view_file_read);
}
/*********************************/

/* when cancelling file read, we need to fallback to test button */
void 
view_fallback()
{
gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_matrix_file),FALSE);
switch (pview.is_gru) {
        case 0: /* in this case no matrix is available */
                break;
        case 1:
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button_matrix_g),TRUE);
                break;
        case 2:
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(button_matrix_r),TRUE);
                break;
        case 3:
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_matrix_u),TRUE);
                break;
        }
if (view_is_fake==1) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button_matrix_test),TRUE);
view_file_activated=0;
}
/*********************************/
