!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  Structured Markov Chains Solver      [  SMCSolver  ]       !
!  Dario Bini, Beatrice Meini, Sergio Steffe'                 !
!  bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    !
!  Dipartimento di Matematica "Leonida Tonelli"               !
!  Largo Pontecorvo 5                                         !
!  56127 Pisa                                                 !
!  Italy                                                      !
!  Version 1.3 - March 2007                                   !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!   ponte.f90                                                 !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

module ponte_f_f
!
! this module contains all variables and subroutines
!           that are common to all Fortran Programs
! 
implicit none
integer,parameter :: dpr=kind(0.d0)
real(dpr),dimension(:,:,:),allocatable:: A,B
real(dpr),dimension(:,:),allocatable:: G,R,U,Pi,X0,B0,BN1
real(dpr),dimension(:),allocatable:: Pi0
real(dpr) :: fdrift !global final drift value 
logical debug  !if true debugging output to std out 
logical verb   !if true more detailed output to NotePad
logical timing !if true calculations partial times are computed (still to do)
logical finish !true if calculation did not fail
character (len=256) wout  !line of output
end module ponte_f_f

!
! Fortran routines will printout messages to the global 
! string  wout and then call print_it to print messages
! to Main Window NotePad (via FIFO buffer).
!
subroutine print_it
use ponte_f_f
implicit none
!call append_fifo(%ref(trim(wout)//char(10)//char(0)));
! some compilers like NAG prefers the following
call append_fifo((trim(wout)//char(10)//char(0)));
wout=''
end subroutine  print_it
!
! g95 adds underscore so we have
! a mixture of print_it_  and print_it__
! to cope with ...
!
subroutine print_it_
call print_it
end subroutine  print_it_

subroutine print_it_nolf
use ponte_f_f
implicit none
!call append_fifo(%ref(trim(wout)//char(0)));
!  some compilers like NAG prefers the following
call append_fifo((trim(wout)//char(0)));
wout=''
end subroutine  print_it_nolf

subroutine print_it_nolf_
call print_it_nolf
end subroutine  print_it_nolf_

