##############################################################
#  Structured Markov Chains Solver       [  SMCSolver  ]     #
#  Dario Bini, Beatrice Meini, Sergio Steffe'                #
#  bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it   #
#  Dipartimento di Matematica "Leonida Tonelli"              # 
#  Largo Pontecorvo 5                                        #  
#  56127 Pisa                                                # 
#  Italy                                                     # 
#  Version 1.3 - March 2007                                  #
##############################################################
# 
#     make.inc
# 
##############################################################
#
#   C Compiler is gcc 
CC=gcc
CFLAGS=-Wall
#CFLAGS=-Wall -g
#CFLAG=-O3
#
#   distributions tar name needs this string
#
DATESTRING=`date +"%Y.%m.%d-%H"`
#
#   Archiver for libxxx.a and ranlib, use echo if not present
#
ARCH     = ar
ARCHFLAGS= cr
#RANLIB   = echo
RANLIB = ranlib
#
#
# to use the included minimum set of blas and lapack and lapack95 routines
# use the followind path for libraries and for modules directory:
#
BLAS_LAPACK_LIB_DIR=min_blas_lapack
BLAS_LAPACK_MOD_DIR=min_blas_lapack
#
# otherwise let it point to your directory, and comment out the make of
# the libraries in Makefile
#
BLASLIB = $(BLAS_LAPACK_LIB_DIR)/libblas.a
LAPACKLIB =$(BLAS_LAPACK_LIB_DIR)/liblapack.a
LAPACK95LIB = $(BLAS_LAPACK_LIB_DIR)/liblapack95.a
LAPACKMOD = $(BLAS_LAPACK_MOD_DIR)/f77_lapack.mod  $(BLAS_LAPACK_MOD_DIR)/f95_lapack.mod \
	 $(BLAS_LAPACK_MOD_DIR)/la_auxmod.mod   $(BLAS_LAPACK_MOD_DIR)/la_precision.mod
#
# 
#   Lahey Fortran Compiler 
#      
FF=lf95 
#   lf95 requires that the main routine has name MAIN__ instead of main
#   so set the variable LAHEY to null for other compilers
#   and to LAHEY_MAIN for Lahey Fortran Compiler
LAHEY= -D "LAHEY_MAIN"
#   choose optimization level
FFOPT=
#FFOPT= --chk s
#FFOPT= --o2
#   staticlink links statically the Lahey Fortran Libraries
#   gtk-2 routines will remain dinamically linked
FFLAGSM=--staticlink --warn $(FFOPT) 
FFLAGSG= --staticlink --warn $(FFOPT) 
#   leave blank this
NOSECOND=
#   blas, lapack, lapack95, and its Fortran 95 modules 
#   must be compiled with the same  Fortran Compiler lf95.
#   
FFLIBS=-I$(BLAS_LAPACK_MOD_DIR) -L$(BLAS_LAPACK_LIB_DIR) -llapack95 -llapack -lblas
#
#
#   G95 GNU Fortran Compiler (64 bits CPU)
#
#FF= g95
#   leave blank this
#LAHEY=
#   choose optimization level
#FFOPT=
#FFOPT=-O2
#   -fzero to set up to 0 new variables
#FFLAGSM= -Wall -fzero $(FFOPT)
#FFLAGSG= -Wall -fzero $(FFOPT)
#   to let Fortran and C routines interact the external names
#   must agree, and in some routine the second underscore must
#   not be added by g95 compiler
#NOSECOND=-fno-second-underscore
#   blas, lapack, lapack95, and its Fortran 95 modules 
#   must be compiled with the same Fortran Compiler g95.
#
#FFLIBS= -I$(BLAS_LAPACK_MOD_DIR)  -L$(BLAS_LAPACK_LIB_DIR) -llapack95 -llapack -lblas 
#
#
# Intel Fortran Compiler   (32 bits CPU)
#
#FF = ifort
#   leave blank this
#LAHEY=
#   leave blank this
#NOSECOND=
#   choose optimization level
#FFOPT= -mp1 -O
#FFOPT= -check all
#FFOPT=-xP -O3
#FFLAGSM = -nofor_main -reentrancy threaded  -static-libcxa  -warn all  $(FFOPT)
#FFLAGSG = -reentrancy threaded -static-libcxa  -warn all  $(FFOPT)
#   blas, lapack, lapack95, and its Fortran 95 modules 
#   must be compiled with the same Fortran Compiler ifort.
#
#FFLIBS= -I$(BLAS_LAPACK_MOD_DIR) -L$(BLAS_LAPACK_LIB_DIR) -llapack95 -llapack -lblas 
#
#
# NAG Fortran Compiler   (32 bits CPU)
#
#FF = f95
#   leave blank this
#LAHEY=
#   leave blank this
#NOSECOND=
#   choose optimization level
#FFOPT=   -dusty -dcfuns -thread_safe  -unsharedf95
#FFOPT=  -dusty -dcfuns -thread_safe  -unsharedf95 -O4
#   as we use thread we choose the corresponding reentrancy.
#FFLAGSM =  $(FFOPT)
#FFLAGSG =  $(FFOPT)
#   blas, lapack, lapack95, and its Fortran 95 modules 
#   must be compiled with the same Fortran Compiler NAG.
#
# Red Hat needs adding libg2c.a
#
#FFLIBS=  -I$(BLAS_LAPACK_MOD_DIR)/ -L$(BLAS_LAPACK_LIB_DIR)/  -llapack95 -llapack -lblas /usr/lib/gcc-lib/i386-redhat-linux/3.2/libg2c.a
#
#
