/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 1.2 - Nov 2006                                     *
 **************************************************************
 *
 *  rw.h - reading and writing files
 *
 */

/* prototypes rw.c */
void on_ok_button_fs1_clicked      (GtkButton   *, gpointer );
void on_cancel_button_fs1_clicked  (GtkButton   *, gpointer );
void on_destroy_fs1 ( GtkWidget  *, gpointer );

void on_ok1_button_fsg_clicked      (GtkButton   *, gpointer  );
void on_ok2_button_fsg_clicked      (GtkButton   *, gpointer  );
void on_ok3_button_fsg_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fsg_clicked      (GtkButton   *, gpointer  );
void on_destroy_fsg ( GtkWidget  *, gpointer );
GtkWidget* create_fileselection_g(void);

void on_ok1_button_fsr_clicked      (GtkButton   *, gpointer  );
void on_ok2_button_fsr_clicked      (GtkButton   *, gpointer  );
void on_ok3_button_fsr_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fsr_clicked      (GtkButton   *, gpointer  );
void on_destroy_fsr ( GtkWidget  *, gpointer );
GtkWidget* create_fileselection_r(void);

void on_ok1_button_fsu_clicked      (GtkButton   *, gpointer  );
void on_ok2_button_fsu_clicked      (GtkButton   *, gpointer  );
void on_ok3_button_fsu_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fsu_clicked      (GtkButton   *, gpointer  );
void on_destroy_fsu ( GtkWidget  *, gpointer );
GtkWidget* create_fileselection_u(void);

void on_ok1_button_fsgru_clicked      (GtkButton   *, gpointer  );
void on_ok2_button_fsgru_clicked      (GtkButton   *, gpointer  );
void on_ok3_button_fsgru_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fsgru_clicked      (GtkButton   *, gpointer  );
void on_destroy_fsgru ( GtkWidget  *, gpointer );
GtkWidget* create_fileselection_gru(void);

void on_ok1_button_fssavea_clicked      (GtkButton   *, gpointer  );
void on_ok2_button_fssavea_clicked      (GtkButton   *, gpointer  );
void on_ok3_button_fssavea_clicked      (GtkButton   *, gpointer  );
void on_ok4_button_fssavea_clicked      (GtkButton   *, gpointer  );
void on_ok5_button_fssavea_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fssavea_clicked      (GtkButton   *, gpointer  );
void on_destroy_fssavea ( GtkWidget  *, gpointer );
GtkWidget* create_fileselection_savea(void);

void on_ok1_button_fssaveb_clicked      (GtkButton   *, gpointer  );
void on_ok2_button_fssaveb_clicked      (GtkButton   *, gpointer  );
void on_ok3_button_fssaveb_clicked      (GtkButton   *, gpointer  );
void on_ok4_button_fssaveb_clicked      (GtkButton   *, gpointer  );
void on_ok5_button_fssaveb_clicked      (GtkButton   *, gpointer  );
void on_ok6_button_fssaveb_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fssaveb_clicked      (GtkButton   *, gpointer  );
void on_destroy_fssaveb ( GtkWidget  *, gpointer );
GtkWidget* create_fileselection_saveb(void);

void on_ok1_button_fssavepi_clicked      (GtkButton   *, gpointer  );
void on_ok2_button_fssavepi_clicked      (GtkButton   *, gpointer  );
void on_ok3_button_fssavepi_clicked      (GtkButton   *, gpointer  );
void on_ok4_button_fssavepi_clicked      (GtkButton   *, gpointer  );
void on_ok5_button_fssavepi_clicked      (GtkButton   *, gpointer  );
void on_ok6_button_fssavepi_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fssavepi_clicked      (GtkButton   *, gpointer  );
void on_destroy_fssavepi ( GtkWidget  *, gpointer );
GtkWidget* create_fileselection_pi(void);

void on_ok1_button_fsreada_clicked      (GtkButton   *, gpointer  );
void on_ok2_button_fsreada_clicked      (GtkButton   *, gpointer  );
void on_ok3_button_fsreada_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fsreada_clicked      (GtkButton   *, gpointer  );
void on_destroy_fsreada ( GtkWidget  *, gpointer );
GtkWidget* create_fileselection_reada(void);

void on_ok1_button_fsreadb_clicked      (GtkButton   *, gpointer  );
void on_ok2_button_fsreadb_clicked      (GtkButton   *, gpointer  );
void on_ok3_button_fsreadb_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fsreadb_clicked      (GtkButton   *, gpointer  );
void on_destroy_fsreadb ( GtkWidget  *, gpointer );
GtkWidget* create_fileselection_readb(void);

void on_ok_button_fsX_clicked      (GtkButton   *, gpointer  );
void on_cancel_button_fsX_clicked      (GtkButton   *, gpointer  );
void on_destroy_fsX ( GtkWidget  *, gpointer );
GtkWidget* create_fileselection_X(void);



GtkWidget* create_fileselection1 (void);
GtkWidget* create_dialog_nowritable(GtkWidget*);
GtkWidget* create_dialog_noreadable(GtkWidget*);
GtkWidget* create_dialog_data_noreadable(GtkWidget* ,char * );
GtkWidget* create_dialog_nonewdir(GtkWidget*);
GtkWidget* create_dialog_noolddir(GtkWidget*);
GtkWidget* create_dialog_overwrite(GtkWidget*);
GtkWidget* create_dialog_sparse(GtkWidget*);
GtkWidget* create_dialog_rectangular(GtkWidget*);
GtkWidget* create_dialog_gsw(GtkWidget* , char *);

void on_overwrite_ok_activate(GtkButton * , gpointer );
void on_overwrite_cancel_activate(GtkButton * , gpointer );

void pathstripper(char *, char *);
int watch_for_number(int , int , char *);

struct sparse_four { /* A(ii,jj,kk)=ff */
int ii;
int jj;
int kk;
double ff;
};

int sparse_detect(int,int *,char *, struct sparse_four *, struct sparse_four * );

/* prototypes padwrite.c */
gint selection_uptodaten(void);

/* prototypes callback.c */
void invalidate_completed(void);
gboolean on_delete_event_do   (GtkWidget *, GdkEvent *, gpointer);

/* prototypes ponte.f90 */
/* note: Fortran exports names in lower case only, so read_matA becomes read_mata_  ... */
/* matrice A(k,i,j) */
void alloc_mata_(int *,int *, int *);
void read_mata_(int *,int *,int *, double *);
void write_mata_(int *,int *,int *, double *);
void dump_mata_(void);
/* matrice B(k,i,j) */
void alloc_matb_(int *,int *, int *, int *);
void read_matb_(int *,int *,int *, double *);
void write_matb_(int *,int *,int *, double *);
void dump_matb_(void);
void alloc_matb0_(int *,int *);
void read_matb0_(int *,int *, double *);
void write_matb0_(int *,int *, double *);
void dump_matb0_(void);
void alloc_matbn1_(int *,int *, int *);
void read_matbn1_(int *,int *, double *);
void write_matbn1_(int *,int *, double *);
void dump_matbn1_(void);

/* matrice G(i,j) */
void alloc_matg_(int *, int *);
void read_matg_(int *,int *, double *);
void write_matg_(int *,int *, double *);
void dump_matg_(void);
/* matrice U(i,j) */
void alloc_matu_(int *, int *);
void read_matu_(int *,int *, double *);
void write_matu_(int *,int *, double *);
void dump_matu_(void);
/* matrice R(i,j) */
void alloc_matr_(int *, int *);
void read_matr_(int *,int *, double *);
void write_matr_(int *,int *, double *);
void dump_matr_(void);
/* matrice Pi(i,j) */
void alloc_matpi0_(int *);
void read_matpi0_(int *, double *);
void write_matpi0_(int *, double *);
void dump_matpi0_(void);
void alloc_matpi_(int *, int *);
void read_matpi_(int *,int *, double *);
void write_matpi_(int *,int *, double *);
void dump_matpi_(void);
/* matrice X0(i,j) */
void alloc_matx0_(int *, int *);
void read_matx0_(int *,int *, double *);
void write_matx0_(int *,int *, double *);
void dump_matx0_(void);


/* globals callback.c */
int selected_a_problem; /* 1=QBD 2=M/G/1 3=GI/M/1, used for passinf info from Main Menu Callbacks to Read A Window */
struct algorithms_str algorithms_choice;

/* globals rw.c */
GtkWidget *reada_fs;          /* File Selection Dialog for reading A      */
GtkWidget *readb_fs;          /* File Selection Dialog for reading B      */
GtkWidget *savea_fs;          /* File Selection Dialog for saving A       */
GtkWidget *saveb_fs;          /* File Selection Dialog for saving B       */
GtkWidget *saveg_fs;          /* File Selection Dialog for saving G       */
GtkWidget *saver_fs;          /* File Selection Dialog for saving R       */
GtkWidget *saveu_fs;          /* File Selection Dialog for saving U       */
GtkWidget *savegru_fs;        /* File Selection Dialog for saving G+R+U   */
GtkWidget *savepi_fs;         /* File Selection Dialog for saving Pi      */
GtkWidget *appendsave;        /* File Selection Dialog for saving Notepad  Main Window */
GtkWidget *overwrite_dialog;  /* Dialog asking confirm to overwrite */
GtkWidget *confirm_sparse_dialog;  /* Dialog asking confirm if A not sparse */
GtkWidget *readX_fs;          /* File Selection Dialog for reading A      */

int is_savea_open;      /* 0 = not open 1 = open */
int is_saveb_open;      /* 0 = not open 1 = open */
int is_reada_open;      /* 0 = not open 1 = open */
int is_readb_open;      /* 0 = not open 1 = open */
int is_saveg_open;      /* 0 = not open 1 = open */
int is_saver_open;      /* 0 = not open 1 = open */
int is_saveu_open;      /* 0 = not open 1 = open */
int is_savegru_open;    /* 0 = not open 1 = open */
int is_savepi_open;     /* 0 = not open 1 = open */

char pathgru_fs[512];    /* save name of last visited path */

/* globals interface.c */
GtkWidget *statusb;
GtkWidget *textview;

int is_debug;    /* 1= debugging output active on console 0=normal */
int is_savepad_open; /* 0 = not open 1 = open */
char digits_to_save[64]; /* string corresponding to the number format chosen to write in files */
int is_readX_open; /* 0=not open  1=open */

struct running_problem_str committed, selected, completed; /* we save data here after successfully allocate the matrices with the data in committed */

/* globals edit_a.c */
struct edita_str pea; /* preferences edit a */
