/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 2.1 - June  2009                                   *
 **************************************************************
 *
 *  view_pi.c - view Pi quich hack  - both callbacks and interfaces
 *
 */

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <pthread.h>
#include <libgen.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <ctype.h> /* character functions */
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "structures.h"
#include "view_pi.h"
/*
#define  HPL 1000    drawing area side 
#define  VPL 200    drawing area space 
*/
/* View  Window  **** Interface */
void
create_view_pi_window(void)
{
GtkWidget *vboxm_view_pi;
GtkWidget *toolbar_view_pi;
GtkWidget *hboxm;
GtkWidget *tmp_toolbar_icon;
GtkWidget *button_quit_view_pi;
GtkWidget *button_rescale_view_pi;
GtkWidget *button_log_view_pi;
double * pi_data;
double pi_max,pi_min,pi_sum;
int i,j,k;
double r;
struct  viewpi_str *data;
GtkWidget *vbox_s1, *vbox_s2, *vbox_s3, *vbox_s4,*vbox_s5,*vbox_s6;
GtkWidget *labelu_s1, *labelu_s2, *labelu_s3, *labelu_s4,*labelu_s5,*labelu_s6;
GtkWidget *label_ss1, *label_ss2, *label_ss3, *label_ss4,*label_ss5,*label_ss6; 
char tmp[256],tmp1[256],tmp2[256],tmp3[256];
int is_nan; /* 1=not a number discovered 0=0k */
if(is_smallscr==0) { 
		HPL=1000;
		VPL=200;
		} else {
		HPL=700;
                VPL=200;
		}

is_nan=0;
data=calloc(1,sizeof(struct viewpi_str));
if(data==NULL) {create_dialog_nogo2( window_main); return;};
if(is_debug==1) printf("create_view_pi_window: data structure allocated data=%ld\n",(long int)data);
/* window view pi */
data->window_view_pi=gtk_window_new (GTK_WINDOW_TOPLEVEL);
if (data->window_view_pi==NULL) {create_dialog_nogo2( window_main); return;};
gtk_window_set_title (GTK_WINDOW (data->window_view_pi), "View Pi");
if(is_smallscr==0) gtk_window_set_default_size (GTK_WINDOW (data->window_view_pi), 800,250 );
	else gtk_window_set_default_size (GTK_WINDOW (data->window_view_pi), 600,250 );
gtk_window_set_resizable (GTK_WINDOW (data->window_view_pi),FALSE);
gdk_rgb_init();

if(is_debug==1) printf("create_view_pi_window: window allocated\n");
/* a vbox with draving area, command area and statusbox */
vboxm_view_pi=gtk_vbox_new(FALSE,5);
gtk_widget_show(vboxm_view_pi);
gtk_container_add (GTK_CONTAINER (data->window_view_pi), vboxm_view_pi);

/* preparing drawing area */
gtk_widget_push_visual(gdk_rgb_get_visual());
gtk_widget_push_colormap(gdk_rgb_get_cmap());
data->view_pi_area =  gtk_drawing_area_new();
if (data->view_pi_area==NULL){create_dialog_nogo2( window_main); return;};
if(is_debug==1) printf("create_view_pi_window: view_pi_area allocated\n");
gtk_widget_pop_visual();
gtk_widget_pop_colormap();
gtk_widget_show(data->view_pi_area);
gtk_drawing_area_size  (GTK_DRAWING_AREA(data->view_pi_area),HPL,VPL);
gtk_box_pack_start (GTK_BOX (vboxm_view_pi), data->view_pi_area, FALSE, FALSE, 0);


/**************** statusbar  begins  (at the bottom)      */
data->statusb_view_pi = gtk_statusbar_new();
gtk_widget_show (data->statusb_view_pi);
gtk_box_pack_end (GTK_BOX (vboxm_view_pi), data->statusb_view_pi, FALSE, FALSE, 0);
/**************** statusbar ends           */
hboxm=gtk_hbox_new (FALSE, 5);
gtk_container_add (GTK_CONTAINER ( vboxm_view_pi ),hboxm);

/* toolbar begins */
toolbar_view_pi = gtk_toolbar_new ();
gtk_widget_show (toolbar_view_pi);
gtk_box_pack_start (GTK_BOX (hboxm), toolbar_view_pi, FALSE, FALSE, 0);
gtk_container_set_border_width (GTK_CONTAINER (toolbar_view_pi), 10);
gtk_toolbar_set_style (GTK_TOOLBAR (toolbar_view_pi), GTK_TOOLBAR_BOTH);
/* cancel button  first position */
tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-quit", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar_view_pi)));
button_quit_view_pi = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar_view_pi),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Close",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
gtk_widget_show(button_quit_view_pi);
button_rescale_view_pi = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar_view_pi),
                                GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                NULL,
                                "Maximize\n\n(Minimize)",
                                NULL, NULL,
                                NULL, NULL, NULL);
button_log_view_pi = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar_view_pi),
                                GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                NULL,
                                "Y Log\n\n(Linear)",
                                NULL, NULL,
                                NULL, NULL, NULL);

vbox_s1 = gtk_vbox_new (TRUE, 0);
vbox_s2 = gtk_vbox_new (TRUE, 0);
vbox_s3 = gtk_vbox_new (TRUE, 0);
vbox_s4 = gtk_vbox_new (TRUE, 0);
vbox_s5 = gtk_vbox_new (TRUE, 0);
vbox_s6 = gtk_vbox_new (TRUE, 0);
gtk_container_add (GTK_CONTAINER ( hboxm ),vbox_s1);
gtk_container_add (GTK_CONTAINER ( hboxm ),vbox_s2);
gtk_container_add (GTK_CONTAINER ( hboxm ),vbox_s3);
gtk_container_add (GTK_CONTAINER ( hboxm ),vbox_s4);
gtk_container_add (GTK_CONTAINER ( hboxm ),vbox_s5);
gtk_container_add (GTK_CONTAINER ( hboxm ),vbox_s6);
labelu_s1= gtk_label_new("PROBLEM");
labelu_s2= gtk_label_new("DATA");
labelu_s3= gtk_label_new("ALGORITHM");
labelu_s4= gtk_label_new("A"); 
labelu_s5= gtk_label_new("B");
labelu_s6= gtk_label_new("PI");
gtk_container_add (GTK_CONTAINER ( vbox_s1 ),labelu_s1);
gtk_container_add (GTK_CONTAINER ( vbox_s2 ),labelu_s2);
gtk_container_add (GTK_CONTAINER ( vbox_s3 ),labelu_s3);
gtk_container_add (GTK_CONTAINER ( vbox_s4 ),labelu_s4);
gtk_container_add (GTK_CONTAINER ( vbox_s5 ),labelu_s5);
gtk_container_add (GTK_CONTAINER ( vbox_s6 ),labelu_s6);
label_ss1= gtk_label_new(NULL);
label_ss2= gtk_label_new(NULL);
label_ss3= gtk_label_new(NULL);
label_ss4= gtk_label_new(NULL);
label_ss5= gtk_label_new(NULL);
label_ss6= gtk_label_new(NULL);
gtk_container_add (GTK_CONTAINER ( vbox_s1 ),label_ss1);
gtk_container_add (GTK_CONTAINER ( vbox_s2 ),label_ss2);
gtk_container_add (GTK_CONTAINER ( vbox_s3 ),label_ss3);
gtk_container_add (GTK_CONTAINER ( vbox_s4 ),label_ss4);
gtk_container_add (GTK_CONTAINER ( vbox_s5 ),label_ss5);
gtk_container_add (GTK_CONTAINER ( vbox_s6 ),label_ss6);
  
gtk_widget_show_all (hboxm);

switch (completed.type){
        case 1: gtk_label_set_text (GTK_LABEL(label_ss1),"QBD"); k=1; break;
        case 2: gtk_label_set_text (GTK_LABEL(label_ss1),"M/G/1"); k=2; break;
        case 3: gtk_label_set_text (GTK_LABEL(label_ss1),"GI/M/1"); k=3; break;
        default:gtk_label_set_text (GTK_LABEL(label_ss1),"Unknown");
        }
if (completed.example !=0) {sprintf(tmp,"Example %d",completed.example);gtk_label_set_text (GTK_LABEL(label_ss2),tmp); }
        else {sprintf(tmp,"Read from File"); gtk_label_set_text (GTK_LABEL(label_ss2),tmp); }

switch ((completed.alg).type){
        case 1: if( ((completed.alg).cr_base==1)&&((completed.alg).shift==0)) gtk_label_set_text (GTK_LABEL(label_ss3),"Cyclic Reduction\n(basic)");
		if( ((completed.alg).cr_base==1)&&((completed.alg).shift==1)) gtk_label_set_text (GTK_LABEL(label_ss3),"Cyclic Reduction\n(shift)");
		if( ((completed.alg).cr_base==1)&&((completed.alg).shift==2)) gtk_label_set_text (GTK_LABEL(label_ss3),"Cyclic Reduction\n(taushift)");
		if( ((completed.alg).cr_base==1)&&((completed.alg).shift==3)) gtk_label_set_text (GTK_LABEL(label_ss3),"Cyclic Reduction\n(doubleshift)");
                if( (completed.alg).cr_diag==1) gtk_label_set_text (GTK_LABEL(label_ss3),"Cyclic Reduction\n(diag.adj.)");
                break;
        case 2: if( ((completed.alg).lr_base==1)&&((completed.alg).shift==0)) gtk_label_set_text (GTK_LABEL(label_ss3),"Logarithmic Reduction\n(basic)");
		if( ((completed.alg).lr_base==1)&&((completed.alg).shift==1)) gtk_label_set_text (GTK_LABEL(label_ss3),"Logarithmic Reduction\n(shift)");
		if( ((completed.alg).lr_base==1)&&((completed.alg).shift==2)) gtk_label_set_text (GTK_LABEL(label_ss3),"Logarithmic Reduction\n(taushift)");
		if( ((completed.alg).lr_base==1)&&((completed.alg).shift==3)) gtk_label_set_text (GTK_LABEL(label_ss3),"Logarithmic Reduction\n(doubleshift)");
                if( (completed.alg).lr_gth==1) gtk_label_set_text (GTK_LABEL(label_ss3),"Logarithmic Reduction\n(diag.adj.)");
                break;
        case 3: if((completed.alg).fi_traditional==1)sprintf(tmp1,"Traditional");
		if((completed.alg).fi_Ubased==1)sprintf(tmp1,"U-based");
		if((completed.alg).fi_natural==1)sprintf(tmp1,"Natural");
		if((completed.alg).shift==0)sprintf(tmp2,",");
                if((completed.alg).shift==1)sprintf(tmp2,",Simple Shift,");
                if((completed.alg).shift==2)sprintf(tmp2,",Tau Shift,");
                if((completed.alg).shift==3)sprintf(tmp2,",Double Shift,");
                if((completed.alg).fz_0==1)sprintf(tmp3,"x(0)=0");
                if((completed.alg).fz_1==1)sprintf(tmp3,"x(0)=I");
                if((completed.alg).fz_u==1)sprintf(tmp3,"user x(0)");
		 sprintf(tmp,"Functional Iteration\n(%s%s\n%s)",tmp1,tmp2,tmp3);
		 gtk_label_set_text (GTK_LABEL(label_ss3),tmp);

                break;
        case 4: if( (completed.alg).is_base==1) gtk_label_set_text (GTK_LABEL(label_ss3),"Invariant Subspace\n(basic)");
                if( (completed.alg).is_balzer==1) gtk_label_set_text (GTK_LABEL(label_ss3),"Invariant Subspace\n(Balzer)");
                if( (completed.alg).is_schur==1) gtk_label_set_text (GTK_LABEL(label_ss3),"Invariant Subspace\n(Schur)");
                break;
	case 5:if((completed.alg).shift==0)sprintf(tmp2,",");
                if((completed.alg).shift==1)sprintf(tmp2,",Simple Shift,");
                if((completed.alg).shift==2)sprintf(tmp2,",Tau Shift,");
                if((completed.alg).shift==3)sprintf(tmp2,",Double Shift,");
                if((completed.alg).fz_0==1)sprintf(tmp3,"x(0)=0");
                if((completed.alg).fz_1==1)sprintf(tmp3,"x(0)=I");
                if((completed.alg).fz_u==1)sprintf(tmp3,"user x(0)");
                 sprintf(tmp,"Newton Iteration\n(%s\n%s)",tmp2,tmp3);
                 gtk_label_set_text (GTK_LABEL(label_ss3),tmp);
		break;
        default: gtk_label_set_text (GTK_LABEL(label_ss3),"Unknown");
        }

sprintf(tmp,"%d blocks\n(size %d)",completed.matrix_a_num,completed.dimension_m);
gtk_label_set_text (GTK_LABEL(label_ss4),tmp);
sprintf(tmp,"%d blocks\n(size %d)",completed.matrix_b_num,completed.dimension_n);
gtk_label_set_text (GTK_LABEL(label_ss5),tmp);

if(is_debug==1) printf("create_view_pi_window: beginning plot allocations\n");

/* allocate the drawing buffer */
data->rgb_view_pivalue=calloc(3*(HPL)*VPL,sizeof(guchar));
if(data->rgb_view_pivalue==NULL) {create_dialog_nogo2( window_main); return;};
if(is_debug==1)printf("create_view_pi_window: allocated data->rgb_view_pivalue=%ld\n",(long int)data->rgb_view_pivalue);
/* allocate pi data vector */
data->pi_num =completed.dimension_n+completed.maxnc*completed.dimension_m;
pi_data=calloc(data->pi_num,sizeof(double));
if(pi_data==NULL) {create_dialog_nogo2( window_main); return;};
data->pi_s_data=calloc(data->pi_num,sizeof(double));
if(data->pi_s_data==NULL) {create_dialog_nogo2( window_main); return;};
if(is_debug==1) printf("create_view_pi_window: allocated pi_data, pi_s_data\n");
k=0; /* count data */
/* Pi0 is a vector of  completed.dimension_n  */
for(i=1;i<=completed.dimension_n;i++) {
         read_matpi0_(&i,&r);
          pi_data[k]=r; k++; if(isnan(r)!=0) is_nan=1;
           }
/* Pi  consists of completed.maxnc  vectors of  completed.dimension_m  */
for(j=1;j<=completed.maxnc;j++){
        for(i=1;i<=completed.dimension_m;i++) {
                        read_matpi_(&i,&j,&r);
                        pi_data[k]=r ; k++; if(isnan(r)!=0) is_nan=1;
                        }
                }
/* compute pi_max and pi_sum */
pi_max=pi_data[0];
pi_min=pi_data[0];
pi_sum=pi_data[0];
data->pi_s_data[0]=pi_data[0];
for (i=1;i<data->pi_num;i++) {
        pi_sum=pi_sum+pi_data[i];
	data->pi_s_data[i]=data->pi_s_data[i-1]+pi_data[i];	
	if (pi_max < pi_data[i]) pi_max=pi_data[i];
        if (pi_min > pi_data[i]) pi_min=pi_data[i];
	}
data->pi_max=pi_max;
data->is_maximized =0; 
data->is_log=0;
if (is_debug==1) printf("create_view_pi_window: pi_num=%d, pi_min=%g, pi_max=%g, pi_sum=%g\n",data->pi_num, pi_min, pi_max, pi_sum);

sprintf(tmp," %d\nsum=%g ",data->pi_num,pi_sum);
gtk_label_set_text (GTK_LABEL(label_ss6),tmp);


/* if pi_min negative or pi_sum > 1 error message to do !!! */
if ((pi_min <-1.0E-12)||(pi_max > 1)||(is_nan==1)) {create_dialog_nogo1( window_main); return;}

free(pi_data);
pi_image_compute(data);

/* g_signal_connect ((gpointer) data->window_view_pi, "window_state_event", G_CALLBACK (on_view_pi_state_print),(gpointer)data); */
/* g_signal_connect ((gpointer) data->window_view_pi, "delete_event", G_CALLBACK (on_view_pi_delete_activate),(gpointer)data); */
g_signal_connect ((gpointer) data->window_view_pi, "destroy", G_CALLBACK (on_view_pi_destroy_activate),(gpointer)data);
g_signal_connect ((gpointer) button_quit_view_pi, "clicked", G_CALLBACK(on_view_pi_menu_quit_activate),(gpointer)data);
g_signal_connect ((gpointer) button_rescale_view_pi, "clicked", G_CALLBACK(on_view_pi_menu_rescale_activate),(gpointer)data);
g_signal_connect ((gpointer) button_log_view_pi, "clicked", G_CALLBACK(on_view_pi_menu_log_activate),(gpointer)data);
g_signal_connect (G_OBJECT (data->view_pi_area), "expose_event",  G_CALLBACK (draw_view_pi_area), (gpointer)data);

gtk_widget_show(data->window_view_pi);

}
/*********************************/

/* View  Pi Window: Quit  **** Callback */
void
on_view_pi_menu_quit_activate   (GtkMenuItem  *menuitem, gpointer  data)
{
if(is_debug==1) printf("on_view_pi_menu_quit_activate: quit data=%ld\n",(long int)data);
gtk_widget_destroy(GTK_WIDGET(((struct viewpi_str *)data)->window_view_pi));
/* this will generate a destroy event */
if(is_debug==1) printf("on_view_pi_menu_quit_activate: exiting \n");
}
/*********************************/

/* View  Pi Window: destroy  **** Callback */
void
on_view_pi_destroy_activate   (GtkWidget  *ww, gpointer data)
{
/* www is the calling window */
if(is_debug==1) printf("on_view_pi_destroy_activate: quit data=%ld\n",(long int)data);
gtk_widget_destroy(GTK_WIDGET(ww));
/* free space of the graphic buffers and structure data itself */
free(((struct viewpi_str *)data)->rgb_view_pivalue);
free(((struct viewpi_str *)data)->pi_s_data);
free((struct viewpi_str *)data);
if(is_debug==1) printf("on_view_pi_destroy_activate: exiting \n");
}
/*********************************/

/* View  Pi Window: delete_event  **** Callback ** for debug only */
gboolean
on_view_pi_delete_activate   (GtkWidget  *ww, GdkEvent *event, gpointer data)
{
/* www is the calling window */
if(is_debug==1) printf("on_view_pi_delete_activate: quit data=%ld\n",(long int)data);
if(is_debug==1) printf("on_view_pi_delete_activate: exiting \n");
return(FALSE);
}
/*********************************/

/* print state of the window  - not used - made some tests */
gboolean 
on_view_pi_state_print (GtkWidget  *ww, GdkEvent  *event ,gpointer data)
{

if(is_debug==1) printf("on_view_pi_state_print: data=%ld event=%ld type=%d \n",(long int)data,(long int)event,event->type);
/* GDK_WINDOW_STATE =32 */
if((is_debug==1)&&(event->type==GDK_WINDOW_STATE)) { /* print the window state */
	printf("on_view_pi_state_print: GDK_WINDOW_STATE =%d \n",(event->window_state.changed_mask));	

	}
/*
if (event->window_state.send_event==FALSE) {
		gtk_window_iconify (GTK_WINDOW(ww)); 
		return(FALSE);
	} else  {
		gtk_window_deiconify (GTK_WINDOW(ww));
		return(TRUE);
		}
*/
return(TRUE);
}
/*********************************/



/* View  Pi Window: Rescale  **** Callback */
void
on_view_pi_menu_rescale_activate   (GtkMenuItem  *menuitem, gpointer  data)
{
int i;
gboolean return_val;
return_val = FALSE;

if(is_debug==1) printf("on_view_pi_menu_rescale_activate: pi_max=%g\n",((struct viewpi_str *)data)->pi_max);
if(((struct viewpi_str *)data)->is_maximized==0) {
((struct viewpi_str *)data)->is_maximized=1;
for (i=0;i<((struct viewpi_str *)data)->pi_num;i++) ((struct viewpi_str *)data)->pi_s_data[i]=((struct viewpi_str *)data)->pi_s_data[i]/((struct viewpi_str *)data)->pi_max;
} else {
((struct viewpi_str *)data)->is_maximized=0;
for (i=0;i<((struct viewpi_str *)data)->pi_num;i++) ((struct viewpi_str *)data)->pi_s_data[i]=((struct viewpi_str *)data)->pi_s_data[i]*((struct viewpi_str *)data)->pi_max;
}
pi_image_compute(data);
gtk_signal_emit_by_name (GTK_OBJECT (((struct viewpi_str *)data)->view_pi_area),"expose_event",(gpointer)data,&return_val);
if(is_debug==1) printf("on_view_pi_menu_rescale_activate: out\n");
}
/*********************************/

/* View  Pi Window: Rescale  **** Callback */
void
on_view_pi_menu_log_activate   (GtkMenuItem  *menuitem, gpointer  data)
{
gboolean return_val;
return_val = FALSE;

if(is_debug==1) printf("on_view_pi_menu_log_activate: in   is_log=%d\n",((struct viewpi_str *)data)->is_log);
/* toggle value */
if(((struct viewpi_str *)data)->is_log==0) {
((struct viewpi_str *)data)->is_log=1;
} else {
((struct viewpi_str *)data)->is_log=0;
}
pi_image_compute(data);
gtk_signal_emit_by_name (GTK_OBJECT (((struct viewpi_str *)data)->view_pi_area),"expose_event",(gpointer)data,&return_val);

if(is_debug==1) printf("on_view_pi_menu_log_activate: out  is_log=%d\n",((struct viewpi_str *)data)->is_log);
}
/*********************************/


/* calculating pi image   */
void
pi_image_compute(struct viewpi_str * data)
{
int i,j,k,km1,h;
double index,value,oldvalue;
if(is_debug==1) printf("pi_image_compute: begins\n");
/* background */
for(i=0;i<VPL;i++) for(j=0;j<HPL;j++) {
   data->rgb_view_pivalue[3*(i*(HPL)+j)+1]=  (char)(35);
   data->rgb_view_pivalue[3*(i*(HPL)+j)+2]=  (char)(0);
   data->rgb_view_pivalue[3*(i*(HPL)+j)+3]=  (char)(0);
  }
if(is_debug==1) printf("pi_image_compute: background done\n");
/* axis */
for (k=0;k<=4;k++) for(j=0;j<HPL;j++) {
  i=VPL*k/4;
  if(i>=VPL) i=VPL-1;
  data->rgb_view_pivalue[3*(i*(HPL)+j)+1]=  (char)(85);
  data->rgb_view_pivalue[3*(i*(HPL)+j)+2]=  (char)(0);
  data->rgb_view_pivalue[3*(i*(HPL)+j)+3]=  (char)(0);
  }
for (k=0;k<=10;k++) for(i=0;i<VPL;i++) {
  j=HPL*k/10;
  if(j>=HPL)j=HPL-1;
  data->rgb_view_pivalue[3*(i*(HPL)+j)+1]=  (char)(85);
  data->rgb_view_pivalue[3*(i*(HPL)+j)+1]=  (char)(0);
  data->rgb_view_pivalue[3*(i*(HPL)+j)+1]=  (char)(0);
  }
if(is_debug==1) printf("pi_image_compute: axis done\n");
/* pi  values are the differences between pi integrals ... */
if(is_debug==1) printf("pi_image_compute: beginning plot of data\n");
km1=0;
oldvalue=data->pi_s_data[0];
for(j=1;j<HPL;j++) {
	index=j;
        index=(index*data->pi_num)/HPL;
	k=index;
	value = data->pi_s_data[k]-data->pi_s_data[km1];
	if (value <=0)  value=oldvalue; else {km1=k; oldvalue=value;}
if(((struct viewpi_str *)data)->is_log==1) {
/* log scale or linear scale ln(10^12)=27.6  ln(10^16)=36.8 */
	value=log(value)+ 27.0;
	if (value <0) value=0;
	value=value/27;
/* end log scale */ }
	value=value*VPL;
	h=VPL-value-1; 
        /* rgb_view_pivalue[3*(h*HPL+j)+1]=  (char)(201); */
        if(h<0)h=0; if(h>=VPL)h=VPL-1;       
        for(i=h;i<VPL;i++) { 
        data->rgb_view_pivalue[3*(i*HPL+j)+1]=  (char)(201);
        data->rgb_view_pivalue[3*(i*HPL+j)+2]=  (char)(101);
        data->rgb_view_pivalue[3*(i*HPL+j)+3]=  (char)(201);
        }
		
   }
if(is_debug==1) printf("pi_image_compute: end  plot of data\n");
}
/*********************************/

/* draw view_area uses rgb_view_pivalue to redraw into view_area drawable  */
void
draw_view_pi_area(GtkWidget *area, GdkEventExpose *event, gpointer data)
{
if(is_debug==1) printf("draw_view_pi_area: begins\n");
                gdk_draw_rgb_image(area->window,
                area->style->fg_gc[GTK_WIDGET_STATE (area)],
                0, 0, HPL,VPL,GDK_RGB_DITHER_NORMAL,((struct viewpi_str *)data)->rgb_view_pivalue,3*(HPL));
if(is_debug==1) printf("draw_view_pi_area: ends\n");
}
/*********************************/

/* Not possible to go on ***** Interface */
GtkWidget*
create_dialog_nogo1(GtkWidget* my_window)
{
GtkWidget *nogo_dialog;
GtkWidget  *label;
GtkWidget  *icon;
nogo_dialog = gtk_dialog_new_with_buttons ("Failure",
                                         NULL,
                                         GTK_DIALOG_MODAL,
                                         GTK_STOCK_CANCEL,
                                         GTK_RESPONSE_NONE,
                                         NULL);
label = gtk_label_new ("\n  Pi is not made of numbers in [0,1] ! ");
icon = gtk_image_new_from_stock(GTK_STOCK_DIALOG_ERROR,GTK_ICON_SIZE_DIALOG);
gtk_container_add (GTK_CONTAINER (GTK_DIALOG(nogo_dialog)->vbox), label);
gtk_container_add (GTK_CONTAINER (GTK_DIALOG(nogo_dialog)->vbox), icon);
gtk_window_set_transient_for (GTK_WINDOW (nogo_dialog),GTK_WINDOW (my_window));
gtk_window_set_position (GTK_WINDOW (nogo_dialog), GTK_WIN_POS_CENTER_ON_PARENT);
gtk_button_box_set_layout (GTK_BUTTON_BOX (GTK_DIALOG (nogo_dialog)->action_area), GTK_BUTTONBOX_SPREAD);
gtk_widget_show_all (nogo_dialog);
g_signal_connect_swapped (nogo_dialog, "response", G_CALLBACK (gtk_widget_destroy), nogo_dialog);
return nogo_dialog;
}
/****************************/

/* Not possible to go on ***** Interface */
GtkWidget*
create_dialog_nogo2(GtkWidget* my_window)
{
GtkWidget *nogo_dialog;
GtkWidget  *label;
GtkWidget  *icon;
nogo_dialog = gtk_dialog_new_with_buttons ("Failure",
                                         NULL,
                                         GTK_DIALOG_MODAL,
                                         GTK_STOCK_CANCEL,
                                         GTK_RESPONSE_NONE,
                                         NULL);
label = gtk_label_new ("\n  Memory Allocation did Fail ");
icon = gtk_image_new_from_stock(GTK_STOCK_DIALOG_ERROR,GTK_ICON_SIZE_DIALOG);
gtk_container_add (GTK_CONTAINER (GTK_DIALOG(nogo_dialog)->vbox), label);
gtk_container_add (GTK_CONTAINER (GTK_DIALOG(nogo_dialog)->vbox), icon);
gtk_window_set_transient_for (GTK_WINDOW (nogo_dialog),GTK_WINDOW (my_window));
gtk_window_set_position (GTK_WINDOW (nogo_dialog), GTK_WIN_POS_CENTER_ON_PARENT);
gtk_button_box_set_layout (GTK_BUTTON_BOX (GTK_DIALOG (nogo_dialog)->action_area), GTK_BUTTONBOX_SPREAD);
gtk_widget_show_all (nogo_dialog);
g_signal_connect_swapped (nogo_dialog, "response", G_CALLBACK (gtk_widget_destroy), nogo_dialog);
return nogo_dialog;
}
/****************************/

