/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 2.1 - June  2009                                   *
 **************************************************************
 *
 *  structures.h
 *
 */

struct main_menuitem_alg{

};

struct algorithms_str { 
int type; /* 1= Cyclic Reduction  2= Logarithmic reduction  3= Functional Iteration 4=Invariant Subspace 5=Newton */
int shift; /* 0=no shift  1=simple shift  2=tau shift  3= double shift */
int dual;  /* 0=auto dual 1=Ramaswami dual  2=Bright dual 3=Both duals 4=No Dual*/
int cr_base;  /* 1= set 0=unset */
int cr_diag;
int lr_base;
int lr_gth;
int fi_natural;
int fi_traditional;
int fi_Ubased;
int is_base;
int is_balzer;
int is_schur;
int fz_0; /* for Functional Iteration and Newton */
int fz_1;
int fz_u;
};

struct goals_str{
int qbd_g;
int qbd_gr;
int qbd_gru;
int qbd_grupi;
int mg1_g;
int mg1_gpi;
int gim1_r;
int gim1_rpi;
};

struct running_problem_str {
int type;         /* 0 invalid data (diasallocated) 1= QBD   2= M/G/1   3=GI/M/1  */
int allocated;   /* 0 not yet allocated input data 1= allocated and filled in either reading or from example */
int g;            /* 0 not yet computed  1= computed */
int u;
int r;
int pi;
int dimension_m; /* A blocks are dimension_m x dimension_m */
int dimension_n; /* B0 is dimension_n x dimension_n ; B blocks are dimension_n x dimension_m for QBD and MG1 problems, dimension_m x dimension_n for GIM1
 */
int maxnc; /*  number of Pi vectors  0 if not computed*/
int epspi; /*  epsilon for Pi */
int matrix_a_num; /* # blocks of A */
int matrix_b_num; /* # blocks of B */
int is_a_sparse; /* 1=a is sparse 0=a not sparse */
int is_b_sparse; /* not used in this version */
int is_bn1;     /* 1= present  bn1 0=not present */
int is_b0;      /* 1= present 0=not present      */
int is_b;      /* 1= present 0=not present       */
double alpha;    /* parameters used in some examples */
double beta;
int example;     /* 0 no example 1..9 examples */
int fz_file_read; /* 0= a file for fi or newton has not been read 1= has been read*/
int fz_file_dim;  /* dimension of the file read - MUST be equal to dimension_m or it is not valid */
struct algorithms_str alg;
};

struct examples_str {
int  num;
int  type;         /* 1= QBD  2= M/G/1   3= GI/M/1  */
char name[32];
char descr1[265];
char descr2[256];
char descr3[256];
char descr4[256];
char descr5[256];
int  is_dim_variable; /* 0=yes 1=no   */
int  is_m_equal_n;  /* 0=yes 1=no  if yes only dimension_m can be assigned */
int dimension_m; /* A blocks are dimension_m x dimension_m */
int dimension_n; /* B0 is dimension_n x dimension_n ; B blocks are dimension_n x dimension_m for QBD and MG1 problems, dimension_m x dimension_n for GIM1 */
int dimension_diff; /* if dimension_n cannot be assigned, it will be dimension_m - dimension_diff if positive, else B will not be used. */
int  is_matrix_variable;
int is_a_equal_m;    /* 0=yes 1=no  if yes only dimension_m can be assigned */
int matrix_a_num;  /* # blocks of A */
int matrix_b_num;  /* # blocks of B */
int is_b;       /* 1= present B 0=not present */
int is_b0;       /* 1= present B0 0=not present */
int is_bn1;     /* 1= present BN1 0=not present */
int is_alpha;    /* 0 not used 1 used   */
double alpha;    /* optional parameter */
int is_beta;     /* 0 not used 1 used   */
double beta;     /* optional parameter */
};

struct parameters_str {
int iterat;       /* max number of allowed iterations */
int interp;       /* lookup of the max number of allowed interpolation points */
int err;          /* lookup of the eps = epsilon(1.0d0) * 10 ** err */
};

struct pi_parameters_str {
int maxnc;
int eps;      /*lookup of the eps = epsilon(1.0d0) * 10 ** err */
};

struct edita_str {
int block;              /* memory of block A or B last dispalyed */
int is_gru;		/* 0=no results of computations 1=g 2=r 3=u  */
int is_positive;        /* 0: white is 0, black is 255; 1: white is 255, black is 0;  */
int is_color;           /* =0 no color =1 color */
int is_user;            /* 0: default 1: user settings */
double contrast_value;  /* setup with spinbutton, initially 0  */ 
int is_range_type;      /* 0=range [0,1], 1= range [asmin,asmax] 2=adaptive */
};

struct viewpi_str {
GtkWidget *window_view_pi;
GtkWidget  *statusb_view_pi;
GtkWidget  *view_pi_area;
guchar *rgb_view_pivalue;
double * pi_s_data;
double pi_max;
int pi_num;
int is_log; /* 0= not log 1=using log */
int is_maximized; /* 0=not maximized 1= maximized */
};
