/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 2.1 - June  2009                                   *
 **************************************************************
 *
 *  main.c
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <gtk/gtk.h>
#include <pthread.h>

#include "structures.h"
#include "main.h"

int
#ifdef LAHEY_MAIN
/* Lahey Fortran requires MAIN__ as main program */
MAIN__ (int argc, char *argv[])
#else
/* g95 or ifort will work with usual main*/
main (int argc, char *argv[])
#endif
{
char c;
int  leggirc;
/* debug and help flags */
is_debug=0;
is_smallscr=0;
leggirc=0; /* default no */
if ((argc > 4) ) { usage(argv[0]); return(-1); };
/* getopt */
while ((c = getopt (argc, argv, "hdvsr")) != -1)
switch (c)
           {
            case 'h': /*help*/
                printf("\nSMCSolver:");
                printf("  STRUCTURED MARKOV CHAINS SOLVER\n"); 
                printf("         Dario Bini, Beatrice Meini, Sergio Steffe\'\n");
	        printf("         Dipartimento di Matematica \"Leonida Tonelli\"\n");
                printf("         Universita\' di Pisa, Pisa     Italy\n\n");
                printf("         bini,meini,steffe @dm.unipi.it\n\n");
		printf("         optional flags:   -v (version)  -d (debug)  -s (small screen) -r (reads .SMCSolverrc) -h (this help)\n\n");
                return(0);
            case 'v': /*version*/
                printf("\nSMCSolver:  Version 2.1   June  2009\n\n");
                return(0);
            case 'd': /*debug*/
                is_debug=1;    /* 1= debugging output active on console 0=normal */
		break; 
	    case 's': /*small screen size*/
		is_smallscr=1;
		break;
	    case 'r': /*read .SMCSolverrc */
		leggirc=1;
		break;
	    case '?': /* invalid option */
		usage(argv[0]);
		return(0);
            default:
		is_debug=0;
		leggirc=0;
	  }
/* first of all: who am I ?  for later use ... */
gethostname(my_host_name, 512);
strncpy(my_prog_name,argv[0],512);
if(is_debug==1) printf("\n%s on %s:  Debugging output active ...\n",my_prog_name,my_host_name);
gtk_set_locale ();  
/* load examples data */
init_examples();
/* load algorithms parameters */
parameters_setup();

/* initialize gtk, gdk, treads */
g_thread_init (NULL);
gdk_threads_init ();
gtk_init( &argc, &argv );
/* printf("%s\n",gtk_set_locale ());*/
if (leggirc==1) gtk_rc_parse(".SMCSolverrc" );
/* open main window  */

window_main = (GtkWidget*) create_window_main();
gtk_window_unmaximize ((GtkWindow*)window_main); /* do not maximize window as default */
gtk_widget_show (window_main);

gdk_threads_enter ();
gtk_main ();
gdk_threads_leave ();
 return 0;
}
/*********************************/

/* prints usage */
static void usage(char *command)
{
        fprintf(stderr,
"Usage: %s  [OPTION]... \n"
"-h            help\n"
"-v            version\n"
"-d            debugging\n"
"-s            small screen setup\n"
"-r            reads .SMCSolverrc\n"
         ,command);
}
/*********************************/
