/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 2.1 - June  2009                                   *
 **************************************************************
 *
 *  interfaces.c  -  main window, examples window interfaces
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <math.h>

#include "structures.h"
#include "interface.h"
#include "icons.h"
#include "examples.h"

/* creates a widget from a pixmap */
GtkWidget*
pixmap_to_widget(GtkWidget *window, char *xpm[])
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkWidget *gtkpixmap;
  GtkStyle  *style;

  gtk_widget_show(window);
  style = gtk_widget_get_style (window);
  pixmap = gdk_pixmap_create_from_xpm_d (window->window,  &mask,
                     &style->bg[GTK_STATE_NORMAL], xpm);
  gtkpixmap = gtk_pixmap_new (pixmap, mask);
  gtk_widget_show (gtkpixmap);
  gdk_pixmap_unref(pixmap);
  gdk_pixmap_unref(mask);
  return (gtkpixmap);
}
/*********************************/

/* Main Window */
GtkWidget*
create_window_main (void)
{
  GtkWidget *window_main;
  GtkWidget *vbox_main;
  GtkWidget *menubar;

  GtkWidget *separator1;
  GtkWidget *separator2;
  GtkWidget *separator3;
/*  GtkWidget *separator4;*/
  GtkWidget *separator5;
  GtkWidget *separator6;
  GtkWidget *separator7;
  GtkWidget *separator8;
  GtkWidget *separator9;
  GtkWidget *separator10;
  GtkWidget *separator11;
  GtkWidget *separator12;
  GtkWidget *separator13;
/*  GtkWidget *separator14; */
  GtkWidget *separator15;
/*  GtkWidget *separator16; */
  GtkWidget *separator17;
  GtkWidget *separator18;
  GtkWidget *separator19;
  GtkWidget *separator20;
  
  GtkWidget *menuitem_file;
  GtkWidget *menu_file;
  GtkWidget *mg1_m;
  GtkWidget *gm1_m;
  GtkWidget *qbd_m;
  GtkWidget *read_b_m;
  GtkWidget *save_a_m; 
  GtkWidget *save_b_m;
  GtkWidget *saveg_m;
  GtkWidget *saver_m;
  GtkWidget *saveu_m;
  GtkWidget *savepi_m;
  GtkWidget *savegru_m;
  GtkWidget *clear_notepad_m;
  GtkWidget *save_notepad_m;
  GtkWidget *quit_m;
  
  GtkWidget *menuitem_examples;
  GtkWidget *menu_examples;
  GtkWidget *es_m[10];
  
  GtkWidget *menuitem_preproc;
  GtkWidget *menu_preproc;
  GtkWidget *shifts_m;
  /* globals GtkWidget *noshift_m; GtkWidget *simpleshift_m; GtkWidget *taushift_m; GtkWidget *doubleshift_m; */
  GtkWidget *duals_m;
  /* globals GtkWidget *autodual_m; GtkWidget *brigthdual_m; GtkWidget *ramadual_m; GtkWidget *bothdual_m;    */
  
  GtkWidget *menuitem_algorithms;
  GtkWidget *menu_algorithms;
  GtkWidget *menuitem_cyclicr; 
  GtkWidget *menuitem_logarithmicr;
  GtkWidget *menuitem_funciter;
  GtkWidget *menuitem_invarsubsp;
  /* global to be unchecked if necessary in callback
  GtkWidget *cyclicr_basic_m;
  GtkWidget *cyclicr_diagadj_m;
  GtkWidget *logarithmicr_basic_m;
  GtkWidget *logarithmicr_gth_m;
  GtkWidget *funciter_natural_m;
  GtkWidget *funciter_traditional_m;
  GtkWidget *funciter_Ubased_m;
  GtkWidget *invarsubsp_basic_m;
  GtkWidget *invarsubsp_balzer_m;
  GtkWidget *invarsubsp_schur_m;
  GtkWidget *menuitem_newton;
  */
  /* GtkWidget *funz_starting_m; global  Newton and Functional Iteration starting points */
  GtkWidget *funz_m;
  GtkWidget *funz_start0_m;
  GtkWidget *funz_start1_m;
  GtkWidget *funz_startu_m;
  GtkWidget *funz_readX_m; 
  GtkWidget *menuitem_goals; 
  GtkWidget *menu_goals;
  /* GtkWidget *menuitem_mg1;  global */
  GtkWidget *menu_mg1; 
  GtkWidget *mg1_g_m;
  GtkWidget *mg1_gpi_m;
  /* GtkWidget *menuitem_gim1; global */ 
  GtkWidget *menu_gim1; 
  GtkWidget *gim1_r_m;
  GtkWidget *gim1_rpi_m;
  /* GtkWidget *menuitem_qbd; global */
  GtkWidget *menu_qbd;  
  GtkWidget *qbd_g_m;
  GtkWidget *qbd_gr_m;
  GtkWidget *qbd_gru_m;
  GtkWidget *qbd_grupi_m;
  GtkWidget *pi_param_m;
  
  GtkWidget *menuitem_options;
  GtkWidget *menu_options;
  GtkWidget *verbose_m;
  GtkWidget *debugging_m;
  GtkWidget *small_m;
  GtkWidget *timings_m;
  GtkWidget *situation_m;
  GtkWidget *menuitem_digits;
  GtkWidget *menu_digits;
  GtkWidget *eigth_d_m;
  GtkWidget *fifteen_d_m;
  GtkWidget *sixteen_d_m;
  GtkWidget *seventeen_d_m;
  GtkWidget *parameters_cr_m;
  GtkWidget *parameters_lr_m;
  GtkWidget *parameters_fi_m;
  GtkWidget *parameters_is_m;
  GtkWidget *parameters_nt_m;
  GtkWidget *parameters_reset_m;

  GtkWidget *menuitem_run;
  GtkWidget *menu_run;
  GtkWidget *run_m;
  GtkWidget *stop_m;
  GtkWidget *edita_m;
  GtkWidget *editb_m;
  GtkWidget *view_matrix_m;
  GtkWidget *view_pi_m;
/*  GtkWidget *pause_m;  */
  
  GtkWidget *menuitem_help;
  GtkWidget *menu_help;
  GtkWidget *about_m;
  GtkWidget *help_m;
  GtkWidget *handlebox_t;
  
  GtkWidget *toolbar;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *button_quit;
  GtkWidget *button_save_notepad;
  GtkWidget *button_clear_notepad;
  GtkWidget *button_run;
  GtkWidget *button_stop;
  GtkWidget *button_edita;
  GtkWidget *button_editb;
  GtkWidget *button_viewgru;
  GtkWidget *button_viewpi;
  GtkWidget *button_help;
  
  GtkWidget *scrolledwindow;
  /* GtkWidget *textview; global */
  /* GtkWidget *statusb; global */
  /* int examples_no;  number of possible examples 1..9 global */
  /* struct  examples_str es[10]; global; */
  /* GtkWidget *handlebox_s; global */
  GtkWidget *hbox_s;
  GtkWidget *vbox_s1, *vbox_s2, *vbox_s3, *vbox_s4, *vbox_s5, *vbox_s6;
  GtkWidget *labelu_s1, *labelu_s2, *labelu_s3, *labelu_s4,*labelu_s5, *labelu_s6;
  /* GtkWidget *label_s1, *label_s2, *label_s3, *label_s4, *label_s5, *label_s6; global */
  
  GtkTooltips *tooltips;
  GtkAccelGroup *accel_group;
  
  GSList *preproc_shifts = NULL;
  GSList *preproc_dual = NULL;
  GSList *algorithms = NULL;
  GSList *funz = NULL;
  GSList *qbd_goals = NULL;
  GSList *gim1_goals = NULL;
  GSList *mg1_goals = NULL;
  GSList *digits = NULL; 
  PangoFontDescription *desc;
  int i;
  /* all this mess to show the small_star near About Menu end stock_edit near View & Edit A */
 GtkWidget *pixmapwid_ss, *pixmapwid_ed, *pixmapwid_big_ed_a, *pixmapwid_big_ed_b, *pixmapwid_big_view, *pixmapwid_big_view_pi, *pixmapwid_view;
 GdkPixmap *pixmap_ss,*pixmap_ed, *pixmap_big_ed;
 GdkBitmap *mask;
 GtkStyle *style;
 GdkColormap *mappacolor;
 /* end  mess                                             */
  tooltips = gtk_tooltips_new ();
  gtk_tooltips_enable(tooltips);
  accel_group = gtk_accel_group_new ();
  
if(is_debug==1) printf("create_window_main: begins\n"); 
  window_main = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window_main), "Structured Markov Chains Solver");
  if(is_smallscr==0) gtk_window_set_default_size (GTK_WINDOW (window_main), 600, 600); 
	else gtk_window_set_default_size (GTK_WINDOW (window_main), 500, 400); 
  gtk_window_add_accel_group (GTK_WINDOW (window_main),accel_group );
/*  gtk_tooltips_set_tip (tooltips, window_main, "Program Main Window", NULL); test tooltips */

  /* vbox_main */
  vbox_main = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox_main);
  gtk_container_add (GTK_CONTAINER (window_main), vbox_main);
  
  /******************** Menus begins here */
  menubar = gtk_menu_bar_new ();
  gtk_widget_show (menubar);
  gtk_box_pack_start (GTK_BOX (vbox_main), menubar, FALSE, FALSE, 0);
 
  /* Menu File */
  menuitem_file = gtk_menu_item_new_with_mnemonic ("_File");
  gtk_widget_show (menuitem_file);
  gtk_container_add (GTK_CONTAINER (menubar), menuitem_file);
  menu_file = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_file), menu_file);
  qbd_m = gtk_menu_item_new_with_label ("Read Input A (QBD Problem)");
  mg1_m = gtk_menu_item_new_with_label ("Read Input A (M/G/1 Problem)");
  gm1_m = gtk_menu_item_new_with_label ("Read Input A (GI/M/1 Problem)");
  gtk_widget_show(qbd_m);
  gtk_widget_show(mg1_m);
  gtk_widget_show(gm1_m);
  gtk_container_add (GTK_CONTAINER (menu_file),qbd_m);
  gtk_container_add (GTK_CONTAINER (menu_file),mg1_m);
  gtk_container_add (GTK_CONTAINER (menu_file),gm1_m);
  
  read_b_m = gtk_menu_item_new_with_label("Read Input B");
  gtk_widget_show(read_b_m);
  gtk_container_add (GTK_CONTAINER (menu_file),read_b_m);

  separator1 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator1);
  gtk_container_add (GTK_CONTAINER (menu_file), separator1);
  save_a_m =gtk_menu_item_new_with_label("Save Used A");
  gtk_widget_show(save_a_m);
  gtk_container_add (GTK_CONTAINER (menu_file), save_a_m);
/*  gtk_widget_set_sensitive (save_a_m,FALSE);*/
  save_b_m =gtk_menu_item_new_with_label("Save Used B");
  gtk_widget_show(save_b_m);
  gtk_container_add (GTK_CONTAINER (menu_file), save_b_m);

  separator2 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator2);
  gtk_container_add (GTK_CONTAINER (menu_file), separator2);
  saveg_m = gtk_menu_item_new_with_label("Save Output G");
  gtk_widget_show( saveg_m );
  gtk_container_add (GTK_CONTAINER (menu_file),saveg_m);
  saver_m = gtk_menu_item_new_with_label("Save Output R");
  gtk_widget_show( saver_m );
  gtk_container_add (GTK_CONTAINER (menu_file),saver_m);
  saveu_m = gtk_menu_item_new_with_label("Save Output U");
  gtk_widget_show( saveu_m );
  gtk_container_add (GTK_CONTAINER (menu_file),saveu_m);
  savegru_m = gtk_menu_item_new_with_label("Save G+R+U");
  gtk_widget_show( savegru_m );
  gtk_container_add (GTK_CONTAINER (menu_file),savegru_m);
  savepi_m = gtk_menu_item_new_with_label("Save Output Pi");
  gtk_widget_show( savepi_m );
  gtk_container_add (GTK_CONTAINER (menu_file),savepi_m);

  separator3 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator3);
  gtk_container_add (GTK_CONTAINER (menu_file), separator3);
  clear_notepad_m = gtk_image_menu_item_new_with_label("Clear NotePad");
  gtk_widget_show(clear_notepad_m);
  gtk_container_add (GTK_CONTAINER (menu_file), clear_notepad_m); 
  save_notepad_m = gtk_image_menu_item_new_with_label("Save NotePad");
  gtk_widget_show(save_notepad_m);
  gtk_container_add (GTK_CONTAINER (menu_file), save_notepad_m);
  
  separator5 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator5);
  gtk_container_add (GTK_CONTAINER (menu_file), separator5);
  quit_m = gtk_image_menu_item_new_from_stock ("gtk-quit", accel_group);
  gtk_widget_show (quit_m);
  gtk_container_add (GTK_CONTAINER (menu_file), quit_m);
if(is_debug==1)printf("create_window_main: end menu files\n"); 
  
  /* Menu  Examples */
  menuitem_examples = gtk_menu_item_new_with_mnemonic ("Examples");
  gtk_widget_show (menuitem_examples);
  gtk_container_add (GTK_CONTAINER (menubar), menuitem_examples);
  menu_examples =  gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM ( menuitem_examples ), menu_examples);

  for(i=1;i<=examples_no;i++) {
  es_m[i] = gtk_menu_item_new_with_label (es[i].name);
  gtk_widget_show(es_m[i]);
  gtk_container_add (GTK_CONTAINER (menu_examples), es_m[i]);
  } 
if(is_debug==1)printf("create_window_main: end menu examples, examples_no=%d\n",examples_no);
  
  /* Menu Preprocessing */
  menuitem_preproc = gtk_menu_item_new_with_mnemonic ("Preprocessing");
  gtk_widget_show (menuitem_preproc);
  gtk_container_add (GTK_CONTAINER (menubar), menuitem_preproc);
  menu_preproc = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_preproc), menu_preproc);
  shifts_m = gtk_menu_item_new_with_mnemonic ("SHIFTS:");
  gtk_container_add (GTK_CONTAINER (menu_preproc), shifts_m);
  gtk_widget_show (shifts_m);
  noshift_m = gtk_radio_menu_item_new_with_label(preproc_shifts,"No Shift");
  preproc_shifts = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (noshift_m));
  gtk_widget_show (noshift_m);
  gtk_container_add (GTK_CONTAINER (menu_preproc),noshift_m);
  simpleshift_m = gtk_radio_menu_item_new_with_label(preproc_shifts,"Simple Shift");
  preproc_shifts = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (simpleshift_m));
  gtk_widget_show (simpleshift_m);
  gtk_container_add (GTK_CONTAINER (menu_preproc),simpleshift_m);
  taushift_m = gtk_radio_menu_item_new_with_label(preproc_shifts,"Tau Shift");
  preproc_shifts = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (taushift_m));
  gtk_widget_show (taushift_m);
  gtk_container_add (GTK_CONTAINER (menu_preproc),taushift_m);
  doubleshift_m = gtk_radio_menu_item_new_with_label(preproc_shifts,"Double Shift");
  preproc_shifts = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (doubleshift_m));
  gtk_widget_show (doubleshift_m);
  gtk_container_add (GTK_CONTAINER (menu_preproc),doubleshift_m);
  separator15 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator15);
  gtk_container_add (GTK_CONTAINER (menu_preproc), separator15);
  duals_m = gtk_menu_item_new_with_mnemonic ("DUALS:");
  gtk_container_add (GTK_CONTAINER (menu_preproc), duals_m);
  gtk_widget_show (duals_m);
  autodual_m = gtk_radio_menu_item_new_with_label(preproc_dual,"Auto Dual");
  preproc_dual = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (autodual_m));
  gtk_widget_show (autodual_m);
  gtk_container_add (GTK_CONTAINER (menu_preproc),autodual_m);
  nodual_m = gtk_radio_menu_item_new_with_label(preproc_dual,"No Dual");
  preproc_dual = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (nodual_m));
  gtk_widget_show (nodual_m);
  gtk_container_add (GTK_CONTAINER (menu_preproc),nodual_m);
  ramadual_m = gtk_radio_menu_item_new_with_label(preproc_dual,"Ramaswami Dual");
  preproc_dual = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (ramadual_m));
  gtk_widget_show (ramadual_m);
  gtk_container_add (GTK_CONTAINER (menu_preproc),ramadual_m);
  brigthdual_m = gtk_radio_menu_item_new_with_label(preproc_dual,"Bright Dual");
  preproc_dual = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (brigthdual_m));
  gtk_widget_show (brigthdual_m);
  gtk_container_add (GTK_CONTAINER (menu_preproc),brigthdual_m);
  bothdual_m = gtk_radio_menu_item_new_with_label(preproc_dual,"Both Duals");
  preproc_dual = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (bothdual_m));
  gtk_widget_show (bothdual_m);
  gtk_container_add (GTK_CONTAINER (menu_preproc),bothdual_m);
if(is_debug==1)printf("create_window_main: end menu preprocessing\n");
 
  /* Menu Algorithms */
  menuitem_algorithms = gtk_menu_item_new_with_mnemonic ("Algorithms");
  gtk_widget_show (menuitem_algorithms);
  gtk_container_add (GTK_CONTAINER (menubar), menuitem_algorithms);
  menu_algorithms = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_algorithms), menu_algorithms);

  menuitem_cyclicr = gtk_menu_item_new_with_label ("CYCLIC REDUCTION:");
  gtk_widget_set_sensitive (menuitem_cyclicr,FALSE);
  gtk_widget_show(menuitem_cyclicr);
  gtk_container_add (GTK_CONTAINER (menu_algorithms), menuitem_cyclicr);
  cyclicr_basic_m = gtk_radio_menu_item_new_with_label(algorithms,"C.R. basic or shifted");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (cyclicr_basic_m));
  gtk_container_add (GTK_CONTAINER (menu_algorithms), cyclicr_basic_m);
  gtk_widget_show (cyclicr_basic_m);
  cyclicr_diagadj_m = gtk_radio_menu_item_new_with_label(algorithms,"C.R. with diagonal adjustment");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (cyclicr_diagadj_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),cyclicr_diagadj_m);
  gtk_widget_show (cyclicr_diagadj_m);
  
  separator17 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator17);
  gtk_container_add (GTK_CONTAINER (menu_algorithms), separator17);
  menuitem_logarithmicr = gtk_menu_item_new_with_label ("LOGARITHMIC REDUCTION:");
  gtk_widget_set_sensitive (menuitem_logarithmicr,FALSE);
  gtk_container_add (GTK_CONTAINER (menu_algorithms), menuitem_logarithmicr);
  gtk_widget_show(menuitem_logarithmicr);  
  logarithmicr_basic_m = gtk_radio_menu_item_new_with_label(algorithms,"L.R. basic or shifted");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (logarithmicr_basic_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),logarithmicr_basic_m);
  gtk_widget_show (logarithmicr_basic_m);
  logarithmicr_gth_m = gtk_radio_menu_item_new_with_label(algorithms,"L.R. with diagonal adjustment");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (logarithmicr_gth_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),logarithmicr_gth_m);
  gtk_widget_show (logarithmicr_gth_m);
  
  separator18 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator18);
  gtk_container_add (GTK_CONTAINER (menu_algorithms), separator18);
  menuitem_invarsubsp = gtk_menu_item_new_with_label ("INVARIANT SUBSPACE:");
  gtk_widget_set_sensitive (menuitem_invarsubsp,FALSE);
  gtk_container_add (GTK_CONTAINER (menu_algorithms), menuitem_invarsubsp);
  gtk_widget_show(menuitem_invarsubsp);
  invarsubsp_basic_m = gtk_radio_menu_item_new_with_label(algorithms,"I.S. basic");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (invarsubsp_basic_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),invarsubsp_basic_m);
  gtk_widget_show (invarsubsp_basic_m);
  invarsubsp_balzer_m = gtk_radio_menu_item_new_with_label(algorithms,"I.S. with Balzer");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (invarsubsp_balzer_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),invarsubsp_balzer_m);
  gtk_widget_show (invarsubsp_balzer_m);
  invarsubsp_schur_m = gtk_radio_menu_item_new_with_label(algorithms,"I.S. with Schur");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (invarsubsp_schur_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),invarsubsp_schur_m);
  gtk_widget_show (invarsubsp_schur_m);

  separator19 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator19);
  gtk_container_add (GTK_CONTAINER (menu_algorithms), separator19);
  menuitem_funciter = gtk_menu_item_new_with_label ("FUNCTIONAL ITERATION:");
   gtk_widget_set_sensitive (menuitem_funciter,FALSE);
  gtk_container_add (GTK_CONTAINER (menu_algorithms), menuitem_funciter);
  gtk_widget_show(menuitem_funciter);
  funciter_natural_m = gtk_radio_menu_item_new_with_label(algorithms,"F.I. natural");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (funciter_natural_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),funciter_natural_m );
  gtk_widget_show (funciter_natural_m );
  funciter_traditional_m = gtk_radio_menu_item_new_with_label(algorithms,"F.I. traditional");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (funciter_traditional_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),funciter_traditional_m );
  gtk_widget_show (funciter_traditional_m );
  funciter_Ubased_m = gtk_radio_menu_item_new_with_label(algorithms,"F.I. U-based");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (funciter_Ubased_m));
  gtk_widget_show (funciter_Ubased_m );
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),funciter_Ubased_m );
   
  separator20 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator20);
  gtk_container_add (GTK_CONTAINER (menu_algorithms), separator20);
  menuitem_newton = gtk_radio_menu_item_new_with_label (algorithms,"Newton ITERATION");
  algorithms = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (menuitem_newton)); 
  gtk_container_add (GTK_CONTAINER (menu_algorithms), menuitem_newton);
  gtk_widget_show(menuitem_newton);

  separator12 = gtk_separator_menu_item_new();
  gtk_widget_show(separator12);
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),separator12);
  funz_starting_m = gtk_menu_item_new_with_mnemonic ("ITERATIONS starting point");
  gtk_container_add (GTK_CONTAINER (GTK_MENU (menu_algorithms)),funz_starting_m);
  gtk_widget_show (funz_starting_m);
  funz_m =  gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (funz_starting_m), funz_m);
  funz_start0_m = gtk_radio_menu_item_new_with_label(funz," x(0)=0");
  funz = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (funz_start0_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (funz_m)),funz_start0_m);
  gtk_widget_show (funz_start0_m);
  funz_start1_m = gtk_radio_menu_item_new_with_label(funz," x(0)=I");
  funz = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (funz_start1_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (funz_m)),funz_start1_m);
  gtk_widget_show (funz_start1_m);
  funz_startu_m = gtk_radio_menu_item_new_with_label(funz," user x(0)");
  funz = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (funz_startu_m));
  gtk_container_add (GTK_CONTAINER (GTK_MENU (funz_m)),funz_startu_m);
  gtk_widget_show (funz_startu_m);
  gtk_widget_set_sensitive (funz_starting_m,FALSE);

  separator13 = gtk_separator_menu_item_new();
  gtk_widget_show(separator13);
  gtk_container_add (GTK_CONTAINER (GTK_MENU (funz_m)),separator13);
  funz_readX_m = gtk_menu_item_new_with_label("Read X(0) from file");
  gtk_widget_show (funz_readX_m);
  gtk_container_add (GTK_CONTAINER (GTK_MENU (funz_m)),funz_readX_m);
if(is_debug==1)printf("create_window_main: end menu algorithms\n"); 
  
  /* Menu Goals */
  menuitem_goals = gtk_menu_item_new_with_mnemonic ("Goals");
  gtk_widget_show (menuitem_goals);
  gtk_container_add (GTK_CONTAINER (menubar), menuitem_goals);
  menu_goals = gtk_menu_new();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_goals), menu_goals);
  
  menuitem_qbd = gtk_menu_item_new_with_label("QBD goals");
  gtk_widget_set_sensitive (menuitem_qbd,TRUE);
  gtk_widget_show (menuitem_qbd );
  gtk_container_add (GTK_CONTAINER (menu_goals), menuitem_qbd);
  menuitem_mg1 = gtk_menu_item_new_with_label("M/G/1 goals");
  gtk_widget_set_sensitive (menuitem_mg1,FALSE);
  gtk_container_add (GTK_CONTAINER (menu_goals), menuitem_mg1);
  gtk_widget_show (menuitem_mg1 );
  menuitem_gim1 = gtk_menu_item_new_with_label("GI/M/1 goals");
  gtk_widget_set_sensitive (menuitem_gim1,FALSE);
  gtk_container_add (GTK_CONTAINER (menu_goals), menuitem_gim1);
  gtk_widget_show (menuitem_gim1 );
  separator6 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator6);
  gtk_container_add (GTK_CONTAINER (menu_goals), separator6);
  pi_param_m = gtk_menu_item_new_with_label("Set Pi Length");
  gtk_widget_show (pi_param_m);
  gtk_container_add (GTK_CONTAINER (menu_goals),pi_param_m);
 
  menu_qbd = gtk_menu_new();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_qbd), menu_qbd);
  qbd_g_m = gtk_radio_menu_item_new_with_label (qbd_goals,"G only");
  qbd_goals = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (qbd_g_m));
  gtk_widget_show (qbd_g_m);
  gtk_container_add (GTK_CONTAINER (menu_qbd), qbd_g_m);
  qbd_gr_m = gtk_radio_menu_item_new_with_label (qbd_goals,"G and R");
  qbd_goals = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (qbd_gr_m));
  gtk_widget_show (qbd_gr_m);
  gtk_container_add (GTK_CONTAINER (menu_qbd), qbd_gr_m);
  qbd_gru_m = gtk_radio_menu_item_new_with_label (qbd_goals,"G, R and U");
  qbd_goals = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (qbd_gru_m));
  gtk_widget_show (qbd_gru_m);
  gtk_container_add (GTK_CONTAINER (menu_qbd), qbd_gru_m);
  qbd_grupi_m = gtk_radio_menu_item_new_with_label (qbd_goals,"G, R  U and Pi");
  qbd_goals = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (qbd_grupi_m));
  gtk_widget_show (qbd_grupi_m);
  gtk_container_add (GTK_CONTAINER (menu_qbd), qbd_grupi_m);

  menu_mg1 = gtk_menu_new();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_mg1), menu_mg1);
  mg1_g_m = gtk_radio_menu_item_new_with_label (mg1_goals,"G only");
  mg1_goals = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (mg1_g_m));
  gtk_widget_show (mg1_g_m);
  gtk_container_add (GTK_CONTAINER (menu_mg1), mg1_g_m);
  mg1_gpi_m = gtk_radio_menu_item_new_with_label (mg1_goals,"G and Pi");
  mg1_goals = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (mg1_gpi_m));
  gtk_widget_show (mg1_gpi_m);
  gtk_container_add (GTK_CONTAINER (menu_mg1), mg1_gpi_m);

  menu_gim1 = gtk_menu_new();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_gim1), menu_gim1);
  gim1_r_m = gtk_radio_menu_item_new_with_label (gim1_goals,"R only");  
  gim1_goals = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (gim1_r_m));
  gtk_widget_show (gim1_r_m);
  gtk_container_add (GTK_CONTAINER (menu_gim1), gim1_r_m);
  gim1_rpi_m = gtk_radio_menu_item_new_with_label (gim1_goals,"R and Pi");   
  gim1_goals = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (gim1_rpi_m));
  gtk_widget_show (gim1_rpi_m);
  gtk_container_add (GTK_CONTAINER (menu_gim1), gim1_rpi_m);

 if(is_debug==1)printf("create_window_main: end menu goals\n"); 
  
  /* Menu Options */
  menuitem_options = gtk_menu_item_new_with_mnemonic ("_Options");
  gtk_widget_show (menuitem_options);
  gtk_container_add (GTK_CONTAINER (menubar), menuitem_options);
  menu_options = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_options),menu_options);
  verbose_m =  gtk_check_menu_item_new_with_label("Verbose");
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (verbose_m),TRUE);
  gtk_widget_show (verbose_m);
  gtk_container_add (GTK_CONTAINER (menu_options), verbose_m);
  debugging_m =  gtk_check_menu_item_new_with_label("Debugging"); 
  gtk_container_add (GTK_CONTAINER (menu_options),debugging_m);
  gtk_widget_show (debugging_m);
  /* in main.c the flag -d setup debugging on the command line */ 
  if (is_debug==1) printf("create_window_main: is_debug == 1\n");
  if (is_debug==1)  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (debugging_m),TRUE); 
  timings_m =gtk_check_menu_item_new_with_label("Timings");
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (timings_m),TRUE);
  gtk_widget_show (timings_m);
  gtk_container_add (GTK_CONTAINER (menu_options),timings_m ); 
  small_m =  gtk_check_menu_item_new_with_label("Landscape Windows");
  gtk_container_add (GTK_CONTAINER (menu_options),small_m);
  if(is_smallscr==0) gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (small_m),FALSE);
  else gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (small_m),TRUE);
  gtk_widget_show (small_m);

  separator9 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator9);
  gtk_container_add (GTK_CONTAINER (menu_options), separator9);
  situation_m =gtk_check_menu_item_new_with_label("Show InfoBar");
  gtk_widget_show (situation_m);
  gtk_container_add (GTK_CONTAINER (menu_options), situation_m);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(situation_m),TRUE);
  separator10 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator10);
  gtk_container_add (GTK_CONTAINER (menu_options), separator10);
  menuitem_digits = gtk_menu_item_new_with_mnemonic ("digits to save\nin writing files");
  gtk_widget_show (menuitem_digits);
  gtk_container_add (GTK_CONTAINER (menu_options),menuitem_digits);
  menu_digits = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_digits),menu_digits);
  eigth_d_m = gtk_radio_menu_item_new_with_label (digits," 8 digits");
  digits = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (eigth_d_m));
  gtk_widget_show(eigth_d_m);
  gtk_container_add (GTK_CONTAINER (menu_digits),eigth_d_m );
  fifteen_d_m =  gtk_radio_menu_item_new_with_label (digits,"15 digits");
  digits = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (fifteen_d_m));
  gtk_widget_show(fifteen_d_m);
  gtk_container_add (GTK_CONTAINER (menu_digits),fifteen_d_m );
  sixteen_d_m = gtk_radio_menu_item_new_with_label (digits,"16 digits");
  digits = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (sixteen_d_m)); 
  gtk_widget_show(sixteen_d_m);
  gtk_container_add (GTK_CONTAINER (menu_digits), sixteen_d_m);
  seventeen_d_m = gtk_radio_menu_item_new_with_label (digits,"17 digits");
  digits = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (seventeen_d_m));
  gtk_widget_show(seventeen_d_m);
  gtk_container_add (GTK_CONTAINER (menu_digits),seventeen_d_m);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (sixteen_d_m),TRUE);

  separator7 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator7);
  gtk_container_add (GTK_CONTAINER (menu_options), separator7);
  parameters_cr_m =gtk_menu_item_new_with_label (" C.R.  Parameters");
  gtk_widget_show(parameters_cr_m);
  gtk_container_add (GTK_CONTAINER (menu_options), parameters_cr_m);
  parameters_lr_m =gtk_menu_item_new_with_label (" L.R.  Parameters");
  gtk_widget_show(parameters_lr_m);
  gtk_container_add (GTK_CONTAINER (menu_options), parameters_lr_m);
  parameters_is_m =gtk_menu_item_new_with_label (" I.S.  Parameters");
  gtk_widget_show(parameters_is_m);
  gtk_container_add (GTK_CONTAINER (menu_options), parameters_is_m);
  parameters_fi_m =gtk_menu_item_new_with_label (" F.I.  Parameters");
  gtk_widget_show(parameters_fi_m);
  gtk_container_add (GTK_CONTAINER (menu_options), parameters_fi_m);
  parameters_nt_m =gtk_menu_item_new_with_label (" NWTN  Parameters");
  gtk_widget_show(parameters_nt_m);
  gtk_container_add (GTK_CONTAINER (menu_options), parameters_nt_m);
  separator8 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator8);
  gtk_container_add (GTK_CONTAINER (menu_options), separator8);
  parameters_reset_m =gtk_menu_item_new_with_label ("Reset All Parameters");
  gtk_widget_show(parameters_reset_m);
  gtk_container_add (GTK_CONTAINER (menu_options), parameters_reset_m);
 if(is_debug==1)printf("create_window_main: end menu Options\n");

  /* Menu Run */
  menuitem_run = gtk_menu_item_new_with_label ("Execute");
  gtk_widget_show (menuitem_run);
  gtk_container_add (GTK_CONTAINER (menubar), menuitem_run);
  menu_run = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_run), menu_run);
  
  run_m = gtk_image_menu_item_new_from_stock ("gtk-execute", accel_group);
  gtk_label_set_text (GTK_LABEL(gtk_bin_get_child (GTK_BIN(run_m))),"Run");
  gtk_widget_show (run_m);
  gtk_container_add (GTK_CONTAINER (menu_run),run_m);
  stop_m = gtk_image_menu_item_new_from_stock ("gtk-stop", accel_group);
  gtk_widget_show (stop_m);
  gtk_container_add (GTK_CONTAINER (menu_run),stop_m);
/*  pause_m = gtk_menu_item_new_with_label ("Pause");
  gtk_widget_show (pause_m);
  gtk_container_add (GTK_CONTAINER (menu_run),pause_m); */
  separator11 =  gtk_separator_menu_item_new();
  gtk_widget_show(separator11);
  gtk_container_add (GTK_CONTAINER (menu_run), separator11);
  edita_m =gtk_image_menu_item_new_with_label("View & Edit A");
 /* add the stock edit to edit A */
  style = gtk_widget_get_style(window_main);
  mappacolor = gdk_colormap_get_system ();
  pixmap_ed =gdk_pixmap_colormap_create_from_xpm_d(window_main->window,mappacolor,&mask,&style->bg[GTK_STATE_NORMAL],stock_edit);
  pixmapwid_ed = gtk_pixmap_new(pixmap_ed,mask);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(edita_m),pixmapwid_ed);
  gtk_widget_show(pixmapwid_ed);
 /* added                        */
  gtk_widget_show (edita_m);
  gtk_container_add (GTK_CONTAINER (menu_run),edita_m);

  editb_m =gtk_image_menu_item_new_with_label("View & Edit B");
 /* add the stock edit to edit B */
  style = gtk_widget_get_style(window_main);
  mappacolor = gdk_colormap_get_system ();
  pixmap_ed =gdk_pixmap_colormap_create_from_xpm_d(window_main->window,mappacolor,&mask,&style->bg[GTK_STATE_NORMAL],stock_edit);
  pixmapwid_ed = gtk_pixmap_new(pixmap_ed,mask);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(editb_m),pixmapwid_ed);
  gtk_widget_show(pixmapwid_ed);
 /* added                        */
  gtk_widget_show (editb_m);
  gtk_container_add (GTK_CONTAINER (menu_run),editb_m);

  view_matrix_m =gtk_image_menu_item_new_with_label("View G/R/U");
  pixmapwid_view = gtk_pixmap_new(pixmap_ed,mask);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(view_matrix_m),pixmapwid_view);
  gtk_widget_show(pixmapwid_view);
  gtk_widget_show (view_matrix_m);
  gtk_container_add (GTK_CONTAINER (menu_run),view_matrix_m);

  view_pi_m =gtk_image_menu_item_new_with_label("View Pi");
  pixmapwid_view = gtk_pixmap_new(pixmap_ed,mask);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(view_pi_m),pixmapwid_view);
  gtk_widget_show(pixmapwid_view);
  gtk_widget_show (view_pi_m);
  gtk_container_add (GTK_CONTAINER (menu_run),view_pi_m);
 
/* gtk_widget_set_sensitive (edita_m,FALSE);*/
  /* Menu About, Help  */
  menuitem_help = gtk_menu_item_new_with_mnemonic ("_Help");
  gtk_widget_show (menuitem_help);
  gtk_container_add (GTK_CONTAINER (menubar), menuitem_help);
  menu_help = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem_help), menu_help);

  about_m = gtk_image_menu_item_new_with_label("About");
 /* add the little star to About */
  style = gtk_widget_get_style(window_main);
  mappacolor = gdk_colormap_get_system ();
  pixmap_ss =gdk_pixmap_colormap_create_from_xpm_d(window_main->window,mappacolor,&mask,&style->bg[GTK_STATE_NORMAL],small_star);
  pixmapwid_ss = gtk_pixmap_new(pixmap_ss,mask);  
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM(about_m),pixmapwid_ss);
  gtk_widget_show(pixmapwid_ss);
 /* added                        */
  gtk_widget_show (about_m);
  gtk_container_add (GTK_CONTAINER (menu_help), about_m);

  help_m = gtk_image_menu_item_new_from_stock ("gtk-help", accel_group);
  gtk_widget_show (help_m);
  gtk_container_add (GTK_CONTAINER (menu_help), help_m);
  /***************** Menus ends here */

  /***************** textview           */
  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_start (GTK_BOX (vbox_main), scrolledwindow, TRUE, TRUE, 0);
  textview = gtk_text_view_new ();
  gtk_widget_show (textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (textview), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (textview), GTK_WRAP_WORD);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textview), FALSE);
  gtk_text_view_set_indent (GTK_TEXT_VIEW (textview), 6);
  /***************** textview ends here */

  /* optional situation bar with display of all selected options */
  handlebox_s = gtk_handle_box_new ();
  gtk_widget_show (handlebox_s);
  gtk_handle_box_set_snap_edge (GTK_HANDLE_BOX(handlebox_s),GTK_POS_BOTTOM);
  gtk_box_pack_start (GTK_BOX (vbox_main), handlebox_s, FALSE, FALSE, 0);
  hbox_s = gtk_hbox_new (FALSE, 30);
  gtk_container_add (GTK_CONTAINER ( handlebox_s ),hbox_s);
  vbox_s1 = gtk_vbox_new (TRUE, 0);
  vbox_s2 = gtk_vbox_new (TRUE, 0);
  vbox_s3 = gtk_vbox_new (TRUE, 0);
  vbox_s4 = gtk_vbox_new (TRUE, 0);
  vbox_s5 = gtk_vbox_new (TRUE, 0);
  vbox_s6 = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER ( hbox_s ),vbox_s1);
  gtk_container_add (GTK_CONTAINER ( hbox_s ),vbox_s2);
  gtk_container_add (GTK_CONTAINER ( hbox_s ),vbox_s3);
  gtk_container_add (GTK_CONTAINER ( hbox_s ),vbox_s4);
  gtk_container_add (GTK_CONTAINER ( hbox_s ),vbox_s5);
  gtk_container_add (GTK_CONTAINER ( hbox_s ),vbox_s6);
  labelu_s1= gtk_label_new("PROBLEM");
  labelu_s2= gtk_label_new("DATA");
  labelu_s3= gtk_label_new("ALGORITHM");
  labelu_s4= gtk_label_new("GOALS");
  labelu_s5= gtk_label_new("SHIFT");
  labelu_s6= gtk_label_new("DUAL");
  gtk_container_add (GTK_CONTAINER ( vbox_s1 ),labelu_s1);
  gtk_container_add (GTK_CONTAINER ( vbox_s2 ),labelu_s2);
  gtk_container_add (GTK_CONTAINER ( vbox_s3 ),labelu_s3);
  gtk_container_add (GTK_CONTAINER ( vbox_s4 ),labelu_s5);
  gtk_container_add (GTK_CONTAINER ( vbox_s5 ),labelu_s6);
  gtk_container_add (GTK_CONTAINER ( vbox_s6 ),labelu_s4);
  label_s1= gtk_label_new(NULL);
  label_s2= gtk_label_new(NULL);
  label_s3= gtk_label_new(NULL);
  label_s4= gtk_label_new(NULL);
  label_s5= gtk_label_new(NULL);
  label_s6= gtk_label_new(NULL);
  gtk_container_add (GTK_CONTAINER ( vbox_s1 ),label_s1);
  gtk_container_add (GTK_CONTAINER ( vbox_s2 ),label_s2);
  gtk_container_add (GTK_CONTAINER ( vbox_s3 ),label_s3);
  gtk_container_add (GTK_CONTAINER ( vbox_s4 ),label_s5);
  gtk_container_add (GTK_CONTAINER ( vbox_s5 ),label_s6);
  gtk_container_add (GTK_CONTAINER ( vbox_s6 ),label_s4);
  gtk_widget_show_all(GTK_WIDGET(handlebox_s)); 
  /**************** toolbar  - replicates most used menu commands */
/*  handlebox_t = gtk_handle_box_new ();
  gtk_widget_show (handlebox_t);
  gtk_container_add (GTK_CONTAINER (vbox_main), handlebox_t);
*/
  handlebox_t = gtk_handle_box_new ();
  gtk_widget_show (handlebox_t);
  gtk_handle_box_set_snap_edge (GTK_HANDLE_BOX(handlebox_t),GTK_POS_BOTTOM);
  gtk_box_pack_start (GTK_BOX (vbox_main), handlebox_t, FALSE, FALSE, 0);

  toolbar = gtk_toolbar_new ();
  gtk_widget_show (toolbar);
/*
  gtk_box_pack_start (GTK_BOX (vbox_main), toolbar, FALSE, FALSE, 0);
*/
  gtk_container_add (GTK_CONTAINER ( handlebox_t ),toolbar); 
  if(is_smallscr==0) gtk_container_set_border_width (GTK_CONTAINER (toolbar), 18);
	else gtk_container_set_border_width (GTK_CONTAINER (toolbar), 8);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_BOTH);

  gtk_hbutton_box_set_layout_default (GTK_BUTTONBOX_SPREAD);
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-quit", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));
  button_quit = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Quit",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  /* something not working: no use_underline in no way ??? */
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar)->children)->data))->label), TRUE);
  gtk_button_set_use_underline (GTK_BUTTON(button_quit),TRUE);
  gtk_widget_show (button_quit);
  gtk_tooltips_set_tip (tooltips, button_quit, "Quit Program (no warnings!)", NULL);
  /* fake button for spacing begins */
  gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, "", NULL, NULL, NULL, NULL, NULL);
  /* fake button for spacing ends   */
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-save", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));    
  button_save_notepad = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "NotePad\n  Save ",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button_save_notepad); 
  gtk_tooltips_set_tip (tooltips, button_save_notepad, "Save NotePad",NULL);
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-clear", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));
  button_clear_notepad = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "NotePad\n  Clear ",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button_clear_notepad);
  gtk_tooltips_set_tip (tooltips, button_clear_notepad, "Clear NotePad",NULL);
  /* fake button for spacing begins */
  gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, "", NULL, NULL, NULL, NULL, NULL);
  /* fake button for spacing ends   */
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-execute", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));
  button_run = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Run",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button_run);
  gtk_tooltips_set_tip (tooltips, button_run, "Begin Computation", NULL);
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-stop", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));
  button_stop = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Stop",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button_stop);
  gtk_tooltips_set_tip (tooltips, button_stop, "Stop Computation", NULL);
  /* fake button for spacing begins */
  gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, "", NULL, NULL, NULL, NULL, NULL);
  /* fake button for spacing ends   */
  pixmap_big_ed =gdk_pixmap_colormap_create_from_xpm_d(window_main->window,mappacolor,&mask,&style->bg[GTK_STATE_NORMAL],big_edit);
  pixmapwid_big_ed_a = gtk_pixmap_new(pixmap_big_ed,mask);
  gtk_widget_show(pixmapwid_big_ed_a);
  pixmapwid_big_ed_b = gtk_pixmap_new(pixmap_big_ed,mask);
  gtk_widget_show(pixmapwid_big_ed_b);
  pixmapwid_big_view = gtk_pixmap_new(pixmap_big_ed,mask);
  gtk_widget_show(pixmapwid_big_view);
  pixmapwid_big_view_pi = gtk_pixmap_new(pixmap_big_ed,mask);
  gtk_widget_show(pixmapwid_big_view_pi);
  tmp_toolbar_icon = gtk_image_new_from_stock ("stock-edit", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));
  button_edita = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "View/Edit\nMatrix A",
                                NULL, NULL,
                                pixmapwid_big_ed_a, NULL, NULL);
  button_editb = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "View/Edit\nMatrix B",
                                NULL, NULL,
                                pixmapwid_big_ed_b, NULL, NULL);
  button_viewgru = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "View\nG/R/U",
                                NULL, NULL,
                                pixmapwid_big_view, NULL, NULL);
  button_viewpi = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "View\n Pi",
                                NULL, NULL,
                                pixmapwid_big_view_pi, NULL, NULL);
  /* fake button for spacing begins */
  gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, "", NULL, NULL, NULL, NULL, NULL);
  /* fake button for spacing ends   */
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-help", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));
  button_help = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Help",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (button_help);
  gtk_tooltips_set_tip (tooltips, button_help, "Show Help Window", NULL);
  /**************** toolbar  ends here                           */

  /**************** statusbar       */
  statusb = gtk_statusbar_new();
  gtk_widget_show (statusb);
  gtk_box_pack_start (GTK_BOX (vbox_main), statusb, FALSE, FALSE, 0);
/*   gtk_statusbar_push(GTK_STATUSBAR(statusb),0,"prova"); test writing to statusb */


/* test changing statusbar fonts */
desc = pango_font_description_from_string("Sans Bold ");
gtk_widget_modify_font(GTK_STATUSBAR(statusb)->label, desc);
/* gtk_misc_set_alignment(GTK_MISC(GTK_STATUSBAR(statusb)->label), 0.5, 0.5);*/
pango_font_description_free(desc);

  /**************** statusbar ends here */
if(is_debug==1)printf("create_window_main: ready to connect signals\n");
  /**************** connect signals  Menu  File   */
  g_signal_connect ((gpointer) gm1_m, "activate",G_CALLBACK (on_main_menu_problem_gm1),NULL);
  g_signal_connect ((gpointer) mg1_m, "activate",G_CALLBACK (on_main_menu_problem_mg1),NULL);
  g_signal_connect ((gpointer) qbd_m, "activate",G_CALLBACK (on_main_menu_problem_qbd),NULL);
  g_signal_connect ((gpointer) read_b_m, "activate", G_CALLBACK(on_main_menu_readb_activate),NULL);
  g_signal_connect ((gpointer) save_a_m, "activate", G_CALLBACK(on_main_menu_savea_activate),NULL);
  g_signal_connect ((gpointer) save_b_m, "activate", G_CALLBACK(on_main_menu_saveb_activate),NULL);
  g_signal_connect ((gpointer) saveg_m, "activate", G_CALLBACK(on_main_menu_saveg_activate),NULL);
  g_signal_connect ((gpointer) saver_m, "activate", G_CALLBACK(on_main_menu_saver_activate),NULL);
  g_signal_connect ((gpointer) saveu_m, "activate", G_CALLBACK(on_main_menu_saveu_activate),NULL);
  g_signal_connect ((gpointer) savegru_m, "activate", G_CALLBACK(on_main_menu_savegru_activate),NULL);
  g_signal_connect ((gpointer) savepi_m, "activate", G_CALLBACK(on_main_menu_savepi_activate),NULL);
  g_signal_connect ((gpointer) clear_notepad_m, "activate", G_CALLBACK(on_main_menu_clearpad_activate),NULL);
  g_signal_connect ((gpointer) save_notepad_m, "activate", G_CALLBACK(on_main_menu_savepad_activate),NULL);
  g_signal_connect ((gpointer) quit_m, "activate", G_CALLBACK (on_main_menu_quit_activate), NULL); /* no use after enter_notify_event */
  g_signal_connect ((gpointer) quit_m, "button_press_event", G_CALLBACK (on_main_menu_quit_activate), NULL); /* use this instead */
  g_signal_connect ((gpointer) window_main, "destroy", G_CALLBACK (on_main_menu_destroy_activate),NULL);
   /*   testing poors man tooltips for menus  */
  g_signal_connect ((gpointer) quit_m, "enter_notify_event", G_CALLBACK (on_main_menu_quit_enter), NULL);
  g_signal_connect ((gpointer) quit_m, "leave_notify_event", G_CALLBACK (on_main_menu_quit_leave), NULL);
  /**************** connect signals  Menu  Examples  */
 for(i=1;i<=examples_no;i++) g_signal_connect ((gpointer) es_m[i], "activate",G_CALLBACK (on_main_menu_problem_example_n),i);  
 /**************** connect signals  Menu Preprocessing   */
  g_signal_connect_after ((gpointer) noshift_m, "activate",G_CALLBACK (on_main_menu_preproc_noshift),NULL);
  g_signal_connect_after ((gpointer) simpleshift_m, "activate",G_CALLBACK (on_main_menu_preproc_shift),NULL);
  g_signal_connect_after ((gpointer) taushift_m, "activate",G_CALLBACK (on_main_menu_preproc_taushift),NULL);
  g_signal_connect_after ((gpointer) doubleshift_m, "activate",G_CALLBACK (on_main_menu_preproc_dbshift),NULL);
  g_signal_connect_after ((gpointer) autodual_m, "activate",G_CALLBACK (on_main_menu_preproc_autodual),NULL);
  g_signal_connect_after ((gpointer) ramadual_m, "activate",G_CALLBACK (on_main_menu_preproc_ramadual),NULL);
  g_signal_connect_after ((gpointer) brigthdual_m, "activate",G_CALLBACK (on_main_menu_preproc_brigthdual),NULL);
  g_signal_connect_after ((gpointer) nodual_m, "activate",G_CALLBACK (on_main_menu_preproc_nodual),NULL);
  g_signal_connect_after ((gpointer) bothdual_m, "activate",G_CALLBACK (on_main_menu_preproc_doubledual),NULL);
  /**************** connect signals  Menu Algorithms   */
  g_signal_connect_after ((gpointer) cyclicr_basic_m, "activate",G_CALLBACK (on_main_menu_algorithms_cyclicr_basic),NULL);
  g_signal_connect_after ((gpointer) cyclicr_diagadj_m, "activate",G_CALLBACK (on_main_menu_algorithms_cyclicr_diag),NULL);
  g_signal_connect_after ((gpointer) logarithmicr_basic_m, "activate",G_CALLBACK (on_main_menu_algorithms_logarithmicr_basic),NULL);
  g_signal_connect_after ((gpointer) logarithmicr_gth_m, "activate",G_CALLBACK (on_main_menu_algorithms_logarithmicr_gth),NULL);
  g_signal_connect_after ((gpointer) funciter_natural_m, "activate",G_CALLBACK (on_main_menu_algorithms_funciter_natural),NULL);
  g_signal_connect_after ((gpointer) funciter_traditional_m, "activate",G_CALLBACK (on_main_menu_algorithms_funciter_traditional),NULL);
  g_signal_connect_after ((gpointer) funciter_Ubased_m, "activate",G_CALLBACK (on_main_menu_algorithms_funciter_Ubased),NULL);
  g_signal_connect_after ((gpointer) invarsubsp_basic_m, "activate",G_CALLBACK (on_main_menu_algorithms_invarsubsp_basic),NULL);
  g_signal_connect_after ((gpointer) invarsubsp_balzer_m, "activate",G_CALLBACK (on_main_menu_algorithms_invarsubsp_balzer),NULL);
  g_signal_connect_after ((gpointer) invarsubsp_schur_m, "activate",G_CALLBACK (on_main_menu_algorithms_invarsubsp_schur),NULL);
  g_signal_connect_after ((gpointer) menuitem_newton, "activate",G_CALLBACK (on_main_menu_algorithms_newton),NULL);

  g_signal_connect ((gpointer) funz_start0_m, "activate",G_CALLBACK (on_main_menu_algorithms_funz_0),NULL);
  g_signal_connect ((gpointer) funz_start1_m, "activate",G_CALLBACK (on_main_menu_algorithms_funz_1),NULL);
  g_signal_connect ((gpointer) funz_startu_m, "activate",G_CALLBACK (on_main_menu_algorithms_funz_u),NULL);
  g_signal_connect ((gpointer) funz_readX_m, "activate",G_CALLBACK (on_main_menu_algorithms_funz_readX),NULL);

  /**************** connect signals  Menu Goals */
  g_signal_connect ((gpointer) qbd_g_m, "activate",G_CALLBACK (on_main_menu_goals_qbd_g),NULL);
  g_signal_connect ((gpointer) qbd_gr_m, "activate",G_CALLBACK (on_main_menu_goals_qbd_gr),NULL);
  g_signal_connect ((gpointer) qbd_gru_m, "activate",G_CALLBACK (on_main_menu_goals_qbd_gru),NULL);
  g_signal_connect ((gpointer) qbd_grupi_m, "activate",G_CALLBACK (on_main_menu_goals_qbd_grupi),NULL);
  g_signal_connect ((gpointer) mg1_g_m, "activate",G_CALLBACK (on_main_menu_goals_mg1_g),NULL);
  g_signal_connect ((gpointer) mg1_gpi_m, "activate",G_CALLBACK (on_main_menu_goals_mg1_gpi),NULL);
  g_signal_connect ((gpointer) gim1_r_m, "activate",G_CALLBACK (on_main_menu_goals_gim1_r),NULL);
  g_signal_connect ((gpointer) gim1_rpi_m, "activate",G_CALLBACK (on_main_menu_goals_gim1_rpi),NULL);
  g_signal_connect ((gpointer)pi_param_m, "activate",G_CALLBACK (on_main_menu_goals_pi_param),NULL);

  /**************** connect signals  Menu Options */
  g_signal_connect ((gpointer) verbose_m, "activate",G_CALLBACK (on_main_menu_options_verbose),NULL);
  g_signal_connect ((gpointer) debugging_m, "activate",G_CALLBACK (on_main_menu_options_debug),NULL);
  g_signal_connect ((gpointer) timings_m, "activate",G_CALLBACK (on_main_menu_options_timings),NULL); 
  g_signal_connect ((gpointer) small_m, "activate",G_CALLBACK (on_main_menu_options_small),NULL);
  g_signal_connect ((gpointer) situation_m, "activate",G_CALLBACK (on_main_menu_options_situation) ,NULL);
  g_signal_connect ((gpointer) eigth_d_m, "activate",G_CALLBACK (on_main_menu_options_eigth_d) ,NULL);
  g_signal_connect ((gpointer) fifteen_d_m, "activate",G_CALLBACK (on_main_menu_options_fifteen_d) ,NULL);
  g_signal_connect ((gpointer) sixteen_d_m, "activate",G_CALLBACK (on_main_menu_options_sixteen_d) ,NULL);
  g_signal_connect ((gpointer) seventeen_d_m, "activate",G_CALLBACK (on_main_menu_options_seventeen_d) ,NULL);
  g_signal_connect ((gpointer) parameters_cr_m, "activate",G_CALLBACK (on_main_menu_options_parameters_cr) ,NULL);
  g_signal_connect ((gpointer) parameters_lr_m, "activate",G_CALLBACK (on_main_menu_options_parameters_lr) ,NULL);
  g_signal_connect ((gpointer) parameters_fi_m, "activate",G_CALLBACK (on_main_menu_options_parameters_fi) ,NULL);
  g_signal_connect ((gpointer) parameters_is_m, "activate",G_CALLBACK (on_main_menu_options_parameters_is) ,NULL);
  g_signal_connect ((gpointer) parameters_nt_m, "activate",G_CALLBACK (on_main_menu_options_parameters_nt) ,NULL);
  g_signal_connect ((gpointer) parameters_reset_m, "activate",G_CALLBACK (on_main_menu_options_parameters_reset) ,NULL);
  /**************** connect signals  Menu Execute */ 
  g_signal_connect ((gpointer) run_m, "activate", G_CALLBACK (on_main_menu_run_activate), NULL);
  g_signal_connect ((gpointer) stop_m, "activate", G_CALLBACK (on_main_menu_stop_activate), NULL);
  g_signal_connect ((gpointer) edita_m, "activate", G_CALLBACK (on_main_menu_edit_a_activate), NULL);
  g_signal_connect ((gpointer) editb_m, "activate", G_CALLBACK (on_main_menu_edit_b_activate), NULL);
  g_signal_connect ((gpointer) view_matrix_m, "activate", G_CALLBACK (on_main_menu_view_matrix_activate), NULL);
  g_signal_connect ((gpointer) view_pi_m, "activate", G_CALLBACK (on_main_menu_view_pi_activate), NULL);
  /**************** connect signals  Menu Help  */
  g_signal_connect ((gpointer) about_m, "activate", G_CALLBACK (on_main_menu_about_activate), NULL);
  g_signal_connect ((gpointer) help_m, "activate", G_CALLBACK (on_main_menu_help_activate), NULL);
  /**************** connect signals  Toolbar      */
  g_signal_connect ((gpointer) button_quit, "clicked", G_CALLBACK (on_main_menu_quit_activate), NULL);
  g_signal_connect ((gpointer) button_save_notepad, "clicked", G_CALLBACK (on_main_menu_savepad_activate), NULL);
  g_signal_connect ((gpointer) button_clear_notepad, "clicked", G_CALLBACK (on_main_menu_clearpad_activate), NULL);
  g_signal_connect ((gpointer) button_run, "clicked", G_CALLBACK (on_main_menu_run_activate), NULL);
  g_signal_connect ((gpointer) button_stop, "clicked", G_CALLBACK (on_main_menu_stop_activate), NULL);
  g_signal_connect ((gpointer)button_edita, "clicked", G_CALLBACK (on_main_menu_edit_a_activate), NULL);
  g_signal_connect ((gpointer)button_editb, "clicked", G_CALLBACK (on_main_menu_edit_b_activate), NULL);
  g_signal_connect ((gpointer)button_viewgru, "clicked", G_CALLBACK (on_main_menu_view_matrix_activate), NULL);
  g_signal_connect ((gpointer)button_viewpi, "clicked", G_CALLBACK (on_main_menu_view_pi_activate), NULL);
  g_signal_connect ((gpointer) button_help, "clicked", G_CALLBACK (on_main_menu_help_activate), NULL);
  /**************** connect signals ends here */
 
  /* setup help and about windows status, FIFO, examples window status, running status */
  is_saveg_open=0;      /* 0 = not open 1 = open */
  is_saver_open=0;     /* 0 = not open 1 = open */
  is_saveu_open=0;      /* 0 = not open 1 = open */
  is_savegru_open=0;    /* 0 = not open 1 = open */
  is_about_open=0;
  is_help_open=0;
  is_savepad_open=0;
  is_edit_a_open=0;  /* 0=not open  1=open */
  is_view_matrix_open=0; /* 0=not open  1=open */
  is_pi_parameters_open=0; /* 0=not open  1=open */
  is_readX_open=0; /* 0=not open  1=open */
  /* edit_a preferences */
  pea.block=1;
  pea.is_positive=0;
  pea.is_color=1; 
  pea.contrast_value=0.0;
  pea.is_user=1;
  pea.is_range_type=2;
  /* edit_b preferences */
  peb.block=0;
  peb.is_positive=0;
  peb.is_color=1;
  peb.contrast_value=0.0;
  peb.is_user=1;
  peb.is_range_type=2;

  is_running=0;
  /* view preferences */
  pview.is_positive=0;
  pview.is_color=1;
  pview.contrast_value=0.0;
  pview.is_user=1;
  pview.is_range_type=2; 
  pview.is_gru=1;
  /* fake matrix fortran style,  index from 1 to 4 included */
  fake_dim=4;
  /* 
        0	0.5	0	0.5
	0.1	0	0.1	0
	0	0.1	0	0.1	
	0.5	0	0.5	0
   */
  for(i=0;i<26;i++) fake_matrix[i]=0;
  fake_matrix[2]=0.1; fake_matrix[4]=0.5; fake_matrix[5]=0.5; fake_matrix[7]=0.1; 
  fake_matrix[10]=0.1; fake_matrix[12]=0.5; fake_matrix[13]=0.5; fake_matrix[15]=0.1; 
  /* problem selected */
  selected.type =1; /*QBD default*/
  committed.is_bn1=0; /*used reading b - a new A resets them */
  committed.is_b0=0;
  committed.is_b=0;
  committed.type =0;
  committed.allocated = 0;
  committed.example=0;
  committed.fz_file_read=0;
  committed.fz_file_dim=0;
  invalidate_completed();
  /* defaults algorithms */
  algorithms_choice.type=1;  /* cyclic Reduction */
  algorithms_choice.shift=0; /* no shift */
  algorithms_choice.dual=4;  /* no dual */
  algorithms_choice.cr_base=1;
  algorithms_choice.cr_diag=0;
  algorithms_choice.lr_base=0;
  algorithms_choice.lr_gth=0;
  algorithms_choice.fi_natural=0;
  algorithms_choice.fi_traditional=0;
  algorithms_choice.fi_Ubased=0;
  algorithms_choice.is_base=0;
  algorithms_choice.is_balzer=0;
  algorithms_choice.is_schur=0;
  algorithms_choice.fz_0=1;
  algorithms_choice.fz_1=0;
  algorithms_choice.fz_u=0;
  goals_choice.qbd_g=1;
  goals_choice.qbd_gr=0;
  goals_choice.qbd_gru=0;
  goals_choice.qbd_grupi=0;
  goals_choice.mg1_g=1;
  goals_choice.mg1_gpi=0;
  goals_choice.gim1_r=1;
  goals_choice.gim1_rpi=0;
  committed.type=0;
  is_verbose=1;  /* 1= verbose, 0= not verbose */
  is_timings=1;  /* 1= internal timing of fortran routines 0=normal */
  is_situation=1; /* 1= show situation bar 0= hide situation bar */
  is_examples_open=0;
  fifosi=0;
  fifoin=0;
  fifoout=0; 
  fifomax=64000; /* if changed, change fifostr in the headers !!!! */
  my_thread_main = pthread_self(); 
  strcpy(digits_to_save," %1.15le"); /* default 16 digits to save in files when writing numbers floating point */

   ssdebug_(&is_debug);
  /* update once only */
  g_idle_add((GtkFunction) selection_uptodaten,NULL);
  return window_main;
}
/*********************************/


/* Examples Window */
GtkWidget*
create_window_examples (int e_n)
{
/* GtkWidget *window_examples; global */
GtkWidget *vbox_examples;
GtkWidget *scrolledwindow;
GtkWidget *textview_examples;
GtkWidget *toolbar_examples;
GtkWidget *tmp_toolbar_icon;
GtkWidget *button_quit_examples;
GtkWidget *hbox;
GtkWidget *dimension_m_label;
/* GtkWidget *dimension_m_entry; global */
gchar dimension_m_out[256];
GtkWidget *dimension_n_label;
/* GtkWidget *dimension_n_entry; global */
gchar dimension_n_out[256];
GtkWidget *dimension_space_label;
GtkWidget *hbox_box;
GtkWidget *howmany_a_label;
/* GtkWidget *howmany_a_entry; global */
gchar howmany_a_out[256];
GtkWidget *howmany_b_label;
GtkWidget *howmany_b_entry;
gchar howmany_b_out[256];
GtkWidget *howmany_space_label;
/* double alpha_in_mant,alpha_in_exp; globals */
GtkWidget *alpha_label;
/*
GtkObject *alpha_adj;
*/
/* GtkWidget *alpha_entry; global */
/* GtkWidget *alpha_e_label;
GtkObject *alpha_e_adj;
GtkWidget *alpha_e_entry;
*/
/* double beta_in_mant,beta_in_exp; globals */
GtkWidget *beta_label;
/*
GtkObject *beta_adj;
*/
/* GtkWidget *beta_entry; global */
/*
GtkWidget *beta_e_label;
GtkObject *beta_e_adj;
GtkWidget *beta_e_entry;
*/
GtkWidget *button_ok_examples;
/* GtkWidget *statusb_examples; global */
GtkTextBuffer *buffer_e;
GtkTextIter  enditerm;
char buf[256];
if(is_debug==1) printf("create_windows_example: entering with en=%d\n",e_n);
/* globals setup  */
if ((committed.allocated==1)&&(committed.example==e_n)) {
  /* in this case we are opening the same example we did ok successfully just before */
  /* we prefer to show the same dimensions we did select previously */
  dimension_m = committed.dimension_m;
  dimension_n = committed.dimension_n;
  matrix_a_num = committed.matrix_a_num;
  matrix_b_num = committed.matrix_b_num;
  alpha_in = committed.alpha;
  beta_in = committed.beta;
  } else {
  /*temporary global dimension startup values from examples defaults */
  dimension_m=es[e_n].dimension_m ;
  dimension_n= es[e_n].dimension_n;
  matrix_a_num= es[e_n].matrix_a_num;
  matrix_b_num= es[e_n].matrix_b_num ;
  alpha_in = es[e_n].alpha;
  beta_in = es[e_n].beta;
 }
window_examples = gtk_window_new (GTK_WINDOW_TOPLEVEL);
gtk_window_set_title (GTK_WINDOW (window_examples), "Examples");
if (is_smallscr==0) gtk_window_set_default_size (GTK_WINDOW (window_examples), 384, 600); else
gtk_window_set_default_size (GTK_WINDOW (window_examples), 384, 400);
/* vbox_examples */
vbox_examples = gtk_vbox_new (FALSE, 0);
gtk_widget_show (vbox_examples);
gtk_container_add (GTK_CONTAINER (window_examples), vbox_examples);
/***************** textview           */
scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
gtk_widget_show (scrolledwindow);
gtk_box_pack_start (GTK_BOX (vbox_examples), scrolledwindow, TRUE, TRUE, 0);
textview_examples = gtk_text_view_new ();
gtk_widget_show (textview_examples);
gtk_container_add (GTK_CONTAINER (scrolledwindow), textview_examples);
gtk_text_view_set_editable (GTK_TEXT_VIEW (textview_examples), FALSE);
gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (textview_examples), GTK_WRAP_WORD);
gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textview_examples), FALSE);
gtk_text_view_set_indent (GTK_TEXT_VIEW (textview_examples), 6);
/* insert example description */
buffer_e = (GtkTextBuffer *) gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview_examples));
gtk_text_buffer_set_text(buffer_e,"\n\t\t",-1);
gtk_text_buffer_get_end_iter(buffer_e,&enditerm);
gtk_text_buffer_insert(buffer_e,&enditerm,es[e_n].name,-1);
gtk_text_buffer_get_end_iter(buffer_e,&enditerm);
gtk_text_buffer_insert(buffer_e,&enditerm,"\n\n",-1);
gtk_text_buffer_get_end_iter(buffer_e,&enditerm);
gtk_text_buffer_insert(buffer_e,&enditerm,es[e_n].descr1,-1);
gtk_text_buffer_get_end_iter(buffer_e,&enditerm);
gtk_text_buffer_insert(buffer_e,&enditerm,es[e_n].descr2,-1);
gtk_text_buffer_get_end_iter(buffer_e,&enditerm);
gtk_text_buffer_insert(buffer_e,&enditerm,es[e_n].descr3,-1);
gtk_text_buffer_get_end_iter(buffer_e,&enditerm);
gtk_text_buffer_insert(buffer_e,&enditerm,es[e_n].descr4,-1);
gtk_text_buffer_get_end_iter(buffer_e,&enditerm);
gtk_text_buffer_insert(buffer_e,&enditerm,es[e_n].descr5,-1);
/***************** textview ends here */

/**************** toolbar  - quit, OK, dimension setup  */
toolbar_examples = gtk_toolbar_new ();
gtk_widget_show (toolbar_examples);
gtk_box_pack_start (GTK_BOX (vbox_examples), toolbar_examples, FALSE, FALSE, 0);
gtk_container_set_border_width (GTK_CONTAINER (toolbar_examples), 18);
gtk_toolbar_set_style (GTK_TOOLBAR (toolbar_examples), GTK_TOOLBAR_BOTH);

/* cancel button */
tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-cancel", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar_examples)));
button_quit_examples = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar_examples),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Cancel",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
/* something not working: no use_underline in no way ??? */
gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar_examples)->children)->data))->label), TRUE);
gtk_button_set_use_underline (GTK_BUTTON(button_quit_examples),TRUE);
gtk_widget_show(button_quit_examples);

/* dimension_box with label and dimensions entries */
hbox = gtk_hbox_new(TRUE,0);
gtk_box_set_homogeneous (GTK_BOX(hbox),FALSE);

howmany_a_label =gtk_label_new ("   A: ");
gtk_widget_show (howmany_a_label);
gtk_box_pack_start (GTK_BOX (hbox), howmany_a_label, FALSE, FALSE, 0);

howmany_a_entry = gtk_entry_new_with_max_length (6);
gtk_entry_set_width_chars (GTK_ENTRY(howmany_a_entry),6);
sprintf(howmany_a_out,"%d",matrix_a_num);
gtk_entry_set_text(GTK_ENTRY(howmany_a_entry), howmany_a_out);
if (es[e_n].is_matrix_variable == 1) {
               gtk_entry_set_editable (GTK_ENTRY(howmany_a_entry),FALSE);
	       gtk_widget_set_sensitive(howmany_a_entry,FALSE); /* do nothing ?? just gray ??*/
               }
gtk_widget_show (howmany_a_entry);
gtk_box_pack_start (GTK_BOX (hbox), howmany_a_entry, FALSE, FALSE, 0);

dimension_m_label =gtk_label_new (" blocks of size =");
gtk_widget_show (dimension_m_label);
gtk_box_pack_start (GTK_BOX (hbox), dimension_m_label, FALSE, FALSE, 0);

dimension_m_entry = gtk_entry_new_with_max_length (6);
gtk_entry_set_width_chars (GTK_ENTRY(dimension_m_entry),6);
sprintf(dimension_m_out,"%d",dimension_m);
gtk_entry_set_text(GTK_ENTRY(dimension_m_entry), dimension_m_out);
if (es[e_n].is_dim_variable == 1) {
		gtk_entry_set_editable (GTK_ENTRY(dimension_m_entry),FALSE);
		gtk_widget_set_sensitive(dimension_m_entry,FALSE); /* do nothing ??*/
		}
gtk_widget_show (dimension_m_entry);
gtk_box_pack_start (GTK_BOX (hbox), dimension_m_entry, FALSE, FALSE, 0);


dimension_n_label =gtk_label_new ("     B0 size =");
gtk_widget_show (dimension_n_label);
gtk_box_pack_start (GTK_BOX (hbox), dimension_n_label, FALSE, FALSE, 0);
dimension_n_entry = gtk_entry_new_with_max_length (6);
gtk_entry_set_width_chars (GTK_ENTRY(dimension_n_entry),6);
sprintf(dimension_n_out,"%d",dimension_n);
gtk_entry_set_text(GTK_ENTRY(dimension_n_entry), dimension_n_out);
if ((es[e_n].is_m_equal_n == 0)||(es[e_n].is_dim_variable == 1)) {
           gtk_entry_set_editable (GTK_ENTRY(dimension_n_entry),FALSE);
           gtk_widget_set_sensitive(dimension_n_entry,FALSE); /* do nothing ?? just gray ??*/
           }
gtk_widget_show (dimension_n_entry);
gtk_box_pack_start (GTK_BOX (hbox), dimension_n_entry, FALSE, FALSE, 0);

dimension_space_label =gtk_label_new ("  ");
gtk_widget_show (dimension_space_label);
gtk_box_pack_start (GTK_BOX (hbox), dimension_space_label, FALSE, FALSE, 0);

howmany_b_label =gtk_label_new (" number of B blocks = ");
gtk_widget_show (howmany_b_label);
gtk_box_pack_start (GTK_BOX (hbox), howmany_b_label, FALSE, FALSE, 0);
howmany_b_entry = gtk_entry_new_with_max_length (6);
gtk_entry_set_width_chars (GTK_ENTRY(howmany_b_entry),6);
sprintf(howmany_b_out,"%d",matrix_b_num);
gtk_entry_set_text(GTK_ENTRY(howmany_b_entry), howmany_b_out);
if (es[e_n].is_matrix_variable == 1) {
		gtk_entry_set_editable (GTK_ENTRY(howmany_b_entry),FALSE);
		gtk_widget_set_sensitive(howmany_b_entry,FALSE); /* do nothing ?? just gray ??*/
		}
gtk_widget_show (howmany_b_entry);
gtk_box_pack_start (GTK_BOX (hbox), howmany_b_entry, FALSE, FALSE, 0);



if(es[e_n].is_alpha==1) {
/*
        if(alpha_in ==0) {alpha_in_mant=0; alpha_in_exp=0;}
        if(alpha_in > 0) {alpha_in_exp=floor(log10(alpha_in)); alpha_in_mant=alpha_in/pow(10.0E0,alpha_in_exp);}
        if(alpha_in < 0) {alpha_in_exp=floor(log10(-alpha_in)); alpha_in_mant=alpha_in/pow(10.E0,alpha_in_exp);}
*/
        alpha_label = gtk_label_new ("  alpha =");
        gtk_widget_show (alpha_label);
        gtk_box_pack_start (GTK_BOX (hbox), alpha_label, FALSE, FALSE, 0);
alpha_entry =gtk_entry_new_with_max_length (10);
gtk_entry_set_width_chars (GTK_ENTRY(alpha_entry),13);
sprintf(buf,"%.4E",alpha_in);
gtk_entry_set_text(GTK_ENTRY(alpha_entry),buf);
/*
        alpha_adj = gtk_adjustment_new ((gdouble)alpha_in_mant,(gdouble)-9.999999,(gdouble)9.999999,(gdouble)0.000001,(gdouble)0.001,(gdouble)0.5);
        alpha_entry = gtk_spin_button_new (GTK_ADJUSTMENT(alpha_adj),(gdouble)0.1,6);
        gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(alpha_entry),TRUE);
*/
        gtk_widget_show(alpha_entry);
        gtk_box_pack_start (GTK_BOX (hbox), alpha_entry, FALSE, FALSE, 0);
/*        alpha_e_label = gtk_label_new ("E");
        gtk_widget_show (alpha_e_label);
        gtk_box_pack_start (GTK_BOX (hbox), alpha_e_label, FALSE, FALSE, 0);
        alpha_e_adj = gtk_adjustment_new ((gdouble)alpha_in_exp,(gdouble)-16,(gdouble)16,(gdouble)1,(gdouble)1,(gdouble)1);
        alpha_e_entry = gtk_spin_button_new (GTK_ADJUSTMENT(alpha_e_adj),(gdouble)1,0);
        gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(alpha_e_entry),TRUE);
        gtk_widget_show(alpha_e_entry);
        gtk_box_pack_start (GTK_BOX (hbox), alpha_e_entry, FALSE, FALSE, 0);
*/
        }
if(es[e_n].is_beta==1) {
/*
        if(beta_in ==0) {beta_in_mant=0; beta_in_exp=0;}
        if(beta_in > 0) {beta_in_exp=floor(log10(beta_in)); beta_in_mant=beta_in/pow(10.0E0,beta_in_exp);}
        if(beta_in < 0) {beta_in_exp=floor(log10(-beta_in)); beta_in_mant=beta_in/pow(10.E0,beta_in_exp);}
*/
        beta_label = gtk_label_new ("   beta =");
        gtk_widget_show (beta_label);
        gtk_box_pack_start (GTK_BOX (hbox), beta_label, FALSE, FALSE, 0);
beta_entry =gtk_entry_new_with_max_length (10);
gtk_entry_set_width_chars (GTK_ENTRY(beta_entry),13);
sprintf(buf,"%.4E",beta_in);
gtk_entry_set_text(GTK_ENTRY(beta_entry),buf);
/*
        beta_adj = gtk_adjustment_new ((gdouble)beta_in_mant,(gdouble)-9.999999,(gdouble)9.999999,(gdouble)0.000001,(gdouble)0.001,(gdouble)0.5);
        beta_entry = gtk_spin_button_new (GTK_ADJUSTMENT(beta_adj),(gdouble)0.1,6);
        gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(beta_entry),TRUE);
*/

        gtk_widget_show(beta_entry);
        gtk_box_pack_start (GTK_BOX (hbox), beta_entry, FALSE, FALSE, 0);
/*        beta_e_label = gtk_label_new ("E");
        gtk_widget_show (beta_e_label);
        gtk_box_pack_start (GTK_BOX (hbox), beta_e_label, FALSE, FALSE, 0);
        beta_e_adj = gtk_adjustment_new ((gdouble)beta_in_exp,(gdouble)-16,(gdouble)16,(gdouble)1,(gdouble)1,(gdouble)1);
        beta_e_entry = gtk_spin_button_new (GTK_ADJUSTMENT(beta_e_adj),(gdouble)1,0);
        gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(beta_e_entry),TRUE);
        gtk_widget_show(beta_e_entry);
        gtk_box_pack_start (GTK_BOX (hbox), beta_e_entry, FALSE, FALSE, 0);
*/
        }
howmany_space_label =gtk_label_new ("  ");
gtk_widget_show (howmany_space_label);
gtk_box_pack_start (GTK_BOX (hbox), howmany_space_label, FALSE, FALSE, 0);

hbox_box = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar_examples),
                                GTK_TOOLBAR_CHILD_WIDGET,
                                hbox,
                                "",
                                NULL, NULL,
                                NULL, NULL, NULL);
gtk_widget_show (hbox_box);

/* ok button */
tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-ok", gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar_examples)));
button_ok_examples = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar_examples),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "OK",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
/* something not working: no use_underline in no way ??? */
gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (toolbar_examples)->children)->data))->label), TRUE);
gtk_button_set_use_underline (GTK_BUTTON(button_ok_examples),TRUE);
gtk_widget_show(button_ok_examples);
/**************** statusbar       */
statusb_examples = gtk_statusbar_new();
gtk_widget_show (statusb_examples);
gtk_box_pack_start (GTK_BOX (vbox_examples), statusb_examples, FALSE, FALSE, 0);
gtk_statusbar_push(GTK_STATUSBAR(statusb_examples),0,"           Finalize changes to Floating Point Numerical Entries with the ENTER key of the kbd");

/**************** connect signals for this window ****************/
g_signal_connect ((gpointer) button_quit_examples, "clicked", G_CALLBACK(on_examples_quit_activate),NULL);
g_signal_connect ((gpointer) button_ok_examples, "clicked", G_CALLBACK(on_examples_ok_activate),NULL);
g_signal_connect ((gpointer) dimension_m_entry, "changed", G_CALLBACK (on_dimension_m_entry_changed), NULL);
g_signal_connect ((gpointer) dimension_n_entry, "changed", G_CALLBACK (on_dimension_n_entry_changed), NULL);
g_signal_connect ((gpointer) howmany_a_entry, "changed", G_CALLBACK (on_array_n_entry_changed), NULL);
g_signal_connect ((gpointer) howmany_b_entry, "changed", G_CALLBACK (on_blocks_n_entry_changed), NULL);
g_signal_connect ((gpointer) dimension_m_entry, "activate", G_CALLBACK (on_examples_ok_activate), NULL);
g_signal_connect ((gpointer) dimension_n_entry, "activate", G_CALLBACK (on_examples_ok_activate), NULL);
g_signal_connect ((gpointer) window_examples, "destroy", G_CALLBACK (on_examples_destroy_activate),NULL);
if(es[e_n].is_alpha==1) {
    g_signal_connect ((gpointer) alpha_entry , "activate", G_CALLBACK (on_examples_alpha_activate),NULL);
/*
    g_signal_connect ((gpointer) alpha_entry , "changed", G_CALLBACK (on_examples_alpha_change),NULL);
    g_signal_connect ((gpointer) alpha_e_entry , "changed", G_CALLBACK (on_examples_alpha_e_change),NULL);
*/
   }
if(es[e_n].is_beta==1) {
    g_signal_connect ((gpointer) beta_entry , "activate", G_CALLBACK (on_examples_beta_activate),NULL);
/*
    g_signal_connect ((gpointer) beta_entry , "changed", G_CALLBACK (on_examples_beta_change),NULL);
    g_signal_connect ((gpointer) beta_e_entry , "changed", G_CALLBACK (on_examples_beta_e_change),NULL);
*/
   }
/* show this window */
gtk_widget_show(window_examples);

return window_examples;
}
/*********************************/

/* Parameters Window */
GtkWidget*
create_window_parameters(int alg)
{
int i; 
/* GtkWidget * window_parameters; global */
GtkWidget * vbox,*hseparator, *hbox,*vbox_itermax,*vbox_interpmax,*vbox_errmax;
GtkWidget *ok_button,*cancel_button,*reset_button;
/* GtkWidget  *parameters_entry_itermax,*parameters_entry_interpmax,*parameters_entry_errmax; globals */
GtkWidget *label_name_alg, *label_itermax,*label_interpmax,*label_errmax;
GtkWidget *combo_interp,*combo_err;
GList *items_iter,*items_interp,*items_err;
char buf_iter[256],buf_interp[256],buf_err[256];
char buf_iterv[256];
items_iter=NULL;
items_interp=NULL;
items_err=NULL;

window_parameters = gtk_dialog_new();
gtk_container_set_border_width (GTK_CONTAINER (window_parameters), 10);
gtk_window_set_title (GTK_WINDOW (window_parameters), "Algorithm Parameters Setup");
gtk_window_set_transient_for (GTK_WINDOW (window_parameters),GTK_WINDOW (window_main));
gtk_window_set_position (GTK_WINDOW (window_parameters), GTK_WIN_POS_CENTER_ON_PARENT);
gtk_window_set_resizable (GTK_WINDOW (window_parameters), FALSE);
gtk_window_set_modal(GTK_WINDOW (window_parameters),TRUE);
vbox = GTK_DIALOG (window_parameters)->vbox;
gtk_widget_show (vbox);

cancel_button = gtk_button_new_from_stock ("gtk-close");
gtk_widget_show (cancel_button);
gtk_dialog_add_action_widget (GTK_DIALOG (window_parameters), cancel_button, GTK_RESPONSE_CLOSE);

ok_button  = gtk_button_new_from_stock ("gtk-ok");
gtk_widget_show (ok_button);
gtk_dialog_add_action_widget (GTK_DIALOG (window_parameters), ok_button,GTK_RESPONSE_CLOSE);

reset_button = gtk_button_new_with_label("RESET TO THE\nDEFAULT VALUE");
gtk_widget_show (reset_button);
gtk_dialog_add_action_widget (GTK_DIALOG (window_parameters), reset_button, GTK_RESPONSE_CLOSE);

gtk_button_box_set_layout (GTK_BUTTON_BOX (GTK_DIALOG (window_parameters)->action_area), GTK_BUTTONBOX_SPREAD);

hseparator = gtk_hseparator_new ();
gtk_widget_show(hseparator);
hbox=gtk_hbox_new(TRUE,0);
gtk_widget_show(hbox);
switch(alg) {
case 1: /* Cyclic Reduction */
	label_name_alg = gtk_label_new("Cyclic Reduction Parameters Setup\n");
        break;
case 2: /* Logarithmic Reduction */
        label_name_alg = gtk_label_new("Logarithmic Reduction Parameters Setup\n");
        break;
case 3: /* Functional Iteration */
        label_name_alg = gtk_label_new("Functional Iteration Parameters Setup\n");
        break;
case 4: /* Invariant Subspace */
        label_name_alg = gtk_label_new("Invariant Subspace Parameters Setup\n");
        break;
case 5: /* Newton Iteration */
	label_name_alg = gtk_label_new("Newton Iteration Parameters Setup\n");
        break;
	
default: /* something wrong here ...*/
       label_name_alg = gtk_label_new("BUG !!!\n");
 if(is_debug==1) printf("create_window_parameters: alg number wrong (%d)\n",alg);
	}
	gtk_widget_show (label_name_alg);
        gtk_box_pack_start (GTK_BOX (vbox), label_name_alg, FALSE, FALSE, 0);
        gtk_box_pack_start (GTK_BOX (vbox), hseparator,FALSE, FALSE, 0); 
	gtk_box_pack_start (GTK_BOX (vbox), hbox,FALSE, FALSE, 0);
        vbox_itermax = gtk_vbox_new(TRUE,0);
        vbox_interpmax = gtk_vbox_new(TRUE,0);
        vbox_errmax = gtk_vbox_new(TRUE,0);
        gtk_widget_show(vbox_itermax);
        gtk_widget_show(vbox_interpmax); 
        gtk_widget_show(vbox_errmax);
        gtk_box_pack_start (GTK_BOX (hbox), vbox_itermax, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), vbox_interpmax, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), vbox_errmax , FALSE, FALSE, 0);
        /*gtk_combo_disable_activate (GTK_COMBO (combotest)); */
        sprintf(buf_iter,"Max #\niterations \n(%d..%d..%d)",min[alg].iterat,deflt[alg].iterat,max[alg].iterat); 
        label_itermax = gtk_label_new(buf_iter);
        gtk_widget_show (label_itermax);
	gtk_box_pack_start (GTK_BOX (vbox_itermax), label_itermax, FALSE, FALSE, 0);
        parameters_entry_itermax =  gtk_entry_new_with_max_length (9);
        gtk_entry_set_width_chars (GTK_ENTRY(parameters_entry_itermax),9);
        sprintf(buf_iterv,"%d",choice[alg].iterat);
        gtk_entry_set_text(GTK_ENTRY(parameters_entry_itermax), buf_iterv);
        gtk_widget_show (parameters_entry_itermax);
        gtk_box_pack_start (GTK_BOX (vbox_itermax), parameters_entry_itermax, FALSE, FALSE, 0);
        sprintf(buf_interp,"Max #\ninterpolations\n(M/G/1 , GI/M/1)");
        label_interpmax = gtk_label_new(buf_interp);
if ((alg ==1))        gtk_widget_show (label_interpmax);
        gtk_box_pack_start (GTK_BOX (vbox_interpmax), label_interpmax, FALSE, FALSE, 0);
	combo_interp = gtk_combo_new ();
if ((alg ==1))        gtk_widget_show(combo_interp);
        for(i=0;i<9;i++) items_interp = g_list_append (items_interp, param_interp_str[i]);
        gtk_combo_set_popdown_strings (GTK_COMBO (combo_interp), items_interp);
        parameters_entry_interpmax = (GTK_COMBO (combo_interp))->entry; 
        gtk_entry_set_width_chars (GTK_ENTRY(parameters_entry_interpmax),9);
        gtk_entry_set_text (GTK_ENTRY(parameters_entry_interpmax),param_interp_str[choice[alg].interp]);
        gtk_entry_set_editable(GTK_ENTRY(parameters_entry_interpmax), FALSE);
	gtk_box_pack_start (GTK_BOX (vbox_interpmax),combo_interp,FALSE, FALSE, 0);
	sprintf(buf_err,"Max\nerror\nsize"); 
        label_errmax = gtk_label_new(buf_err);
        gtk_widget_show (label_errmax);
        gtk_box_pack_start (GTK_BOX (vbox_errmax), label_errmax, FALSE, FALSE, 0);
	combo_err = gtk_combo_new ();
        gtk_widget_show(combo_err);
        for(i=0;i<12;i++) items_err = g_list_append (items_err, param_err_str[i]);
        gtk_combo_set_popdown_strings (GTK_COMBO (combo_err), items_err);
        parameters_entry_errmax = (GTK_COMBO (combo_err))->entry;
        gtk_entry_set_width_chars (GTK_ENTRY(parameters_entry_errmax),9);
        gtk_entry_set_text (GTK_ENTRY(parameters_entry_errmax),param_err_str[choice[alg].err]);
        gtk_entry_set_editable(GTK_ENTRY(parameters_entry_errmax), FALSE);
        gtk_box_pack_start (GTK_BOX (vbox_errmax),combo_err,FALSE, FALSE, 0);
        g_signal_connect((gpointer)parameters_entry_itermax,"changed",G_CALLBACK(on_parameters_entry_itermax_changed),(gpointer)alg);
if((alg==1)) g_signal_connect((gpointer)(GTK_COMBO(combo_interp))->entry,"changed",G_CALLBACK(on_parameters_entry_interpmax_changed),(gpointer)alg);
        g_signal_connect((gpointer)(GTK_COMBO(combo_err))->entry,"changed",G_CALLBACK(on_parameters_entry_errmax_changed),(gpointer)alg);
/*        
        sprintf(bufinterp,"Maxmum number of interpolations allowed\n(%d..%d   default  %d)",max[alg].interp, min[alg].interp,deflt[alg].interp);
 	label_interpmax = gtk_label_new(bufinterp);
        gtk_widget_show (label_interpmax);
        gtk_box_pack_start (GTK_BOX (vbox_interpmax), label_interpmax, FALSE, FALSE, 0);
        parameters_entry_interpmax =  gtk_entry_new_with_max_length (6);
        gtk_entry_set_width_chars (GTK_ENTRY(parameters_entry_interpmax),6);
	sprintf(bufinterpv,"%d",choice[alg].interp);
        gtk_entry_set_text(GTK_ENTRY(parameters_entry_interpmax), bufinterpv);
        gtk_widget_show (parameters_entry_interpmax);
	gtk_box_pack_start (GTK_BOX (vbox_interpmax),parameters_entry_interpmax,FALSE, FALSE, 0);
        sprintf(buferr,"Maximum error allowed \n(epsilon*E-%d..%d default  %d)",max[alg].err, min[alg].err,deflt[alg].err); 
        label_errmax = gtk_label_new(buferr);
        gtk_widget_show (label_errmax);
        gtk_box_pack_start (GTK_BOX (vbox_errmax), label_errmax, FALSE, FALSE, 0);
        parameters_entry_errmax = gtk_entry_new_with_max_length (6);
        gtk_entry_set_width_chars (GTK_ENTRY(parameters_entry_errmax),6);
        sprintf(buferrv,"%d",choice[alg].err);
        gtk_entry_set_text(GTK_ENTRY(parameters_entry_errmax), buferrv);
	gtk_widget_show (parameters_entry_errmax);
        gtk_box_pack_start (GTK_BOX (vbox_errmax),parameters_entry_errmax,FALSE, FALSE, 0);
*/
g_signal_connect ((gpointer) window_parameters, "destroy", G_CALLBACK (on_parameters_destroy_activate),NULL);
g_signal_connect ((gpointer) cancel_button , "clicked", G_CALLBACK (on_parameters_quit_activate), NULL);
g_signal_connect ((gpointer) ok_button , "clicked", G_CALLBACK (on_parameters_ok_activate), (gpointer)alg);
g_signal_connect ((gpointer) reset_button , "clicked", G_CALLBACK (on_parameters_reset_activate),(gpointer)alg);
/*g_signal_connect ((gpointer) parameters_entry_itermax, "changed", G_CALLBACK (on_parameters_entry_itermax_changed), NULL);
g_signal_connect ((gpointer) parameters_entry_interpmax, "changed", G_CALLBACK (on_parameters_entry_interpmax_changed), NULL);
g_signal_connect ((gpointer) parameters_entry_errmax, "changed", G_CALLBACK (on_parameters_entry_errmax_changed), NULL);
g_signal_connect ((gpointer) (GTK_COMBO (combotest))->entry,"changed", G_CALLBACK (on_parameters_entry_itermax_changed), NULL);
*/
gtk_widget_show(window_parameters);

return(window_parameters);
}
/*********************************/

/* Pi Parameters Window */
GtkWidget*
create_window_pi_parameters(void)
{
int i;
/* GtkWidget * window_pi_parameters; global */
GtkWidget * vbox,*hseparator, *hbox,*vbox_maxnc,*vbox_epspi;
GtkWidget *ok_button,*cancel_button,*reset_button;
/* GtkWidget  *parameters_entry_maxnc,*parameters_entry_epspi; globals */
GtkWidget *label_title, *label_maxnc,*label_epspi;
GtkWidget *combo_epspi;
GList *items_epspi;
char buf_maxnc[256], buf_epspi[256];

window_pi_parameters = gtk_dialog_new();
gtk_container_set_border_width (GTK_CONTAINER (window_pi_parameters), 10);
gtk_window_set_title (GTK_WINDOW (window_pi_parameters), "Pi Parameters Setup");
gtk_window_set_transient_for (GTK_WINDOW (window_pi_parameters),GTK_WINDOW (window_main));
gtk_window_set_position (GTK_WINDOW (window_pi_parameters), GTK_WIN_POS_CENTER_ON_PARENT);
gtk_window_set_resizable (GTK_WINDOW (window_pi_parameters), FALSE);
gtk_window_set_modal(GTK_WINDOW (window_pi_parameters),TRUE);
vbox = GTK_DIALOG (window_pi_parameters)->vbox;
gtk_widget_show (vbox);
cancel_button = gtk_button_new_from_stock ("gtk-close");
gtk_widget_show (cancel_button);
gtk_dialog_add_action_widget (GTK_DIALOG (window_pi_parameters), cancel_button, GTK_RESPONSE_CLOSE);

ok_button  = gtk_button_new_from_stock ("gtk-ok");
gtk_widget_show (ok_button);
gtk_dialog_add_action_widget (GTK_DIALOG (window_pi_parameters), ok_button,GTK_RESPONSE_CLOSE);

reset_button = gtk_button_new_with_label("RESET TO THE\nDEFAULT VALUE");
gtk_widget_show (reset_button);
gtk_dialog_add_action_widget (GTK_DIALOG (window_pi_parameters), reset_button, GTK_RESPONSE_CLOSE);

gtk_button_box_set_layout (GTK_BUTTON_BOX (GTK_DIALOG (window_pi_parameters)->action_area), GTK_BUTTONBOX_SPREAD);

hseparator = gtk_hseparator_new ();
gtk_widget_show(hseparator);
hbox=gtk_hbox_new(TRUE,0);
gtk_widget_show(hbox);
label_title = gtk_label_new("Pi Length Setup\n");
gtk_widget_show (label_title);
gtk_box_pack_start (GTK_BOX (vbox), label_title, FALSE, FALSE, 0);
gtk_box_pack_start (GTK_BOX (vbox), hseparator,FALSE, FALSE, 0); 
gtk_box_pack_start (GTK_BOX (vbox), hbox,FALSE, FALSE, 0);
vbox_maxnc = gtk_vbox_new(TRUE,0);
vbox_epspi = gtk_vbox_new(TRUE,0);
gtk_widget_show(vbox_maxnc);
gtk_widget_show(vbox_epspi);
gtk_box_pack_start (GTK_BOX (hbox), vbox_maxnc, FALSE, FALSE, 0);
gtk_box_pack_start (GTK_BOX (hbox), vbox_epspi , FALSE, FALSE, 0);
sprintf(buf_maxnc,"Max Length\n(%d...%d)",pi_min.maxnc,pi_max.maxnc);
label_maxnc = gtk_label_new(buf_maxnc);
gtk_widget_show (label_maxnc);
gtk_box_pack_start (GTK_BOX (vbox_maxnc), label_maxnc, FALSE, FALSE, 0);
parameters_entry_maxnc =  gtk_entry_new_with_max_length (9);
gtk_entry_set_width_chars (GTK_ENTRY(parameters_entry_maxnc),9);
sprintf(buf_maxnc,"%d",pi_choice.maxnc); 
gtk_entry_set_text(GTK_ENTRY(parameters_entry_maxnc), buf_maxnc);

gtk_box_pack_start (GTK_BOX (vbox_maxnc), parameters_entry_maxnc, FALSE, FALSE, 0);
gtk_widget_show (parameters_entry_maxnc);
sprintf(buf_epspi,"Ignore Tail when less than\n");
label_epspi = gtk_label_new(buf_epspi);
gtk_widget_show (label_epspi);
gtk_box_pack_start (GTK_BOX (vbox_epspi), label_epspi, FALSE, FALSE, 0);
combo_epspi = gtk_combo_new ();
gtk_widget_show(combo_epspi);
items_epspi=NULL;
for(i=0;i<12;i++) items_epspi = g_list_append (items_epspi, param_err_str[i]);
gtk_combo_set_popdown_strings (GTK_COMBO (combo_epspi), items_epspi);
parameters_entry_epspi = (GTK_COMBO (combo_epspi))->entry;
gtk_entry_set_width_chars (GTK_ENTRY(parameters_entry_epspi),9);
gtk_entry_set_text (GTK_ENTRY(parameters_entry_epspi),param_err_str[pi_choice.eps]);
gtk_entry_set_editable(GTK_ENTRY(parameters_entry_epspi), FALSE);
gtk_box_pack_start (GTK_BOX (vbox_epspi),combo_epspi,FALSE, FALSE, 0);


g_signal_connect ((gpointer) window_pi_parameters, "destroy", G_CALLBACK (on_pi_parameters_destroy_activate),NULL);
g_signal_connect ((gpointer) cancel_button , "clicked", G_CALLBACK (on_pi_parameters_quit_activate), NULL);
g_signal_connect ((gpointer) ok_button , "clicked", G_CALLBACK (on_pi_parameters_ok_activate), NULL);
g_signal_connect ((gpointer) reset_button , "clicked", G_CALLBACK (on_pi_parameters_reset_activate),NULL);
g_signal_connect ((gpointer) parameters_entry_maxnc, "changed", G_CALLBACK (on_parameters_entry_maxnc_changed), NULL);
g_signal_connect ((gpointer) parameters_entry_epspi, "changed", G_CALLBACK (on_parameters_entry_epspi_changed), NULL);

gtk_widget_show(window_pi_parameters);
return window_pi_parameters;
}
/*********************************/
