!=========================================================================!
! file fft_int.f90                                                        !
!=========================================================================!
!      IMPROVED CYCLIC REDUCTION FOR SOLVING QUEUEING PROBLEMS            !
!                     by D.A. Bini and B. Meini                           !
!               (bini@dm.unipi.it    meini@dm.unipi.it)                   !
!          Fortran 90 Program version 1.0, January 30 1997                !
!                 Interface File for FFT subroutines                      !
!=========================================================================!
!  Interface file for the following FFT subroutines:                      !
!     iffts1                                                              !
!     ffts2                                                               !
!     iffts2                                                              !
!     ffts1                                                               !
!     fillroots                                                           !
!     fft1                                                                !
!     ifft1                                                               !
!     ftb1                                                                !
!     ftb2                                                                !
!     iftb2                                                               !
!     iftb1                                                               !
!     twiddle                                                             !
!     itwiddle                                                            !
!=========================================================================
!  Included in                                                            !
!  Structured Markov Chains Solver      [  SMCSolver  ]                   !
!  Version 2.1 - June  2009                                               !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
MODULE fft_interface
  INTERFACE 
     SUBROUTINE iffts1(u,v)
       REAL(KIND(0.d0)),DIMENSION(:)  :: u, v
     END SUBROUTINE iffts1
  END INTERFACE
  !=================================================================

  INTERFACE
     SUBROUTINE ffts2(u,v)
       REAL(KIND(0.d0)),DIMENSION(:)  :: u, v
     END SUBROUTINE ffts2
  END INTERFACE
  !=================================================================

  INTERFACE
     SUBROUTINE iffts2(u,v,t)
       REAL(KIND(0.d0)),DIMENSION(:)  :: u, v,t
     END SUBROUTINE iffts2
  END INTERFACE
  !=================================================================

  INTERFACE
     SUBROUTINE ffts1(u,v)
       REAL(KIND(0.d0)),DIMENSION(:) :: u, v
     END SUBROUTINE ffts1
  END INTERFACE
  !=================================================================

  INTERFACE
     SUBROUTINE fillroots(n)
       INTEGER :: n
     END SUBROUTINE fillroots
  END INTERFACE
  !=================================================================

  INTERFACE
     SUBROUTINE fft1(x,y)
       REAL(KIND(0.d0)),DIMENSION(:)  :: x,y
     END SUBROUTINE FFT1
  END INTERFACE
  !=================================================================

  INTERFACE
     SUBROUTINE ifft1(x,y)
       REAL(KIND(0.d0)),DIMENSION(:)  :: x,y
     END SUBROUTINE ifft1
  END INTERFACE
  !=================================================

  INTERFACE
     SUBROUTINE ftb1(a,ta)
       REAL(KIND(0.d0)),DIMENSION(:,:,:) :: a, ta
     END SUBROUTINE ftb1
  END INTERFACE
  !=====================================================

  INTERFACE
     SUBROUTINE ftb2(a,ta)
       REAL(KIND(0.d0)),DIMENSION(:,:,:) :: a, ta
     END SUBROUTINE ftb2
  END INTERFACE
  !=====================================================

  INTERFACE
     SUBROUTINE iftb2(ta,a)
       REAL(KIND(0.d0)),DIMENSION(:,:,:) :: ta
       REAL(KIND(0.d0)),DIMENSION(:,:,:),allocatable :: a
     END SUBROUTINE iftb2
  END INTERFACE
  !=====================================================

  INTERFACE
     SUBROUTINE iftb1(ta,a)
       REAL(KIND(0.d0)),DIMENSION(:,:,:) :: a, ta
     END SUBROUTINE iftb1
  END INTERFACE
  !=====================================================

  INTERFACE
     SUBROUTINE twiddle(zr,zi)
       REAL(KIND(0.d0)),DIMENSION(:)  :: zr,zi
     END SUBROUTINE twiddle
  END INTERFACE
  !===================================================

  INTERFACE
     SUBROUTINE itwiddle(zr,zi)
       REAL(KIND(0.d0)),DIMENSION(:)  :: zr, zi
     END SUBROUTINE itwiddle
  END INTERFACE

END MODULE fft_interface

module roots
real(kind(0.d0)),dimension(:),allocatable::wr,wi,wwr,wwi
end module roots
