/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 1.2 - Nov 2006                                     *
 **************************************************************
 *
 *  view_mat.h - view and compare  G,R  - both callbacks and interfaces
 *
 */

/*prototypes view_mat.h */
void create_view_window(void);
void on_view_menu_quit_activate   (GtkMenuItem  *, gpointer );
void on_view_destroy_activate (GtkWidget  *, gpointer );
gboolean draw_view_area_callback (GtkWidget *, GdkEventExpose *, gpointer );
gboolean xy_view_area (GtkWidget *, GdkEventExpose *, gpointer );
gboolean button_press_view_area (GtkWidget *, GdkEventExpose *, gpointer );
void on_view_pos_neg_activate(GtkButton *, gpointer );
void on_view_color_activate(GtkButton *, gpointer);
void on_view_enhance_activate(GtkButton *, gpointer);
void on_view_contrast_changed(GtkEntry *, gpointer );
void on_view_user_activate(GtkButton *, gpointer);
void on_view_range_normal_activate(GtkButton *, gpointer);
void on_view_range_matrix_activate(GtkButton *, gpointer);
void on_view_range_adaptive_activate(GtkButton *, gpointer);
void on_view_g_activate(GtkButton *, gpointer);
void on_view_r_activate(GtkButton *, gpointer);
void on_view_u_activate(GtkButton *, gpointer);
void on_view_file_activate(GtkButton *, gpointer);
void on_view_test_activate(GtkButton *, gpointer);
void on_view_compare_activate(GtkButton *, gpointer);
void view_gray_levels_setup(double); /* setup of  gray_levels */
void view_recompute_levels(double);
int  view_get_gray_level(double); 
void view_image_compute(void );
void draw_view_area(void);
int view_labels_update(void);
int view_status_update(void);
void max_min_view_compute(void);
GtkWidget* create_fileselection_read_matrix(void);
void on_ok_button_fsread_matrix_clicked      (GtkButton *, gpointer);
void on_cancel_button_fsread_matrix_clicked   (GtkButton *, gpointer);
void on_destroy_fsread_matrix (GtkWidget  *, gpointer );
double view_get_data(int ,int );
void view_fallback(void);

/* prototipes ponte.f90 */
void read_matg_(int *,int *, double *);
void read_matr_(int *,int *, double *);
void read_matu_(int *,int *, double *);

/* prototypes rw.c */
int watch_for_number(int , int , char *);
GtkWidget* create_dialog_noreadable(GtkWidget*);
void pathstripper(char *, char *);
GtkWidget* create_dialog_data_noreadable(GtkWidget* ,char * );

/* prototypes callback.h */
gboolean on_delete_event_do   (GtkWidget *, GdkEvent *, gpointer);

/* globals view_mat.c */
GtkWidget * window_view;
GtkWidget  *view_area;
GtkWidget *label_v212,*label_v222, *label_v231, *label_v232; 
GtkWidget *view_label_space; 
GtkWidget *view_label_user;
GtkWidget   *view_entry_ij; 
GtkWidget   *view_entry_aij;
GtkWidget   *view_entry2_ij; 
GtkWidget   *view_entry2_aij; 
GtkWidget *view_vbox12,*view_vbox13;
GtkWidget  *statusb_view;
GtkWidget  *view_file_read;
GtkWidget *button_matrix_g;   /* global to deselect when cancel */
GtkWidget *button_matrix_r;   /* global to deselect when cancel */
GtkWidget *button_matrix_u;   /*  global to deselect when cancel */
GtkWidget *button_matrix_file; /* global to deselect when cancel */
GtkWidget *button_matrix_test; /* global to select when cancel */

int is_view_fs_open;         /* 0 not opened, 1 opened */
int is_view_comparison;      /* 0 no  1 comparison required: file will be read but only differences shown */
double view_compare_out;
struct edita_str pview;      /* preferences view windows */
guchar *view_matvalue;       /* allocated in create_view_window, used by drawing routines */
guchar *rgb_view_matvalue;   /* allocated in create_view_window, used by drawing routines */
double *vrs, vrmax,vrmin;  /* allocated in create_view_window, sum of rows  and maximum and minimum values */
double *vcs, vcmax,vcmin;  /* allocated in create_view_window, sum of columns  and maximum and minimum values */
double *view_file_data;      /* allocated in create_view_window, data read from file */
char view_file_name[256];
int  view_dimension;
int view_is_file; /* 0=no 1=yes */
int view_file_activated; /* take note if button file has been selected */
int view_is_fake; /* 0=no 1=yes if no file or matrix is present */
double view_gray_levels[256]; /* non equispaced levels method */
int view_numlev[256];
double view_mat_max,view_mat_min,view_mat_qmin;
char VSBUF[256];
int fake_dim; /* 4 */
double fake_matrix[26]; /* fake matrix to load in event of missing data  fortran style indexes 4 x 4 */

/* globals interface.c */
int is_view_matrix_open; /* 0=not open  1=open */
int is_debug;    /* 1= debugging output active on console 0=normal */
struct running_problem_str committed,  completed; /* we save data here after successfully allocate the matrices with the data in committed */

/* globals rw.c */
char pathgru_fs[512];    /* save name of last visited path */
