/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 1.2 - Nov 2006                                     *
 **************************************************************
 *
 *  examples.c  
 *  description of each example in this file
 *  corresponding fortran routine in file examplesf.f90
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include "structures.h"
#include "examples.h"

/* loads in memory examples data */
void
init_examples(void)
{
examples_no=8;  /* number of examples to appear in main menu Examples - min 1 max 9 */

es[1].num=1;
es[1].type = 1;
sprintf((es[1]).name,"Example 1:  QBD   ");
sprintf(es[1].descr1,"\tPositive recurrent QBD defined by the matrices AN1, A0, A1:\n");
sprintf(es[1].descr2,"\tdo i=1,m\n\t\tAN1(:,i)=0.8d0*i\n\tend do\n\tdo i=1,m\n\t\tdo j=1,m\n\t\tA0(i,j)=(i+j)/(2.d0*m)\n\t\tA1(i,j)=abs(i-j)/(4.d0*m)\n\t\tend do\n\tend do\n\t!normalization\n\tT=AN1+A0+A1\n\tdo i=1,m\n\t\ts=sum(T(i,:))\n\t\tAN1(i,:)=AN1(i,:)/s\n\t\tA0(i,:)=A0(i,:)/s\n\t\tA1(i,:)=A1(i,:)/s\n\tend do");
sprintf(es[1].descr3,"\n\tB0=AN1+A0;\tBN1=AN1;\tB1=A1;\n\n\tIn this example AN1 has rank 1.\n");
sprintf(es[1].descr4,"\tThe dimension m can be chosen between 2 and 5,000 (default 3). Use the first editable cell to change dimension.\n");

es[1].is_dim_variable=0;
es[1].is_m_equal_n=0;
es[1].dimension_m=3;
es[1].dimension_n=3;
es[1].dimension_diff=0;
es[1].is_matrix_variable=1;
es[1].is_a_equal_m=1; /* no */
es[1].matrix_a_num=3;
es[1].matrix_b_num=1;
es[1].is_b=1;
es[1].is_b0=1;
es[1].is_bn1=1;
es[1].is_alpha=0;
es[1].alpha=0.001;
es[1].is_beta=0;
es[1].beta=12.0;

es[2].num=2;
es[2].type = 1;
sprintf((es[2]).name,"Example 2: QBD   ");
sprintf(es[2].descr1,"\tPositive recurrent QBD defined by the matrices AN1, A0, A1:\n");
sprintf(es[2].descr2,"\tdo i=1,m\n\t\tdo j=1,m\n\t\t\tA0(i,j)=m+6-abs(i-j)\n\t\tend do\n\tend do\n\tA1=AN1;\t A0=0;\n\tAN1(1,1)=AN1(1,1)+alpha");
sprintf(es[2].descr3,"\n\t!normalization:\n\tT=AN1+A0+A1\n\tdo i=1,m\n\t\ts=sum(T(i,:))\n\t\tAN1(i,:)=AN1(i,:)/s\n\t\tA1(i,:)=A1(i,:)/s\n\tend do\n\tB0=AN1+A0;\tBN1=AN1;\tB1=A1;\n\n");
sprintf(es[2].descr4,"\tThe dimension m can be chosen between 2 and 5,000 (default 20)\n\tUse the first editable cell to change dimension.\n\n");

sprintf(es[2].descr5,"\n \t\tSmall values of alpha>0 make the problem close to null recurrent\n\n");
es[2].is_dim_variable=0;
es[2].is_m_equal_n=0;
es[2].dimension_m=20;
es[2].dimension_n=20;
es[2].dimension_diff=0;
es[2].is_matrix_variable=1;
es[2].is_a_equal_m=1; /* no */
es[2].matrix_a_num=3;
es[2].matrix_b_num=1;
es[2].is_b=1;
es[2].is_b0=1;
es[2].is_bn1=1;
es[2].is_alpha=1;
es[2].alpha=1.0E-5;
es[2].is_beta=0;
es[2].beta=0;

es[3].num=3;
es[3].type = 1;
sprintf((es[3]).name,"Example 3: QBD   ");
sprintf(es[3].descr1,"\tPositive recurrent QBD defined by the matrices AN1, A0, A1:\n");
sprintf(es[3].descr2,"\tAN1=0;\tA0=0;\tA1=0\n\tdo i=1,m\n\t\tdo j=1,m\n\t\tif((abs(i-j).le.1) then\n\t\tAN1(i,j)=abs(2*i-3*j)\n\t\tA0(i,j)=(i+j)/(2.d0*m)\n\t\tA1(i,j)=abs(i-j)/(4.d0*m)\n\t\tend do\n\tend do\n");
sprintf(es[3].descr3,"\t!normalization:\n\tT=AN1+A0+A1\n\tdo i=1,m\n\t\ts=sum(T(i,:))\n\t\tAN1(i,:)=AN1(i,:)/s\n\t\tA1(i,:)=A1(i,:)/s\n\tend do\n\tB0=AN1;\tBN1=AN1(1:m,1:n);\tB1=A1(1:n,1:m)\n\n");
sprintf(es[3].descr4,"\tThe dimension m can be chosen between 2 and 5,000 (default 20); n=m-1.\n\tUse the first editable cell to change m.\n\n\tIn this example the matrices are tridiagonal\n");
es[3].is_dim_variable=0;
es[3].is_m_equal_n=0;
es[3].dimension_m=20;
es[3].dimension_n=19;
es[3].dimension_diff=1;
es[3].is_matrix_variable=1;
es[3].is_a_equal_m=1; /* no */
es[3].matrix_a_num=3;
es[3].matrix_b_num=1;
es[3].is_b=1;
es[3].is_b0=1;
es[3].is_bn1=1;
es[3].is_alpha=0;    
es[3].alpha=0;    
es[3].is_beta=0;     
es[3].beta=0;     

es[4].num=4;
es[4].type = 2;
sprintf((es[4]).name,"Example 4: M/G/1 ");
sprintf(es[4].descr1,"\tA D-BMAP/D/1 queue modelled as an M/G/1-type Markov chain \n");
sprintf(es[4].descr2,"\n\tD-BMAP is a superposition of ON/OFF sources as introduced in [C. Blondia, A discrete-time batch Markovian arrival process as B-ISDN traffic model, 1993].\n");
sprintf(es[4].descr3,"\tThe number of ON/OFF sources is m-1, where m is the dimension the matrices Ai. \n\tBoth the ON and OFF period are geometric with a mean of 1/alpha slots.\n");
sprintf(es[4].descr4,"\tWhile ON, a source generates a packet with probability 1/beta.\n\n\tThe system is positive recurrent if (m-1)/(2 beta)<1.\n\tThe number of blocks Ai is equal to m.\n");
sprintf(es[4].descr5,"\n\tThe user can modify m, alpha and beta.\n");
es[4].is_dim_variable=0;
es[4].is_m_equal_n=0;
es[4].dimension_m=21;
es[4].dimension_n=21;
es[4].dimension_diff=0;
es[4].is_matrix_variable=1;
es[4].is_a_equal_m=0; /* yes */
es[4].matrix_a_num=21;
es[4].matrix_b_num=20;
es[4].is_b=1;
es[4].is_b0=1;
es[4].is_bn1=0;
es[4].is_alpha=1;
es[4].alpha=0.010;
es[4].is_beta=1;
es[4].beta=12.0;

es[5].num=5;
es[5].type = 2;
sprintf((es[5]).name,"Example 5: M/G/1 ");
sprintf((es[5]).descr1,"\t A Positive recurrent Markov Chain defined by the 3x3 matrices\n\n");
sprintf((es[5]).descr2,"\n\tA3=0;A2=0;\n\tA3(1,3)=1.d0;A3(2,1)=1.d0;A3(3,2)=1.d0\n\tA2(1,1)=1.d0;A2(2,2)=2.d0;A2(3,3)=3.d0\n\tA1=A2+A3\n\tA0=A1+A2\n\tAN1=A1+A0+2.01d0*A3");
sprintf(es[5].descr3,"\t!normalization:\n\tT=AN1+A0+A1+A2+A3\n\tdo i=1,3\n\t\ts=sum(T(i,:))\n\t\tAN1(i,:)=AN1(i,:)/s\n\t\tA0(i,:)=A0(i,:)/s\n\t\tA1(i,:)=A1(i,:)/s\n\t\tA2(i,:)=A2(i,:)/s\n\t\tA3(i,:)=A3(i,:)/s\n\tend do\n\n");
sprintf(es[5].descr4,"\tMoreover, the block B0 has size 2x2 and the blocks B1,B2,B3 have size 2x3, while BN1 has size 3x2, and they are given by\n\tB1=B2=B3=1.d0/11; B0=1.d0/11; BN1=sum(AN1(1,:))");


es[5].is_dim_variable=1;
es[5].is_m_equal_n=1;
es[5].dimension_m=3;
es[5].dimension_n=2;
es[5].dimension_diff=1;
es[5].is_matrix_variable=1;
es[5].is_a_equal_m=1; /* no */
es[5].matrix_a_num=5;
es[5].matrix_b_num=3;
es[5].is_b=1;
es[5].is_b0=1;
es[5].is_bn1=1;
es[5].is_alpha=0;
es[5].alpha=0;
es[5].is_beta=0;
es[5].beta=0;

es[6].num=6;
es[6].type = 3;
sprintf((es[6]).name,"Example 6: GI/M/1");
sprintf((es[6]).descr1,"\t A Transient Markov Chain defined by \n\n");
sprintf((es[6]).descr2,"\n\tA1(1,:)=1/4; \n\tA1(2,1)=1/4; A1(2,2)=3/16;  A1(2,3)=1/4;\n\tA1(3,1)=0; A1(3,2)=1/4; A1(3,3)=1/2;\n\n\t A0=0  except  A0(1,1)=1/8; A0(2,2)=1/16; A0(3,3)=1/8\n\n\tAN1=AN2=AN3=0\n\n\tAN4=0  except  AN4(1,2)=AN4(2,1)=AN1(2,3)=AN1(3,2)=1/8;\n\n\t where m=3.");

es[6].is_dim_variable=1;
es[6].is_m_equal_n=1;
es[6].dimension_m=3;
es[6].dimension_n=3;
es[6].dimension_diff=0;
es[6].is_matrix_variable=1;
es[6].is_a_equal_m=1; /* no */
es[6].matrix_a_num=6;
es[6].matrix_b_num=0;
es[6].is_b=0;
es[6].is_b0=0;
es[6].is_bn1=0;
es[6].is_alpha=0;
es[6].alpha=0;
es[6].is_beta=0;
es[6].beta=0;

es[7].num=7;
es[7].type = 3;
sprintf((es[7]).name,"Example 7: GI/M/1");
sprintf((es[7]).descr1,"\t A Positive Recurrent Markov Chain with 3x3 blocks\n\n");
sprintf((es[7]).descr2,"\tA1=0,  A1(1,1)=1/8; A1(2,2)=1/4; A1(3,3)=3/8;\n\tA0=0, A0(1,2)=1/8; A0(2,1)=1/8; A0(2,3)=1/8; A0(3,2)=1/8;\n\tAN1=AN2=AN3=0\n\tAN4=1/4,  AN4(2,2)=0;\n\n\tThe blocks B0,BN1,BN2,BN3,BN4 have size 3x3, they are zero everywhere except for the first column given by:");
sprintf((es[7]).descr3,"\n\tB0(:,1)=1-sum(A1,dim=2)\n\tBN1(:,1)=B0(:,1)-sum(A0,dim=2)\n\tBN2(:,1)=BN1(:,1)-sum(AN1,dim=2)\n\tBN3(:,1)=BN2(:,1)-sum(AN2,dim=2)\n\tBN4(:,1)=BN3(:,1)-sum(AN3,dim=2)\n\n");
sprintf((es[7]).descr4,"\t In this example cyclic reduction with  the shift technique has a break down just at the first iteration. In fact the matrix function phi_odd is singular at -1\n\n");

es[7].is_dim_variable=1;
es[7].is_m_equal_n=1;
es[7].dimension_m=3;
es[7].dimension_n=3;
es[7].dimension_diff=0;
es[7].is_matrix_variable=1;
es[7].is_a_equal_m=1; /* no */
es[7].matrix_a_num=6;
es[7].matrix_b_num=4;
es[7].is_b=1;
es[7].is_b0=1;
es[7].is_bn1=0;
es[7].is_alpha=0;
es[7].alpha=0;
es[7].is_beta=0;
es[7].beta=0;

es[8].num=8;
es[8].type = 1;
sprintf((es[8]).name,"Example 8: QBD");
sprintf((es[8]).descr1,"\t QBD obtained by reblocking the GI/M/1 Markov chain of Example 7\n\n");
sprintf((es[8]).descr3,"\t Unlike Example 7, the shift technique has not a breakdown for this reblocked problem\n");


es[8].is_dim_variable=1;
es[8].is_m_equal_n=1;
es[8].dimension_m=12;
es[8].dimension_n=12;
es[8].dimension_diff=0;
es[8].is_matrix_variable=1;
es[8].is_a_equal_m=1; /* no */
es[8].matrix_a_num=3;
es[8].matrix_b_num=0;
es[8].is_b=0;
es[8].is_b0=1;
es[8].is_bn1=1;
es[8].is_alpha=0;
es[8].alpha=0;
es[8].is_beta=0;
es[8].beta=0;

}
