/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 1.2 - Nov 2006                                     *
 **************************************************************
 *
 *  edit-b.h - view and edit B0, B, BN1  - both callbacks and interfaces
 *
 */


/* prototypes edit_b.c  */
void create_edit_b_window(void);
void on_edit_b_menu_quit_activate   (GtkMenuItem  *, gpointer );
void on_edit_b_menu_destroy_activate   (GtkWidget  *, gpointer);
gboolean draw_matareab_callback (GtkWidget *, GdkEventExpose *, gpointer );
gboolean xy_matareab (GtkWidget *, GdkEventExpose *, gpointer );
gboolean button_press_matareab (GtkWidget *, GdkEventExpose *, gpointer );
void on_edit_b_button_up_activate (GtkButton   *, gpointer  );
void on_edit_b_button_down_activate (GtkButton   *, gpointer  );
void on_edit_b_block_entry_changed  (GtkEntry *, gpointer );
void on_edit_b_block_entry_activated  (GtkEntry *, gpointer );
void on_edit_b_pos_neg_activate(GtkButton *, gpointer );
void on_edit_b_color_activate(GtkButton *, gpointer);
void on_edit_b_enhance_activate(GtkButton *, gpointer);
void on_edit_b_contrast_changed(GtkEntry *, gpointer );
void on_edit_b_user_activate(GtkButton *, gpointer);
void on_edit_b_range_normal_activate(GtkButton *, gpointer);
void on_edit_b_range_block_activate(GtkButton *, gpointer);
void on_edit_b_range_adaptive_activate(GtkButton *, gpointer);
void on_edit_b_transpose_activate(GtkButton *, gpointer);
void on_edit_b_normalize_activate(GtkButton *, gpointer);
void on_edit_b_truncate_activate(GtkButton *, gpointer);
void on_edit_b_exchange_activate(GtkButton *, gpointer);
void on_edit_b_float_entry_activate(GtkEntry *, gpointer);
void image_computeb(int );
void draw_matareab(void);

int b_labels_update(void);
int b_edit_status_update(void);
double st_def(void);
double bbmax(int);
double bbmin(int);
double bbqmin(int);
double bamax(void);
double bamin(void);
void bbtrunc(int );
void batrunc(void);
void max_min_bb_compute(void);

void gray_levelsb_setup(double); /* setup of  gray_levels */
int get_gray_levelb(double); 
void recompute_levelsb(double); /*adaptive case levels recompute (with contrast) */

/* prototypes edit_a.c  */
double st_def_b(int ); /* B stocasticity */
double bbbmin(void);  /* B0, BN1, B minimun */

/* prototipes ponte.f90 */
void read_mata_(int *,int *,int *, double *);
void write_mata_(int *,int *,int *, double *);
void transpose_mata_(void);
void normalize_mata_(void);
void read_matb_(int *,int *,int *, double *);
void write_matb_(int *,int *,int *, double *);
void read_matb0_(int *,int *, double *);
void write_matb0_(int *,int *, double *);
void read_matbn1_(int *,int *, double *);
void write_matbn1_(int *,int *, double *);


/* prototypes rw.c */
int watch_for_number(int , int , char *);

/* globals  edit_b.c  */
GtkWidget * window_edit_b;
GtkWidget  *matareab;
GtkWidget *statusb_editb; 
GtkWidget   *entryb_ij; 
GtkWidget   *entryb_aij;
GtkWidget *entry_blockb;
GtkWidget *labelb_space;
GtkWidget *edit_labelb_user;
GtkWidget *label_222b, *label_231b, *label_232b;
GtkWidget *button_range_normalb;
GtkWidget *button_range_blockb;
GtkWidget *edit_vbox12b,*edit_vbox13b;
double gray_levelsb[256]; /* non equispaced levels method */
int numlevb[256]; /* number of points in levels */
char SBUFB[256]; /* statusbar buffer used by b_edit_status_update() */
int b_selected_block,b_computed_block,b_displayed_block,b_no_block_selected; /* -1=BN1, 0=B0, 1... B blocks */
int b_dim_m,b_dim_n,b_d; /* dimensions of the selected block ; BN1, B0, B have different dimensions b_d is the max of the two */
unsigned char *matvalueb; /* allocated in create_edit_b_window, used by drawing routines */
guchar *rgb_matvalueb; /* allocated in create_edit_b_window, used by drawing routines */
double *bs, bsmax,bsmin;       /* allocated in create_edit_b_window, sum of rows of block and maximum value of bock */
double matbbmax, matbbmin,matbbqmin; /*   maximum , minimum and non zero minimum value in the bock */
int is_freezeb_aij;       /* 0=not freeze, 1= freeze entry i,j A and permit editing A value */
int is_frozenb_i,is_frozenb_j; /* values when frozen */
double is_frozenb;	     

/* globals interface.c */
int is_edit_b_open;  /* 0=not open  1=open */
int is_debug;    /* 1= debugging output active on console 0=normal */
struct running_problem_str committed;
struct edita_str peb; /* preferences edit a */
