!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! file pwcr_int.f90                                           !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!    IMPROVED CYCLIC REDUCTION FOR SOLVING QUEUEING PROBLEMS  !
!                   by D.A. Bini and B. Meini                 !
!             (bini@dm.unipi.it    meini@dm.unipi.it)         !
!        Fortran 90 Program version 1.0, January 30 1997      !
!               Interface File for PWCR subroutines           !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Interface file for the subroutines:                         !
!     pwcr                                                    !
!     computeG                                                !
!     residual                                                !
!     schur                                                   !
!     test                                                    !
!     sc1p                                                    !
!     sc2p                                                    !
!     scc2p                                                   !
!     sc1                                                     !
!     sc2                                                     !
!     prodc                                                   !
!     means                                                   !
!     pmeans                                                  !
!     scc2                                                    !
!     solver                                                  !
!     solvec                                                  !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  Included in                                                !
!  Structured Markov Chains Solver      [  SMCSolver  ]       !
!  Version 1.2 - Nov 2006                                     !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


module pwcr_interface
  INTERFACE 
     SUBROUTINE pwcr(a,eps,g,err,itmax,intpmax)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: a
       REAL(KIND(0.d0)), DIMENSION(:,:)   :: g
       REAL(KIND(0.d0))                            :: err, eps
       integer :: itmax,intpmax

     END SUBROUTINE pwcr
  endinterface
  !=============================================================
  INTERFACE
     SUBROUTINE computeG(a0,a0s,ae,ao,hae,hao,eps,g)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: ae, ao, hae, hao
       REAL(KIND(0.d0)), DIMENSION(:,:)   :: a0, g
       REAL(KIND(0.d0)), DIMENSION(:)     :: a0s
       REAL(KIND(0.d0))                            :: eps
     END SUBROUTINE computeG
  endinterface
  !====================================================================
  INTERFACE
     SUBROUTINE residual(a,g,err)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: a
       REAL(KIND(0.d0)), DIMENSION(:,:)   :: g
       REAL(KIND(0.d0))                            :: err
     END SUBROUTINE residual
  endinterface
  INTERFACE 
     SUBROUTINE spwcr(a,eps,g,err,itmax,intpmax)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: a
       REAL(KIND(0.d0)), DIMENSION(:,:)   :: g
       REAL(KIND(0.d0))                            :: err, eps
       integer :: itmax,intpmax
     END SUBROUTINE spwcr
  endinterface
  INTERFACE
     SUBROUTINE scomputeG(a0,hao,g)
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: hao
       REAL(KIND(0.d0)), DIMENSION(:,:)   :: a0, g
      END SUBROUTINE scomputeG
  endinterface
END MODULE pwcr_interface
!=======================================================================
!=======================================================================
MODULE schur_interface
  INTERFACE
     SUBROUTINE schur(ae,ao,hae,hao,mean,hmean,a1s,a0norm,eps,intpmaxl)
       IMPLICIT NONE
       REAL(KIND(0.d0)), allocatable, DIMENSION(:,:,:) :: ae, ao, hae, hao
       REAL(KIND(0.d0)), DIMENSION(:)     :: mean, hmean, a1s
       REAL(KIND(0.d0))                            :: eps,a0norm
       integer :: intpmaxl
     END SUBROUTINE schur
  END INTERFACE
  !=======================================================================
  INTERFACE 
     SUBROUTINE test(u,mean,eps,answer)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: u
       REAL(KIND(0.d0)), DIMENSION(:)     :: mean
       REAL(KIND(0.d0))                            :: eps
       LOGICAL                                     :: answer
     END SUBROUTINE test
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE sc1p(tae,tao,a)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: tao, tae, a
     END SUBROUTINE sc1p
 END INTERFACE

  INTERFACE
     SUBROUTINE sschur(ae,ao,hae,hao,a0norm,eps,intpmaxl)
       IMPLICIT NONE
       REAL(KIND(0.d0)), allocatable, DIMENSION(:,:,:) :: ae, ao, hae, hao
       REAL(KIND(0.d0))                            :: eps,a0norm
       integer :: intpmaxl
     END SUBROUTINE sschur
  END INTERFACE
  INTERFACE 
     SUBROUTINE stest(u,eps,answer)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: u
       REAL(KIND(0.d0))                            :: eps
       LOGICAL                                     :: answer
     END SUBROUTINE stest
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE sc2p(tae,tao,a1,a2)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: tao, tae, a1, a2
     END SUBROUTINE sc2p
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE scc2p(thae,thao,a1,a2)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: thao, thae, a1, a2
     END SUBROUTINE scc2p
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE sc1(tae,tao,a)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: tae, tao, a
     END SUBROUTINE sc1
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE sc2(tae,tao,a1,a2)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: tae, tao, a1, a2
     END SUBROUTINE sc2
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE prodc(a,b,ir,ic,rmat,cmat)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: a, b
       REAL(KIND(0.d0)), DIMENSION(:,:)   :: rmat, cmat
       INTEGER                                     :: ir,ic
     END SUBROUTINE prodc
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE means(tae,tao,thae,mean,hmean)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: tae,tao, thae
       REAL(KIND(0.d0)), DIMENSION(:)     :: mean,hmean
     END SUBROUTINE means
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE pmeans(ae,ao,hae,hao,mean,hmean)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: ae,ao, hae, hao
       REAL(KIND(0.d0)), DIMENSION(:)     :: mean,hmean
     END SUBROUTINE pmeans
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE scc2(thae,thao,a1,a2)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:,:) :: thae,thao, a1, a2
     END SUBROUTINE scc2
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE solver(rmat,termr)
       IMPLICIT NONE
       REAL(KIND(0.d0)), DIMENSION(:,:) :: rmat,termr
     END SUBROUTINE solver
  END INTERFACE
  !=======================================================================
  INTERFACE
     SUBROUTINE solvec(cmat,termc)    
       IMPLICIT NONE
       COMPLEX(KIND(0.d0)), DIMENSION(:,:) :: cmat,termc
     END SUBROUTINE solvec
  END INTERFACE

END MODULE schur_interface














