function A=MG1_examples(examp)

if (examp==1)
    M=20; % number of on/off sources
    a=0.01; % 1/a = mean on time
    b=a; % 1/b = mean off time
    d=10.5; % probability of generating a packet when on is 1/d
    % system is pos. recurrent (for a=b) if M/(2d) < 1

    temp=zeros(M+1,M+1);
    temp(1,1)=1-M*b;
    temp(1,2)=M*b;
    for i=2:M
        temp(i,i-1)=(i-1)*a;
        temp(i,i+1)=(M-i+1)*b;
        temp(i,i)=1-temp(i,i-1)-temp(i,i+1);
    end;
    temp(M+1,M)=a*M;
    temp(M+1,M+1)=1-a*M;
    for j=0:M
        C=zeros(M+1,M+1);
        for i=0:M
            if (i >= j)
                C(i+1,i+1)=nchoosek(i,j)*(1/d)^j*((d-1)/d)^(i-j);
            end
        end
        if (sum(sum(C*temp))> 10^(-100))
            D(1:M+1,(M+1)*j+1:(M+1)*(j+1))=C*temp;
        end
    end
    A=D;
end
if (examp==2)
    % % Script dat de oplossing van een D-BMAP/D/1/K queueing systeem berekent als
    % % . de input D-BMAP een circulante D-BMAP is (onderliggende tijdseenheid is lengte
    % %   MPEG frame, wordt omgezet naar slot als onderliggende tijdseenheid) waarbij
    % %   het aantal arrivals in een slot bepaald wordt door een Poisson distributie
    % %   met gemiddelde rate ./ (# slots in een frame tijd),
    % % . de deterministische service tijd de tijd is om een pakket op de uitgaande link
    % %   te plaatsen (= slot)
    %
    % % Input
    % % -----
    % % Inlezen data circulant.  Pas evt. de naam van de files waaruit de data moet
    % % gelezen worden aan.
    % load bond circ per
    % load bond43 rate
    %
    % % File waarin output moet geschreven worden -> outfile
    % outfile = 'clrbond43';
    %

    % Size queueing systeem -> K  (K-1 bufferplaatsen, 1 server plaats)
    K = 101;

    %
    % % Definieer de rate van de uitgaande link (in Mbps) -> linkrate
    % linkrate = 37.44;
    %
    % % Definieer de pakketlengte (= payload + header) (in bytes) -> pakket
    % pakket = 53;
    %
    % % Definieer de lengte van een MPEG frame (in ms) -> frame
    % frame = 45;
    %

    % Om te bepalen welke matrices Q_i van de circulant relevante data bevatten
    % wordt die M bepaald waarvoor (Q_0 + Q_1 + ... + Q_M)e op alle posities
    % strikt groter is dan 1-grens.
    grens = 10^-15;


    rate = [0.14 0.2 0.5 1 1.4 2.7];
    circ = [0.2 0.5 0.3];
    per = 2;

    % ---------------------------------------------------------------------------

    % Bepaal dimensie circulant -> N
    N = length(rate);

    % Construeer transitiematrix circulant -> Q
    if per > 1
        first = zeros(1,N);
        i = 2 : per : N - per + 2;
        first(i) = circ;
    else
        first = circ;
    end;
    Q = zeros(N,N);
    for i = 1 : N
        Q(i,:) = [first(N-i+2:N) first(1:N-i+1)];
    end;

    % % Bereken de lengte van een slot (in microsec) -> slot.
    % slot = pakket * 8 / linkrate;
    %
    % % Bereken het aantal slots in een frame lengte -> x
    % x = frame * 1000 / slot;
    %
    % % Transformeer circulante D-BMAP naar D-BMAP met 1 slot als onderliggende
    % % tijdseenheid.  Veronderstel dat het aantal slots dat je in een toestand
    % % blijft geometrisch verdeeld is met gemiddelde x.
    % p = 1 - inv(x);
    % Q = (1-p) * Q;
    % Q = Q + p * eye(N);
    % rate = rate ./ x;

    % Construeer de matrices Q_i (i = 0, ...,M, waarbij M door grens bepaald
    % wordt) en plaats ze in een array fstrow = [Q_0 ... Q_M] als M <= K, en
    % fstrow = [Q_0 ... Q_K-1 Q*_K] waarbij Q*_K = sum_{k=k}^M Q_k als M > K.
    Qi = diag(exp(-rate)) * Q;
    Qsum = sum(Qi,2);
    i = 0;
    fstrow(1:N,1:N) = Qi;
    while sum(Qsum > 1-grens) < N
        i = i+1;
        Qi = diag(rate ./ i) * Qi;
        if i < K
            fstrow(:,i*N+1:(i+1)*N) = Qi;
        else
            fstrow(:,K*N+1:(K+1)*N) = fstrow(:,K*N+1:(K+1)*N) + Qi;
        end;
        Qsum = Qsum + sum(Qi,2);
    end;

    t = find(fstrow < 0);
    fstrow(t) = 0;

    % Normaliseer rijen van fstrow
    Qsum = sum(fstrow,2);
    fstrow = diag(1./Qsum) * fstrow;

    % % Bereken systeembezetting -> sysoccup
    % sysoccup = grassmann(N,K+1,fstrow,fstrow);
    %
    % % Bereken ook de matrix Ql met K kolommen waar kolom i (i=0,...,K-1) de
    % % vector Qi*e bevat.
    % Ql = zeros(N,K);
    % for i = 0 : (size(fstrow,2)/N)-1;
    %    Ql(:,i+1) = sum(fstrow(:,i*N+1:(i+1)*N),2);
    % end;
    %
    % % Bereken de gemiddelde arrivalrate
    % lambda = sum(rate) / N;
    %
    % % Bereken de pakket loss ratio
    % loss = clr(Ql,lambda,K,sysoccup);
    %
    % % Bewaar sysoccup en loss in outputfile
    % eval(['save ' outfile ' sysoccup loss K linkrate pakket frame']);
    %
    %
    A=fstrow;
end
