/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 1.1 - Oct 2006                                     *
 **************************************************************
 *
 *  callbacks.h
 *
 */

int pthread_getcpuclockid(pthread_t thread_id, clockid_t *clock_id);

/* prototypes callback.c */
void on_main_menu_reada_activate (GtkMenuItem *, gpointer );
void on_main_menu_readb_activate (GtkMenuItem *, gpointer );
void on_main_menu_savea_activate (GtkMenuItem *, gpointer );
void on_main_menu_saveb_activate (GtkMenuItem *, gpointer );
void on_main_menu_saveg_activate (GtkMenuItem *, gpointer );
void on_main_menu_saver_activate (GtkMenuItem *, gpointer );
void on_main_menu_saveu_activate (GtkMenuItem *, gpointer );
void on_main_menu_savegru_activate (GtkMenuItem *, gpointer );
void on_main_menu_savepi_activate (GtkMenuItem *, gpointer );
void on_main_menu_imptel_activate (GtkMenuItem *, gpointer );
void on_main_menu_exptel_activate (GtkMenuItem *, gpointer );
void on_main_menu_savepad_activate (GtkMenuItem *, gpointer  );
void on_main_menu_clearpad_activate(GtkMenuItem *, gpointer  );
void on_main_menu_quit_activate    (GtkMenuItem *, gpointer  );
void on_main_menu_about_activate   (GtkMenuItem *, gpointer  );
void on_main_menu_run_activate     (GtkMenuItem *, gpointer  );
void * start_computation(void); /* starts fortran computation in a separate thread */
void on_main_menu_stop_activate    (GtkMenuItem *, gpointer  );
void on_main_menu_edit_a_activate(GtkMenuItem *, gpointer);
void on_main_menu_edit_b_activate(GtkMenuItem *, gpointer);
void on_main_menu_view_matrix_activate(GtkMenuItem *, gpointer);
void on_main_menu_view_pi_activate(GtkMenuItem *, gpointer );
void on_main_menu_help_activate    (GtkMenuItem *, gpointer  );
void on_about_closebutton_clicked  (GtkButton   *, gpointer  );
void on_help_closebutton_clicked   (GtkButton   *, gpointer  );
void on_cancel_button_fs1_clicked      (GtkButton   *, gpointer  );
void on_ok_button_fs1_clicked  (GtkButton   *, gpointer  );
void on_main_menu_quit_enter       (GtkMenuItem *, gpointer  );
void on_main_menu_quit_leave       (GtkMenuItem *, gpointer  );
void on_main_menu_problem_gm1      (GtkMenuItem *, gpointer );
void on_main_menu_problem_mg1      (GtkMenuItem *, gpointer );
void on_main_menu_problem_qbd      (GtkMenuItem *, gpointer );
void on_main_menu_problem_examples_e    (GtkMenuItem *, gpointer );
void on_main_menu_problem_examples_l    (GtkMenuItem *, gpointer );
void on_main_menu_problem_example1    (GtkMenuItem *, gpointer );
void on_main_menu_problem_example2    (GtkMenuItem *, gpointer );
void on_main_menu_problem_example3    (GtkMenuItem *, gpointer );
void on_main_menu_problem_example4    (GtkMenuItem *, gpointer );
void on_main_menu_problem_example5    (GtkMenuItem *, gpointer );
void on_main_menu_problem_example6    (GtkMenuItem *, gpointer );
void on_main_menu_problem_example7    (GtkMenuItem *, gpointer );
void on_main_menu_problem_example8    (GtkMenuItem *, gpointer );
void on_main_menu_problem_example9    (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_cyclicr_basic (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_cyclicr_shift (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_cyclicr_diag (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_logarithmicr_basic (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_logarithmicr_shift (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_logarithmicr_gth (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_basic0 (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_basic1 (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_basic_u (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_shift (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_shift_u (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_natural (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_traditional (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_Ubased (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_funciter_readX(GtkMenuItem *, gpointer );
void on_main_menu_algorithms_invarsubsp_basic (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_invarsubsp_balzer (GtkMenuItem *, gpointer );
void on_main_menu_algorithms_invarsubsp_shur (GtkMenuItem *, gpointer );
void on_main_menu_goals_qbd_g (GtkMenuItem *, gpointer );
void on_main_menu_goals_qbd_gr (GtkMenuItem *, gpointer );
void on_main_menu_goals_qbd_gru (GtkMenuItem *, gpointer );
void on_main_menu_goals_qbd_grupi (GtkMenuItem *, gpointer );
void on_main_menu_goals_mg1_g (GtkMenuItem *, gpointer );
void on_main_menu_goals_mg1_gpi  (GtkMenuItem *, gpointer );
void on_main_menu_goals_gim1_r (GtkMenuItem *, gpointer );
void on_main_menu_goals_gim1_rpi (GtkMenuItem *, gpointer );
void on_main_menu_goals_pi_param (GtkMenuItem *, gpointer );
void on_main_menu_options_verbose (GtkMenuItem *, gpointer );
void on_main_menu_options_debug (GtkMenuItem *, gpointer );
void on_main_menu_options_timings (GtkMenuItem *, gpointer );
void on_main_menu_options_situation (GtkMenuItem *, gpointer );
void on_main_menu_options_eigth_d (GtkMenuItem *, gpointer );
void on_main_menu_options_fifteen_d (GtkMenuItem *, gpointer );
void on_main_menu_options_sixteen_d (GtkMenuItem *, gpointer );
void on_main_menu_options_seventeen_d (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_cr (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_lr (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_fi (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_is (GtkMenuItem *, gpointer );
void on_main_menu_options_parameters_reset (GtkMenuItem *, gpointer );
void on_examples_quit_activate    (GtkButton *, gpointer  );
void on_examples_ok_activate    (GtkButton *, gpointer  );
void on_dimension_m_entry_changed  (GtkEntry *, gpointer );
void on_dimension_n_entry_changed  (GtkEntry *, gpointer );
void on_array_n_entry_changed  (GtkEntry *, gpointer );
void on_blocks_n_entry_changed  (GtkEntry *, gpointer);
void on_examples_alpha_activate(GtkEntry *, gpointer );
void on_examples_alpha_change(GtkEntry *, gpointer );
void on_examples_alpha_e_change(GtkEntry *, gpointer );
void on_examples_beta_activate(GtkEntry *, gpointer );
void on_examples_beta_change(GtkEntry *, gpointer );
void on_examples_beta_e_change(GtkEntry *, gpointer );
void on_parameters_quit_activate (GtkButton *, gpointer);
void on_parameters_ok_activate (GtkButton *, gpointer);
void on_parameters_reset_activate (GtkButton *, gpointer);
void on_parameters_entry_itermax_changed (GtkEntry *, gpointer );
void on_parameters_entry_interpmax_changed (GtkEntry *, gpointer );
void on_parameters_entry_errmax_changed (GtkEntry *, gpointer );
void on_pi_parameters_quit_activate (GtkButton *, gpointer);
void on_pi_parameters_ok_activate (GtkButton *, gpointer);
void on_pi_parameters_reset_activate (GtkButton *, gpointer);
void on_parameters_entry_epspi_changed(GtkButton *, gpointer);
void on_parameters_entry_maxnc_changed(GtkButton *, gpointer);

void clean_statusb(void);
void update_completed(void);
void invalidate_completed(void);
void parameters_setup(void);
void check_for_a_sparse(void);
int examples_statusb_update(void);
gint stop_computations(void);

/* prototypes help.c */
void create_window_about(void);   
void create_window_help(void);

/* prototypes interface.c */
GtkWidget* create_window_examples (int);
GtkWidget* create_window_parameters(int);
GtkWidget* create_window_pi_parameters(void);

/* prototypes padwrite.c */
gint fifo_inwin(void);
void append_fifo_(char *text); 
gint selection_uptodaten(void);
gint delayed_close(void);
gint pi_delayed_close(void);
gint delayed_examples_close(void);


/* prototypes rw.c */
GtkWidget* create_fileselection_reada(void);
GtkWidget* create_fileselection_readb(void);
GtkWidget* create_fileselection_savea(void);
GtkWidget* create_fileselection_saveb(void);
GtkWidget* create_fileselection_g(void);
GtkWidget* create_fileselection_r(void);
GtkWidget* create_fileselection_u(void);
GtkWidget* create_fileselection_gru(void);
GtkWidget* create_fileselection_pi(void);
GtkWidget* create_fileselection1 (void);
GtkWidget* create_dialog_nowritable(void);
int watch_for_number(int , int , char *);
GtkWidget* create_fileselection_X(void);

/* prototypes edit_a.c  */
void create_edit_a_window(void);
double st_def(void);
double aamin(void);
double st_def_b(int ); /* B stocasticity */
double bbbmin(void);  /* B0, BN1, B minimun */

/* prototypes edit_b.c  */
void create_edit_b_window(void);

/* prototypes view_mat.c */
void create_view_window(void);

/* prototypes view_pi.c */
void create_view_pi_window(void);

/* prototypes ponte.f90 */
/* note: Fortran exports names in lower case only, so read_matA becomes read_mata_  ... */
void getfdrift_(double *); 
/* matrice A(k,i,j) */
void alloc_mata_(int *,int *, int *);
void read_mata_(int *,int *,int *, double *);
void write_mata_(int *,int *,int *, double *);
void dump_mata_(void);
/* matrice G(i,j) */
void alloc_matg_(int *, int *);
void read_matg_(int *,int *, double *);
void write_matg_(int *,int *, double *);
void dump_matg_(void);
/* matrice U(i,j) */
void alloc_matu_(int *, int *);
void read_matu_(int *,int *, double *);
void write_matu_(int *,int *, double *);
void dump_matu_(void);
/* matrice R(i,j) */
void alloc_matr_(int *, int *);
void read_matr_(int *,int *, double *);
void write_matr_(int *,int *, double *);
void dump_matr_(void);
/* matrice Pi(i,j) */
/* push some C option globals on ponte_f_ globals */
void set_options_(int *,int *,int *);
/* some routines need to transpose A and to get A stochastic */
void transpose_mata_(void);
void normalize_mata_(void);

/* prototypes fcalls.f90  */
void qbd_cr_solve_(int *,int *, int *,int *,int *);
void qbd_lr_solve_(int *,int *, int *,int *,int *);
void qbd_fi_solve_(int *,int *, int *,int *,int *);
void qbd_is_solve_(int *,int *, int *,int *,int *);
void qbd_pi_ponte_(int *,int *, int *, int *, int *);
void mg1_cr_solve_(int *,int *, int *,int *,int *,int *);
void mg1_fi_solve_(int *,int *, int *,int *,int *);
void mg1_is_solve_(int *,int *, int *,int *,int *);
void mg1_pi_ponte_(int *,int *, int *, int *, int *);
void gim1_cr_solve_(int *,int *, int *,int *,int *,int *);
void gim1_lr_solve_(int *,int *, int *,int *,int *);
void gim1_fi_solve_(int *,int *, int *,int *,int *);
void gim1_is_solve_(int *,int *, int *,int *,int *);
void gim1_pi_ponte_(int *,int *, int *, int *, int *);


/* prototypes examplesf.f90 */
void examples_setup_(int *,int *,int *,int *,int *,int *,double *,double *);

/* globals callback.c */
int  my_iret;
pthread_t my_thread_main;
pthread_t my_thread_computation;
int selected_a_problem; /* 1=QBD 2=M/G/1 3=GI/M/1, used for passinf info from Main Menu Callbacks to Read A Window */
char ESBUF[256]; /* to write on status bar of example window via examples_statusb_update */
int is_examples_to_wait; /* 0 no wait 1 wait 2 seconds before closing (error message to be showed in statusbar) */


/* globals interface.c */
GtkWidget *textview;
GtkWidget *statusb;
GtkWidget *window_examples;
GtkWidget *dimension_m_entry;
GtkWidget *dimension_n_entry;
GtkWidget *alpha_entry;
GtkWidget *beta_entry;
GtkWidget *howmany_a_entry;
GtkWidget *statusb_examples;
GtkWidget *statusb_parameters;
GtkWidget  *parameters_entry_itermax,*parameters_entry_interpmax,*parameters_entry_errmax; /* parameters window entry */
GtkWidget * window_parameters;
GtkWidget * window_pi_parameters;
GtkWidget *handlebox_s; /* to show the situation of all choice made */
int is_about_open;   /* 0 = not open 1 = open */
int is_help_open;    /* 0 = not open 1 = open */
int is_savepad_open; /* 0 = not open 1 = open */
int is_running;      /* 0 = not running 1 = running */
int is_verbose;  /* 1= verbose, 0= not verbose */
int is_debug;    /* 1= debugging output active on console 0=normal */
int is_timings;  /* 1= internal timing of fortran routines 0=normal */
int is_situation;    /* 0 = not show 1= show situation bar */
int is_parameters;   /* 0 = normal 1=to close */
int is_pi_parameters; /* 0 = normal 1=to close */
int is_pi_parameters_open; /* 0=not open  1=open */
int need_a_transpose;    /* some fortran routines need to transpose A: =0 not transposed =1 transposes */
int is_examples_open; /* 0 = not open 1 = open */
int is_edit_a_open;  /* 0=not open  1=open */
int is_edit_b_open;  /* 0=not open  1=open */
int is_view_matrix_open; /* 0=not open  1=open */
int is_readX_open; /* 0=not open  1=open */
int dimension_m;  /* used bye examples window */
int dimension_n;  /* used bye examples window */
int matrix_a_num; /* used bye examples window */
int matrix_b_num; /* used bye examples window */
double alpha_in_mant;    /* used bye examples window */
double alpha_in_exp;     /* used bye examples window */
double alpha_in;         /* used bye examples window */
double beta_in_mant;     /* used bye examples window */
double beta_in_exp;      /* used bye examples window */
double beta_in;          /* used bye examples window */
char digits_to_save[64]; /* string corresponding to the number format chosen to write in files */
struct parameters_str max[4],min[4],deflt[4],choice[4]; /* default parametres for each algorithm */
char param_interp_str[9][256], param_err_str[12][256]; /* actual strings used in combo */
struct pi_parameters_str pi_max,pi_min,pi_deflt,pi_choice; /* default parametres for pi parameters setup */
GtkWidget  *parameters_entry_maxnc,*parameters_entry_epspi;
struct algorithms_str algorithms_choice,algorithms_committed;
struct goals_str goals_choice,goals_committed;
struct running_problem_str committed, selected, completed; /* we save data here after successfully allocate the matrices with the data in committed */

/* globals main.c */
char my_host_name[512];
char my_prog_name[512];

/* globals examples.c */
int  selected_es;  /* which example has been selected by menu in main window */
int examples_no; /* number of possible examples 1.. 9 */
struct examples_str es[10];

/* globals rw.c */
GtkWidget *reada_fs;          /* File Selection Dialog for reading A      */
GtkWidget *readb_fs;          /* File Selection Dialog for reading B      */
GtkWidget *savea_fs;          /* File Selection Dialog for saving A       */
GtkWidget *saveb_fs;          /* File Selection Dialog for saving B       */
GtkWidget *saveg_fs;          /* File Selection Dialog for saving G       */
GtkWidget *saver_fs;          /* File Selection Dialog for saving R       */
GtkWidget *saveu_fs;          /* File Selection Dialog for saving U       */
GtkWidget *savegru_fs;        /* File Selection Dialog for saving G+R+U   */
GtkWidget *savepi_fs;         /* File Selection Dialog for saving Pi      */
GtkWidget *appendsave;        /* File Selection Dialog for saving Notepad  Main Window */
GtkWidget *readX_fs;          /* File Selection Dialog for reading A      */

int is_reada_open;      /* 0 = not open 1 = open */
int is_readb_open;      /* 0 = not open 1 = open */
int is_savea_open;      /* 0 = not open 1 = open */
int is_saveb_open;      /* 0 = not open 1 = open */
int is_saveg_open;      /* 0 = not open 1 = open */
int is_saver_open;      /* 0 = not open 1 = open */
int is_saveu_open;      /* 0 = not open 1 = open */
int is_savegru_open;    /* 0 = not open 1 = open */
int is_savepi_open;    /* 0 = not open 1 = open */

/* globals edit_a.c */
struct edita_str pea; /* preferences edit a */

/* globals edit_b.c */
struct edita_str peb; /* preferences edit a */

/* globals view_mat.c */
struct edita_str pview; /* preferences view windows */


/****************************/
