/**************************************************************
 * Structured Markov Chains Solver       [  SMCSolver  ]      *
 * Dario Bini, Beatrice Meini, Sergio Steffe'                 *
 * bini@dm.unipi.it, meini@dm.unipi.it, steffe@dm.unipi.it    *
 * Dipartimento di Matematica "Leonida Tonelli"               *
 * Largo Pontecorvo 5                                         *
 * 56127 Pisa                                                 *
 * Italy                                                      *
 * Version 1.1 - Oct 2006                                     *
 **************************************************************
 *
 *  help.c  - about and  help window interfaces and callbacks
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include "structures.h"
#include "help.h"
#include "doc.h"

/* About Window */
void
create_window_about (void)
{
  GtkWidget *about_me;
  GtkWidget *frame;
  GtkWidget *dialog_vbox;
  GtkWidget *label;
  GtkWidget *dialog_action_area;
  GtkWidget *closebutton;

  about_me = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(about_me),"About Structured Markov Chains Solver");
  gtk_window_set_default_size (GTK_WINDOW (about_me),350,310);

  dialog_vbox = GTK_DIALOG (about_me)->vbox;
  gtk_widget_show (dialog_vbox);
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME(frame),GTK_SHADOW_ETCHED_IN);
  gtk_widget_show(frame);
  gtk_container_add(GTK_CONTAINER(dialog_vbox),frame); 
  label = gtk_label_new("\n\nStructured Markov Chains Solver\n\nDario Bini, Beatrice Meini, Sergio Steffe\'\n\nDipartimento di Matematica \"Leonida Tonelli\"\nUniversita\' di Pisa, Pisa, Italy\n {bini, meini, steffe}@dm.unipi.it\n\nVersion 1.1 Oct 2006\n\n");
  gtk_widget_show(label);
  gtk_container_add(GTK_CONTAINER(frame),label);
  
  dialog_action_area = GTK_DIALOG (about_me)->action_area;
  gtk_widget_show (dialog_action_area);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_SPREAD);
  closebutton = gtk_button_new_from_stock ("gtk-close");
  gtk_widget_show (closebutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (about_me), closebutton, GTK_RESPONSE_CLOSE);
  GTK_WIDGET_SET_FLAGS (closebutton, GTK_CAN_DEFAULT);
  gtk_widget_show(about_me);

  g_signal_connect ((gpointer) closebutton, "clicked", G_CALLBACK (on_about_closebutton_clicked), NULL);
  g_signal_connect ((gpointer) about_me, "delete_event", G_CALLBACK (on_about_closebutton_clicked),NULL); 
}
/*********************************/

/* Help Window */
void
create_window_help (void)
{
  GtkWidget *help_window;
  GtkWidget *dialog_vbox;
  GtkWidget *sections_hbox;
  GtkWidget *title_vbox;
  GtkWidget  *title0; 
  GtkWidget  *title1;
  GtkWidget  *title2;
  GtkWidget  *title3; 
  GtkWidget  *title4;
  GtkWidget  *title5;
  GtkWidget  *title6;
  GtkWidget  *title7;
  GtkWidget  *title8;
  GtkWidget  *title9;
  GtkWidget  *title10;
  GtkWidget  *biblio;
  GtkWidget  *credits;
  GtkWidget  *thanks;
  GtkWidget  *vseparator;
  GtkWidget *scrolledwindow;
  GtkWidget *textview;
  GtkWidget *dialog_action_area;
  GtkWidget *closebutton;
/*  GtkTextBuffer *bufferm;  global */
  
  help_window = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (help_window),"Structured Markov Chains Solver Help");

  gtk_window_set_position (GTK_WINDOW (help_window), GTK_WIN_POS_MOUSE);
  gtk_window_set_default_size (GTK_WINDOW (help_window), 780,640);

  dialog_vbox = GTK_DIALOG (help_window)->vbox;
  gtk_widget_show (dialog_vbox);
  sections_hbox = gtk_hbox_new(FALSE,0);
  gtk_widget_show (sections_hbox);
  gtk_container_add (GTK_CONTAINER (dialog_vbox), sections_hbox);
 
  title_vbox = gtk_vbox_new(FALSE,0);
  gtk_widget_show(title_vbox);
  gtk_box_pack_start (GTK_BOX (sections_hbox),title_vbox , FALSE, FALSE, 0);
/* fake button */
  title0 =  gtk_button_new_with_label("              ");
  gtk_widget_show (title0);
  gtk_button_set_relief (GTK_BUTTON(title0),GTK_RELIEF_NONE);
  gtk_box_pack_start (GTK_BOX (title_vbox),title0 , FALSE, FALSE, 0);
/* title buttons follow */
  title1 = gtk_button_new_with_label("Title");
  gtk_widget_show (title1);
  gtk_box_pack_start (GTK_BOX (title_vbox),title1 , FALSE, FALSE, 0);
  title2 = gtk_button_new_with_label("Introduction");
  gtk_widget_show (title2);
  gtk_box_pack_start (GTK_BOX (title_vbox),title2 , FALSE, FALSE, 0);
  title3 = gtk_button_new_with_label("M/G/1");
  gtk_widget_show (title3);
  gtk_box_pack_start (GTK_BOX (title_vbox),title3 , FALSE, FALSE, 0);
  title4 = gtk_button_new_with_label("GI/M/1");
  gtk_widget_show (title4);
  gtk_box_pack_start (GTK_BOX (title_vbox),title4 , FALSE, FALSE, 0);
  title5 = gtk_button_new_with_label("QBD");
  gtk_widget_show (title5);
  gtk_box_pack_start (GTK_BOX (title_vbox),title5 , FALSE, FALSE, 0);
  title6 = gtk_button_new_with_label("How to Use");
  gtk_widget_show (title6);
  gtk_box_pack_start (GTK_BOX (title_vbox),title6 , FALSE, FALSE, 0);
  title7 = gtk_button_new_with_label("Examples");
  gtk_widget_show (title7);
  gtk_box_pack_start (GTK_BOX (title_vbox),title7 , FALSE, FALSE, 0);
  title8 = gtk_button_new_with_label("I/O formats");
  gtk_widget_show (title8);
  gtk_box_pack_start (GTK_BOX (title_vbox),title8 , FALSE, FALSE, 0);
  title9 = gtk_button_new_with_label("Bugs");
  gtk_widget_show (title9);
  gtk_box_pack_start (GTK_BOX (title_vbox),title9 , FALSE, FALSE, 0);
  title10 = gtk_button_new_with_label("Compiling");
  gtk_widget_show (title10);
  gtk_box_pack_start (GTK_BOX (title_vbox),title10 , FALSE, FALSE, 0);

  biblio = gtk_button_new_with_label("Bibliography");
  gtk_widget_show (biblio);
  gtk_box_pack_start (GTK_BOX (title_vbox),biblio , FALSE, FALSE, 0);
  credits = gtk_button_new_with_label("Credits");
  gtk_widget_show (credits);
  gtk_box_pack_start (GTK_BOX (title_vbox),credits , FALSE, FALSE, 0);
  thanks = gtk_button_new_with_label("Thanks");
  gtk_widget_show (thanks);
  gtk_box_pack_start (GTK_BOX (title_vbox),thanks , FALSE, FALSE, 0);

/* end title buttons */
  vseparator = gtk_vseparator_new();
  gtk_widget_show (vseparator);
  gtk_box_pack_start (GTK_BOX (sections_hbox),vseparator, FALSE, FALSE, 0);
 
  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_start (GTK_BOX (sections_hbox), scrolledwindow, TRUE, TRUE, 0);
  textview = gtk_text_view_new ();
  gtk_widget_show (textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (textview), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (textview), GTK_WRAP_WORD);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textview), FALSE);
  /*gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (textview), 5);
  gtk_text_view_set_pixels_below_lines (GTK_TEXT_VIEW (textview), 5);*/
  gtk_text_view_set_indent (GTK_TEXT_VIEW (textview), 5);
  dialog_action_area = GTK_DIALOG (help_window)->action_area;
  gtk_widget_show (dialog_action_area);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_SPREAD);

  closebutton = gtk_button_new_from_stock ("gtk-close");
  gtk_widget_show (closebutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (help_window), closebutton, GTK_RESPONSE_CLOSE);
  GTK_WIDGET_SET_FLAGS (closebutton, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) closebutton, "clicked", G_CALLBACK (on_help_closebutton_clicked), NULL);
  g_signal_connect ((gpointer) help_window, "delete_event", G_CALLBACK (on_help_closebutton_clicked),NULL);
  g_signal_connect ((gpointer) title1, "clicked", G_CALLBACK (on_help_title1_clicked), NULL); 
  g_signal_connect ((gpointer) title2, "clicked", G_CALLBACK (on_help_title2_clicked), NULL); 
  g_signal_connect ((gpointer) title2, "clicked", G_CALLBACK (on_help_title2_clicked), NULL); 
  g_signal_connect ((gpointer) title3, "clicked", G_CALLBACK (on_help_title3_clicked), NULL); 
  g_signal_connect ((gpointer) title4, "clicked", G_CALLBACK (on_help_title4_clicked), NULL);
  g_signal_connect ((gpointer) title5, "clicked", G_CALLBACK (on_help_title5_clicked), NULL);
  g_signal_connect ((gpointer) title6, "clicked", G_CALLBACK (on_help_title6_clicked), NULL);
  g_signal_connect ((gpointer) title7, "clicked", G_CALLBACK (on_help_title7_clicked), NULL);
  g_signal_connect ((gpointer) title8, "clicked", G_CALLBACK (on_help_title8_clicked), NULL);
  g_signal_connect ((gpointer) title9, "clicked", G_CALLBACK (on_help_title9_clicked), NULL);
  g_signal_connect ((gpointer) title10, "clicked", G_CALLBACK (on_help_title10_clicked), NULL);
  g_signal_connect ((gpointer) biblio, "clicked", G_CALLBACK (on_help_biblio_clicked), NULL);
  g_signal_connect ((gpointer) credits, "clicked", G_CALLBACK (on_help_credits_clicked), NULL);
  g_signal_connect ((gpointer) thanks, "clicked", G_CALLBACK (on_help_thanks_clicked), NULL);

  bufferm = (GtkTextBuffer *) gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));
  on_help_title1_clicked(GTK_BUTTON(title1),NULL); 
  gtk_widget_show(help_window); 
}
/*********************************/

/* callbacks for help titles */

/* title */
void on_help_title1_clicked  (GtkButton       *button, gpointer         user_data)
{GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu10,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu11,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu12,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu13,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu14,-1);
}
/*********************************/

/* introduction */
void on_help_title2_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu20,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu21,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu22,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu23,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu24,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu25,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu26,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu27,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu28,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu29,-1);

}
/*********************************/

/* M/G/1 */
void on_help_title3_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu30,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu31,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu32,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu33,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu34,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu35,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu36,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu37,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu38,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu39,-1);

}
/*********************************/

/* GI/M/1 */
void on_help_title4_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu40,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu41,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu42,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu43,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu44,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu45,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu46,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu47,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu48,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu49,-1);

}
/*********************************/
 
/* QBD */
void on_help_title5_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu50,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu51,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu52,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu53,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu54,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu55,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu56,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu57,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu58,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu59,-1);

}
/*********************************/

/* how to use */
void on_help_title6_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu60,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu61,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu62,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu63,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu64,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu65,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu66,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu67,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu68,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu69,-1);

}
/*********************************/

/* examples */
void on_help_title7_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu70,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu71,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu72,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu73,-1);

}
/*********************************/

/* I/O formats */
void on_help_title8_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu80,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu81,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu82,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu83,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu84,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu85,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu86,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu87,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu88,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu89,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);


}
/*********************************/

/* bugs */
void on_help_title9_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu90,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu91,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu92,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu93,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu94,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu95,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu96,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu97,-1);


}
/*********************************/

/* compiling */
void on_help_title10_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu100,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu101,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu102,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu103,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu104,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu105,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);

}
/*********************************/

/* bibliography */
void on_help_biblio_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu110,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu111,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu112,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu113,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu114,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu115,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu116,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu117,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu118,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu119,-1);


}
/*********************************/

/* credits */
void on_help_credits_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu120,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu121,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu122,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu123,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu124,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu125,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu126,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu127,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu128,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu129,-1);


}
/*********************************/

/* thanks */
void on_help_thanks_clicked  (GtkButton       *button, gpointer         user_data)
{
GtkTextIter  enditerm;
gtk_text_buffer_set_text(bufferm,docu130,-1);
gtk_text_buffer_get_end_iter(bufferm,&enditerm);
gtk_text_buffer_insert(bufferm,&enditerm,docu131,-1);


}
/*****************************/
